/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.cte;

import java.util.concurrent.CompletionStage;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.reactive.query.sqm.mutation.internal.cte.ReactiveCteDeleteHandler;
import org.hibernate.reactive.query.sqm.mutation.internal.cte.ReactiveCteUpdateHandler;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableMutationStrategy;

public class ReactiveCteMutationStrategy
extends CteMutationStrategy
implements ReactiveSqmMultiTableMutationStrategy {
    public ReactiveCteMutationStrategy(EntityMappingType rootEntityType, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(rootEntityType.getEntityPersister(), runtimeModelCreationContext);
    }

    public ReactiveCteMutationStrategy(EntityPersister rootDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        super(rootDescriptor, runtimeModelCreationContext);
    }

    @Override
    public CompletionStage<Integer> reactiveExecuteUpdate(SqmUpdateStatement<?> sqmUpdateStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.checkMatch((SqmDeleteOrUpdateStatement)sqmUpdateStatement);
        return new ReactiveCteUpdateHandler(this.getIdCteTable(), sqmUpdateStatement, domainParameterXref, this, this.getSessionFactory()).reactiveExecute(context);
    }

    @Override
    public CompletionStage<Integer> reactiveExecuteDelete(SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.checkMatch((SqmDeleteOrUpdateStatement)sqmDeleteStatement);
        return new ReactiveCteDeleteHandler(this.getIdCteTable(), sqmDeleteStatement, domainParameterXref, this, this.getSessionFactory()).reactiveExecute(context);
    }
}

