/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveTemporaryTableHelper;
import org.hibernate.reactive.util.impl.CompletionStages;

public interface ReactiveGlobalTemporaryTableStrategy {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public static String sessionIdentifier(SharedSessionContractImplementor session) {
        return session.getSessionIdentifier().toString();
    }

    public boolean isPrepared();

    public void setPrepared(boolean var1);

    public boolean isDropIdTables();

    public void setDropIdTables(boolean var1);

    public TemporaryTable getTemporaryTable();

    public CompletionStage<Void> getDropTableActionStage();

    public CompletionStage<Void> getCreateTableActionStage();

    public SessionFactoryImplementor getSessionFactory();

    default public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess, CompletableFuture<Void> tableCreatedStage) {
        if (this.isPrepared()) {
            return;
        }
        this.setPrepared(true);
        ConfigurationService configService = (ConfigurationService)mappingModelCreationProcess.getCreationContext().getBootstrapContext().getServiceRegistry().getService(ConfigurationService.class);
        boolean createIdTables = (Boolean)configService.getSetting("hibernate.query.mutation_strategy.global_temporary.create_tables", StandardConverters.BOOLEAN, (Object)true);
        if (!createIdTables) {
            tableCreatedStage.complete(null);
        }
        LOG.debugf("Creating global-temp ID table : %s", this.getTemporaryTable().getTableExpression());
        this.connectionStage().thenCompose(this::createTable).whenComplete((connection, throwable) -> this.releaseConnection((ReactiveConnection)connection).thenAccept(v -> {
            if (throwable == null) {
                this.setDropIdTables(configService);
                tableCreatedStage.complete(null);
            } else {
                tableCreatedStage.completeExceptionally((Throwable)throwable);
            }
        }));
    }

    private CompletionStage<Void> releaseConnection(ReactiveConnection connection) {
        if (connection == null) {
            return CompletionStages.voidFuture();
        }
        try {
            return connection.close().handle((unused, t) -> {
                ReactiveGlobalTemporaryTableStrategy.logConnectionClosedError(t);
                return null;
            });
        }
        catch (Throwable t2) {
            ReactiveGlobalTemporaryTableStrategy.logConnectionClosedError(t2);
            return CompletionStages.voidFuture();
        }
    }

    private static void logConnectionClosedError(Throwable t) {
        if (t != null) {
            LOG.debugf("Ignoring error closing the connection: %s", t.getMessage());
        }
    }

    private CompletionStage<ReactiveConnection> createTable(ReactiveConnection connection) {
        try {
            return new ReactiveTemporaryTableHelper.TemporaryTableCreationWork(this.getTemporaryTable(), this.getSessionFactory()).reactiveExecute(connection).thenApply(v -> connection);
        }
        catch (Throwable t) {
            return CompletionStages.failedFuture(t);
        }
    }

    private void setDropIdTables(ConfigurationService configService) {
        this.setDropIdTables((Boolean)configService.getSetting("hibernate.query.mutation_strategy.global_temporary.drop_tables", StandardConverters.BOOLEAN, (Object)false));
    }

    private CompletionStage<ReactiveConnection> connectionStage() {
        try {
            return ((ReactiveConnectionPool)this.getSessionFactory().getServiceRegistry().getService(ReactiveConnectionPool.class)).getConnection();
        }
        catch (Throwable t) {
            return CompletionStages.failedFuture(t);
        }
    }

    default public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess, CompletableFuture<Void> tableDroppedStage) {
        if (!this.isDropIdTables()) {
            tableDroppedStage.complete(null);
        }
        this.setDropIdTables(false);
        TemporaryTable temporaryTable = this.getTemporaryTable();
        LOG.debugf("Dropping global-tempk ID table : %s", temporaryTable.getTableExpression());
        this.connectionStage().thenCompose(this::dropTable).whenComplete((connection, throwable) -> this.releaseConnection((ReactiveConnection)connection).thenAccept(v -> {
            if (throwable == null) {
                tableDroppedStage.complete(null);
            } else {
                tableDroppedStage.completeExceptionally((Throwable)throwable);
            }
        }));
    }

    private CompletionStage<ReactiveConnection> dropTable(ReactiveConnection connection) {
        try {
            return new ReactiveTemporaryTableHelper.TemporaryTableDropWork(this.getTemporaryTable(), this.getSessionFactory()).reactiveExecute(connection).thenApply(v -> connection);
        }
        catch (Throwable t) {
            return CompletionStages.failedFuture(t);
        }
    }
}

