/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntityAssembler;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;

public class ReactiveEntityInitializerImpl
extends EntityInitializerImpl
implements ReactiveInitializer<EntityInitializerImpl.EntityInitializerData> {
    public ReactiveEntityInitializerImpl(EntityResultGraphNode resultDescriptor, String sourceAlias, Fetch identifierFetch, Fetch discriminatorFetch, DomainResult<?> keyResult, DomainResult<Object> rowIdResult, NotFoundAction notFoundAction, boolean affectedByFilter, InitializerParent<?> parent, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(resultDescriptor, sourceAlias, identifierFetch, discriminatorFetch, keyResult, rowIdResult, notFoundAction, affectedByFilter, parent, isResultInitializer, creationState);
    }

    protected void resolveEntityKey(EntityInitializerImpl.EntityInitializerData original, Object id) {
        ReactiveEntityInitializerData data = (ReactiveEntityInitializerData)original;
        if (data.getConcreteDescriptor() == null) {
            data.setConcreteDescriptor(ReactiveEntityInitializerImpl.determineConcreteEntityDescriptor((RowProcessingState)data.getRowProcessingState(), (BasicResultAssembler)this.getDiscriminatorAssembler(), (EntityPersister)this.getEntityDescriptor()));
            assert (data.getConcreteDescriptor() != null);
        }
        data.setEntityKey(new EntityKey(id, data.getConcreteDescriptor()));
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(Object instance, EntityInitializerImpl.EntityInitializerData original) {
        ReactiveEntityInitializerData data = (ReactiveEntityInitializerData)original;
        if (instance == null) {
            this.setMissing(data);
            return CompletionStages.voidFuture();
        }
        data.setInstance(instance);
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)data.getInstance());
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (lazyInitializer == null) {
            data.setEntityInstanceForNotify(data.getInstance());
            data.setConcreteDescriptor(session.getEntityPersister(null, data.getInstance()));
            this.resolveEntityKey(data, data.getConcreteDescriptor().getIdentifier(data.getInstance(), session));
            data.setEntityHolder(session.getPersistenceContextInternal().getEntityHolder(data.getEntityKey()));
            if (data.getEntityHolder() == null) {
                return this.reactiveResolveKey(data).thenRun(() -> {
                    assert (data.getState() == Initializer.State.MISSING);
                    assert (this.getInitializedPart() instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)this.getInitializedPart()).getSideNature() == ForeignKeyDescriptor.Nature.TARGET);
                });
            }
            data.setState(data.getEntityHolder().getEntityInitializer() == null ? Initializer.State.INITIALIZED : Initializer.State.RESOLVED);
        } else if (lazyInitializer.isUninitialized()) {
            data.setState(Initializer.State.RESOLVED);
            EntityPersister persister = this.getDiscriminatorAssembler() == null ? this.getEntityDescriptor() : ReactiveEntityInitializerImpl.determineConcreteEntityDescriptor((RowProcessingState)rowProcessingState, (BasicResultAssembler)this.getDiscriminatorAssembler(), (EntityPersister)this.getEntityDescriptor());
            data.setConcreteDescriptor(persister);
            assert (data.getConcreteDescriptor() != null);
            this.resolveEntityKey(data, lazyInitializer.getIdentifier());
            data.setEntityHolder(session.getPersistenceContextInternal().claimEntityHolderIfPossible(data.getEntityKey(), null, rowProcessingState.getJdbcValuesSourceProcessingState(), (EntityInitializer)this));
            data.setEntityInstanceForNotify(this.resolveEntityInstance(data));
            lazyInitializer.setImplementation(data.getEntityInstanceForNotify());
            this.registerLoadingEntity(data, data.getEntityInstanceForNotify());
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setEntityInstanceForNotify(lazyInitializer.getImplementation());
            data.setConcreteDescriptor(session.getEntityPersister(null, data.getEntityInstanceForNotify()));
            this.resolveEntityKey(data, lazyInitializer.getIdentifier());
            data.setEntityHolder(session.getPersistenceContextInternal().getEntityHolder(data.getEntityKey()));
        }
        return this.reactiveInitializeStage(data, rowProcessingState).thenCompose(v -> {
            this.upgradeLockMode(data);
            if (data.getState() == Initializer.State.INITIALIZED) {
                this.registerReloadedEntity(data);
                this.resolveInstanceSubInitializers(data);
                if (rowProcessingState.needsResolveState()) {
                    this.resolveState(data);
                }
                return CompletionStages.voidFuture();
            }
            return this.reactiveResolveKeySubInitializers(data);
        });
    }

    private CompletionStage<Void> reactiveInitializeStage(ReactiveEntityInitializerData data, RowProcessingState rowProcessingState) {
        Initializer initializer;
        if (this.getIdentifierAssembler() != null && (initializer = this.getIdentifierAssembler().getInitializer()) != null) {
            if (initializer instanceof ReactiveInitializer) {
                return ((ReactiveInitializer)initializer).reactiveResolveInstance(data.getEntityKey().getIdentifier(), rowProcessingState);
            }
            initializer.resolveInstance(data.getEntityKey().getIdentifier(), rowProcessingState);
        }
        return CompletionStages.voidFuture();
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(EntityInitializerImpl.EntityInitializerData original) {
        ReactiveEntityInitializerData data = (ReactiveEntityInitializerData)original;
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return CompletionStages.voidFuture();
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.setState(Initializer.State.RESOLVED);
        if (data.getEntityKey() == null) {
            assert (this.getIdentifierAssembler() != null);
            Object id = this.getIdentifierAssembler().assemble(rowProcessingState);
            if (id == null) {
                this.setMissing(data);
                return CompletionStages.voidFuture();
            }
            this.resolveEntityKey(data, id);
        }
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
        data.setEntityHolder(persistenceContext.claimEntityHolderIfPossible(data.getEntityKey(), null, rowProcessingState.getJdbcValuesSourceProcessingState(), (EntityInitializer)this));
        if (!this.useEmbeddedIdentifierInstanceAsEntity(data)) {
            return this.reactiveResolveEntityInstance1(data).thenAccept(v -> {
                if (data.getUniqueKeyAttributePath() != null) {
                    SharedSessionContractImplementor session = rowProcessingState.getSession();
                    EntityPersister concreteDescriptor = this.getConcreteDescriptor(data);
                    EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), data.getUniqueKeyAttributePath(), rowProcessingState.getEntityUniqueKey(), data.getUniqueKeyPropertyTypes()[concreteDescriptor.getSubclassId()], session.getFactory());
                    session.getPersistenceContextInternal().addEntity(euk, data.getInstance());
                }
                this.postResolveInstance(data);
            });
        }
        data.setEntityInstanceForNotify(rowProcessingState.getEntityId());
        data.setInstance(data.getEntityInstanceForNotify());
        this.postResolveInstance(data);
        return CompletionStages.voidFuture();
    }

    private void postResolveInstance(ReactiveEntityInitializerData data) {
        if (data.getInstance() != null) {
            this.upgradeLockMode(data);
            if (data.getState() == Initializer.State.INITIALIZED) {
                this.registerReloadedEntity(data);
                if (data.getRowProcessingState().needsResolveState()) {
                    this.resolveState(data);
                }
            }
            if (data.getShallowCached()) {
                this.initializeSubInstancesFromParent(data);
            }
        }
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(EntityInitializerImpl.EntityInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return CompletionStages.voidFuture();
        }
        if (!this.skipInitialization(data)) {
            assert (this.consistentInstance(data));
            return this.reactiveInitializeEntityInstance((ReactiveEntityInitializerData)data);
        }
        data.setState(Initializer.State.INITIALIZED);
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<Void> reactiveInitializeEntityInstance(ReactiveEntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object entityIdentifier = data.getEntityKey().getIdentifier();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        return this.reactiveExtractConcreteTypeStateValues(data).thenAccept(resolvedEntityState -> {
            PersistentAttributeInterceptor persistentAttributeInterceptor;
            this.preLoad(data, (Object[])resolvedEntityState);
            if (ManagedTypeHelper.isPersistentAttributeInterceptable((Object)data.getEntityInstanceForNotify()) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable((Object)data.getEntityInstanceForNotify()).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                data.getConcreteDescriptor().getBytecodeEnhancementMetadata().injectInterceptor(data.getEntityInstanceForNotify(), entityIdentifier, session);
            }
            data.getConcreteDescriptor().setPropertyValues(data.getEntityInstanceForNotify(), resolvedEntityState);
            persistenceContext.addEntity(data.getEntityKey(), data.getEntityInstanceForNotify());
            this.registerPossibleUniqueKeyEntries(data, (Object[])resolvedEntityState, session);
            Object version = this.getVersionAssembler() != null ? this.getVersionAssembler().assemble(rowProcessingState) : null;
            Object rowId = this.getRowIdAssembler() != null ? this.getRowIdAssembler().assemble(rowProcessingState) : null;
            LockMode lockModeToAcquire = data.getLockMode() == LockMode.NONE ? LockMode.READ : data.getLockMode();
            EntityEntry entityEntry = persistenceContext.addEntry(data.getEntityInstanceForNotify(), Status.LOADING, resolvedEntityState, rowId, data.getEntityKey().getIdentifier(), version, lockModeToAcquire, true, data.getConcreteDescriptor(), false);
            data.getEntityHolder().setEntityEntry(entityEntry);
            this.registerNaturalIdResolution(data, persistenceContext, (Object[])resolvedEntityState);
            this.takeSnapshot(data, session, persistenceContext, entityEntry, (Object[])resolvedEntityState);
            data.getConcreteDescriptor().afterInitialize(data.getEntityInstanceForNotify(), session);
            assert (data.getConcreteDescriptor().getIdentifier(data.getEntityInstanceForNotify(), session) != null);
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
                statistics.loadEntity(data.getConcreteDescriptor().getEntityName());
            }
            this.updateCaches(data, session, session.getPersistenceContextInternal(), (Object[])resolvedEntityState, version);
        });
    }

    protected CompletionStage<Object[]> reactiveExtractConcreteTypeStateValues(ReactiveEntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object[] values = new Object[data.getConcreteDescriptor().getNumberOfAttributeMappings()];
        DomainResultAssembler[] concreteAssemblers = this.getAssemblers()[data.getConcreteDescriptor().getSubclassId()];
        return CompletionStages.loop(0, values.length, i -> {
            DomainResultAssembler assembler = concreteAssemblers[i];
            if (assembler instanceof ReactiveEntityAssembler) {
                return ((ReactiveEntityAssembler)assembler).reactiveAssemble((ReactiveRowProcessingState)rowProcessingState).thenAccept(assembled -> {
                    values[i] = assembled;
                });
            }
            values[i] = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(v -> values);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CompletionStage<Void> reactiveResolveEntityInstance1(ReactiveEntityInitializerData data) {
        block14: {
            block16: {
                block17: {
                    block15: {
                        boolean unwrapProxy;
                        Object proxy = data.getEntityHolder().getProxy();
                        boolean bl = unwrapProxy = proxy != null && this.getInitializedPart() instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)this.getInitializedPart()).isUnwrapProxy() && this.getConcreteDescriptor(data).getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
                        if (unwrapProxy || !this.isProxyInstance(proxy)) break block15;
                        Object entityFromExecutionContext = this.getEntityFromExecutionContext(data);
                        if (entityFromExecutionContext != null) {
                            data.setEntityInstanceForNotify(entityFromExecutionContext);
                            data.setInstance(data.getEntityInstanceForNotify());
                            this.registerReloadedEntity(data);
                            break block14;
                        } else {
                            data.setInstance(proxy);
                            if (Hibernate.isInitialized((Object)data.getInstance())) {
                                data.setState(Initializer.State.INITIALIZED);
                                data.setEntityInstanceForNotify(Hibernate.unproxy((Object)data.getInstance()));
                                break block14;
                            } else {
                                LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)data.getInstance());
                                assert (lazyInitializer != null);
                                return this.reactiveResolveEntityInstance2(data).thenAccept(entityInstance -> {
                                    data.setEntityInstanceForNotify(entityInstance);
                                    lazyInitializer.setImplementation(data.getEntityInstanceForNotify());
                                    this.ensureEntityIsInitialized(data);
                                });
                            }
                        }
                    }
                    Object existingEntity = data.getEntityHolder().getEntity();
                    if (existingEntity == null) break block16;
                    data.setEntityInstanceForNotify(existingEntity);
                    data.setInstance(data.getEntityInstanceForNotify());
                    if (data.getEntityHolder().getEntityInitializer() != null) break block17;
                    assert (data.getEntityHolder().isInitialized() == this.isExistingEntityInitialized(existingEntity));
                    if (data.getEntityHolder().isInitialized()) {
                        data.setState(Initializer.State.INITIALIZED);
                        break block14;
                    } else if (this.isResultInitializer()) {
                        this.registerLoadingEntity(data, data.getInstance());
                    }
                    break block14;
                }
                if (data.getEntityHolder().getEntityInitializer() != this) {
                    data.setState(Initializer.State.INITIALIZED);
                }
                break block14;
            }
            Object entityFromExecutionContext = this.getEntityFromExecutionContext(data);
            if (entityFromExecutionContext != null) {
                data.setEntityInstanceForNotify(entityFromExecutionContext);
                data.setInstance(data.getEntityInstanceForNotify());
                if (this.isResultInitializer()) {
                    this.registerLoadingEntity(data, data.getInstance());
                }
            } else {
                assert (data.getEntityHolder().getEntityInitializer() == this);
                return this.reactiveResolveEntityInstance2(data).thenAccept(entityInstance -> {
                    Initializer idInitializer;
                    data.setEntityInstanceForNotify(entityInstance);
                    data.setInstance(data.getEntityInstanceForNotify());
                    if (data.getEntityHolder().getEntityInitializer() == this && data.getState() != Initializer.State.INITIALIZED && this.getIdentifierAssembler() != null && (idInitializer = this.getIdentifierAssembler().getInitializer()) != null) {
                        idInitializer.initializeInstance(data.getRowProcessingState());
                    }
                    this.ensureEntityIsInitialized(data);
                });
            }
        }
        this.ensureEntityIsInitialized(data);
        return CompletionStages.voidFuture();
    }

    private void ensureEntityIsInitialized(ReactiveEntityInitializerData data) {
        assert (!data.getShallowCached() || data.getState() == Initializer.State.INITIALIZED) : "Forgot to initialize the entity";
    }

    protected CompletionStage<Object> reactiveResolveEntityInstance2(ReactiveEntityInitializerData data) {
        if (data.getEntityHolder().getEntityInitializer() == this) {
            assert (data.getEntityHolder().getEntity() == null);
            return this.reactiveResolveEntityInstance(data);
        }
        return CompletionStages.completedFuture(data.getEntityHolder().getEntity());
    }

    protected CompletionStage<Object> reactiveResolveEntityInstance(ReactiveEntityInitializerData data) {
        Object cached;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object resolved = this.resolveToOptionalInstance(data);
        if (resolved != null) {
            this.registerLoadingEntity(data, resolved);
            return CompletionStages.completedFuture(resolved);
        }
        if (rowProcessingState.isQueryCacheHit() && this.getEntityDescriptor().useShallowQueryCacheLayout()) {
            data.setState(Initializer.State.INITIALIZED);
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            assert (data.getEntityHolder().getEntityInitializer() == this);
            session.getPersistenceContextInternal().removeEntityHolder(data.getEntityKey());
            return ((ReactiveSession)session).reactiveInternalLoad(data.getConcreteDescriptor().getEntityName(), data.getEntityKey().getIdentifier(), true, false);
        }
        if (this.getEntityDescriptor().canUseReferenceCacheEntries() && (cached = this.resolveInstanceFromCache(data)) != null) {
            data.setState(Initializer.State.INITIALIZED);
            return CompletionStages.completedFuture(cached);
        }
        Object instance = this.instantiateEntity(data);
        this.registerLoadingEntity(data, instance);
        return CompletionStages.completedFuture(instance);
    }

    private Object resolveToOptionalInstance(ReactiveEntityInitializerData data) {
        if (this.isResultInitializer()) {
            JdbcValuesSourceProcessingOptions processingOptions = data.getRowProcessingState().getJdbcValuesSourceProcessingState().getProcessingOptions();
            return this.matchesOptionalInstance(data, processingOptions) ? processingOptions.getEffectiveOptionalObject() : null;
        }
        return null;
    }

    private boolean isProxyInstance(Object proxy) {
        return proxy != null && (proxy instanceof MapProxy || this.getEntityDescriptor().getJavaType().getJavaTypeClass().isInstance(proxy));
    }

    private Object resolveInstanceFromCache(ReactiveEntityInitializerData data) {
        return CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(data.getRowProcessingState().getSession().asEventSource(), null, data.getLockMode(), this.getEntityDescriptor(), data.getEntityKey());
    }

    private boolean matchesOptionalInstance(ReactiveEntityInitializerData data, JdbcValuesSourceProcessingOptions processingOptions) {
        Object optionalEntityInstance = processingOptions.getEffectiveOptionalObject();
        Object requestedEntityId = processingOptions.getEffectiveOptionalId();
        return requestedEntityId != null && optionalEntityInstance != null && requestedEntityId.equals(data.getEntityKey().getIdentifier());
    }

    private boolean isExistingEntityInitialized(Object existingEntity) {
        return Hibernate.isInitialized((Object)existingEntity);
    }

    @Override
    public CompletionStage<Void> reactiveResolveKey(EntityInitializerImpl.EntityInitializerData data) {
        return this.reactiveResolveKey((ReactiveEntityInitializerData)data, false);
    }

    protected CompletionStage<Void> reactiveResolveKey(ReactiveEntityInitializerData data, boolean entityKeyOnly) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return CompletionStages.voidFuture();
        }
        data.setState(Initializer.State.KEY_RESOLVED);
        data.setConcreteDescriptor(null);
        data.setEntityKey(null);
        data.setInstance(null);
        data.setEntityInstanceForNotify(null);
        data.setEntityHolder(null);
        Object[] id = new Object[1];
        return this.initializeId(data, id, entityKeyOnly).thenCompose(initialized -> {
            if (initialized.booleanValue()) {
                this.resolveEntityKey(data, id[0]);
                if (!entityKeyOnly) {
                    return this.reactiveResolveInstance(data).thenCompose(v -> {
                        if (!data.getShallowCached()) {
                            if (data.getState() == Initializer.State.INITIALIZED) {
                                if (data.getEntityHolder().getEntityInitializer() == null) {
                                    return this.reactiveResolveInstanceSubInitializers(data);
                                }
                                return this.reactiveResolveKeySubInitializers(data);
                            }
                            return this.reactiveResolveKeySubInitializers(data);
                        }
                        return CompletionStages.voidFuture();
                    });
                }
            }
            return CompletionStages.voidFuture();
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CompletionStage<Void> reactiveResolveInstanceSubInitializers(ReactiveEntityInitializerData data) {
        Object[] state;
        Initializer[] initializers = this.getSubInitializers()[data.getConcreteDescriptor().getSubclassId()];
        if (initializers.length == 0) {
            return CompletionStages.voidFuture();
        }
        EntityEntry entityEntry = data.getEntityHolder().getEntityEntry();
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        assert (entityEntry == rowProcessingState.getSession().getPersistenceContextInternal().getEntry(data.getEntityInstanceForNotify()));
        Object[] loadedState = entityEntry.getLoadedState();
        if (loadedState != null) {
            state = loadedState;
            return CompletionStages.loop(0, initializers.length, i -> {
                Initializer initializer = initializers[i];
                if (initializer != null) {
                    Object subInstance = state[i];
                    if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                        if (initializer instanceof ReactiveInitializer) {
                            return ((ReactiveInitializer)initializer).reactiveResolveKey(rowProcessingState);
                        }
                        initializer.resolveKey(rowProcessingState);
                    } else {
                        if (initializer instanceof ReactiveInitializer) {
                            return ((ReactiveInitializer)initializer).reactiveResolveInstance(subInstance, rowProcessingState);
                        }
                        initializer.resolveInstance(subInstance, rowProcessingState);
                    }
                }
                return CompletionStages.voidFuture();
            });
        }
        if (entityEntry.getStatus() == Status.READ_ONLY) {
            state = data.getConcreteDescriptor().getValues(data.getEntityInstanceForNotify());
            return CompletionStages.loop(0, initializers.length, i -> {
                Initializer initializer = initializers[i];
                if (initializer != null) {
                    Object subInstance = state[i];
                    if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                        if (initializer instanceof ReactiveInitializer) {
                            return ((ReactiveInitializer)initializer).reactiveResolveKey(rowProcessingState);
                        }
                        initializer.resolveKey(rowProcessingState);
                    } else {
                        if (initializer instanceof ReactiveInitializer) {
                            return ((ReactiveInitializer)initializer).reactiveResolveInstance(subInstance, rowProcessingState);
                        }
                        initializer.resolveInstance(subInstance, rowProcessingState);
                    }
                }
                return CompletionStages.voidFuture();
            });
        }
        if ($assertionsDisabled) return CompletionStages.voidFuture();
        if (entityEntry.getStatus() == Status.LOADING) return CompletionStages.voidFuture();
        throw new AssertionError();
    }

    protected CompletionStage<Void> reactiveResolveKeySubInitializers(ReactiveEntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        return CompletionStages.loop(this.getSubInitializers()[data.getConcreteDescriptor().getSubclassId()], initializer -> {
            if (initializer != null) {
                if (initializer instanceof ReactiveInitializer) {
                    return ((ReactiveInitializer)initializer).reactiveResolveKey(rowProcessingState);
                }
                initializer.resolveKey(rowProcessingState);
            }
            return CompletionStages.voidFuture();
        });
    }

    private CompletionStage<Boolean> initializeId(ReactiveEntityInitializerData data, Object[] id, boolean entityKeyOnly) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (this.getIdentifierAssembler() == null) {
            id[0] = rowProcessingState.getEntityId();
            assert (id[0] != null) : "Initializer requires a not null id for loading";
            return CompletionStages.trueFuture();
        }
        Initializer initializer = this.getIdentifierAssembler().getInitializer();
        if (initializer != null) {
            InitializerData subData = initializer.getData(rowProcessingState);
            return ((ReactiveInitializer)initializer).reactiveResolveKey(subData).thenCompose(v -> {
                if (subData.getState() == Initializer.State.MISSING) {
                    this.setMissing(data);
                    return CompletionStages.falseFuture();
                }
                data.setConcreteDescriptor(ReactiveEntityInitializerImpl.determineConcreteEntityDescriptor((RowProcessingState)rowProcessingState, (BasicResultAssembler)this.getDiscriminatorAssembler(), (EntityPersister)this.getEntityDescriptor()));
                assert (data.getConcreteDescriptor() != null);
                if (this.isKeyManyToOne()) {
                    if (!data.getShallowCached() && !entityKeyOnly) {
                        this.resolveKeySubInitializers(data);
                    }
                    return CompletionStages.falseFuture();
                }
                id[0] = this.getIdentifierAssembler().assemble(rowProcessingState);
                if (id[0] == null) {
                    this.setMissing(data);
                    return CompletionStages.falseFuture();
                }
                return CompletionStages.trueFuture();
            });
        }
        id[0] = this.getIdentifierAssembler().assemble(rowProcessingState);
        if (id[0] == null) {
            this.setMissing(data);
            return CompletionStages.falseFuture();
        }
        return CompletionStages.trueFuture();
    }

    protected EntityInitializerImpl.EntityInitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new ReactiveEntityInitializerData(this, rowProcessingState);
    }

    @Override
    public CompletionStage<Void> forEachReactiveSubInitializer(BiFunction<ReactiveInitializer<?>, RowProcessingState, CompletionStage<Void>> consumer, InitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        return CompletionStages.voidFuture().thenCompose(v -> {
            Initializer initializer;
            if (this.getKeyAssembler() != null && (initializer = this.getKeyAssembler().getInitializer()) != null) {
                return (CompletionStage)consumer.apply((ReactiveInitializer)initializer, rowProcessingState);
            }
            return CompletionStages.voidFuture();
        }).thenCompose(v -> {
            Initializer initializer;
            if (this.getIdentifierAssembler() != null && (initializer = this.getIdentifierAssembler().getInitializer()) != null) {
                consumer.apply((ReactiveInitializer)initializer, rowProcessingState);
            }
            return CompletionStages.voidFuture();
        }).thenCompose(v -> {
            ReactiveEntityInitializerDataAdaptor entityInitializerData = new ReactiveEntityInitializerDataAdaptor((EntityInitializerImpl.EntityInitializerData)data);
            if (entityInitializerData.getConcreteDescriptor() == null) {
                return CompletionStages.loop(this.getSubInitializers(), initializers -> CompletionStages.loop(initializers, initializer -> {
                    if (initializer != null) {
                        return (CompletionStage)consumer.apply((ReactiveInitializer)initializer, rowProcessingState);
                    }
                    return CompletionStages.voidFuture();
                }));
            }
            Initializer[] subInitializers = this.getSubInitializers()[entityInitializerData.getConcreteDescriptor().getSubclassId()];
            return CompletionStages.loop(subInitializers, initializer -> (CompletionStage)consumer.apply((ReactiveInitializer)initializer, rowProcessingState));
        });
    }

    @Override
    public Object getResolvedInstance(EntityInitializerImpl.EntityInitializerData data) {
        return super.getResolvedInstance((InitializerData)data);
    }

    private static class ReactiveEntityInitializerDataAdaptor
    extends EntityInitializerImpl.EntityInitializerData {
        public ReactiveEntityInitializerDataAdaptor(EntityInitializerImpl.EntityInitializerData delegate) {
            super(delegate);
        }

        public EntityPersister getConcreteDescriptor() {
            return this.concreteDescriptor;
        }
    }

    public static class ReactiveEntityInitializerData
    extends EntityInitializerImpl.EntityInitializerData {
        public ReactiveEntityInitializerData(EntityInitializerImpl initializer, RowProcessingState rowProcessingState) {
            super(initializer, rowProcessingState);
        }

        public void setEntityInstanceForNotify(Object instance) {
            this.entityInstanceForNotify = instance;
        }

        public Object getEntityInstanceForNotify() {
            return this.entityInstanceForNotify;
        }

        public EntityPersister getConcreteDescriptor() {
            return this.concreteDescriptor;
        }

        public void setConcreteDescriptor(EntityPersister entityPersister) {
            this.concreteDescriptor = entityPersister;
        }

        public EntityHolder getEntityHolder() {
            return this.entityHolder;
        }

        public void setEntityHolder(EntityHolder entityHolder) {
            this.entityHolder = entityHolder;
        }

        public EntityKey getEntityKey() {
            return this.entityKey;
        }

        public void setEntityKey(EntityKey entityKey) {
            this.entityKey = entityKey;
        }

        public String getUniqueKeyAttributePath() {
            return this.uniqueKeyAttributePath;
        }

        public Type[] getUniqueKeyPropertyTypes() {
            return this.uniqueKeyPropertyTypes;
        }

        public boolean getShallowCached() {
            return this.shallowCached;
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }
    }
}

