/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.internal;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveDomainResultsAssembler;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingResolution;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactiveStandardRowReader<R>
implements ReactiveRowReader<R> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final DomainResultAssembler<?>[] resultAssemblers;
    private final Initializer<InitializerData>[] resultInitializers;
    private final InitializerData[] resultInitializersData;
    private final Initializer<InitializerData>[] initializers;
    private final InitializerData[] initializersData;
    private final Initializer<InitializerData>[] sortedForResolveInstance;
    private final InitializerData[] sortedForResolveInstanceData;
    private final boolean hasCollectionInitializers;
    private final RowTransformer<R> rowTransformer;
    private final Class<R> domainResultJavaType;
    private final ComponentType componentType;
    private final Class<?> resultElementClass;
    private final int assemblerCount;

    public ReactiveStandardRowReader(JdbcValuesMappingResolution jdbcValuesMappingResolution, RowTransformer<R> rowTransformer, Class<R> domainResultJavaType) {
        this(jdbcValuesMappingResolution.getDomainResultAssemblers(), jdbcValuesMappingResolution.getResultInitializers(), jdbcValuesMappingResolution.getInitializers(), jdbcValuesMappingResolution.getSortedForResolveInstance(), jdbcValuesMappingResolution.hasCollectionInitializers(), rowTransformer, domainResultJavaType);
    }

    public ReactiveStandardRowReader(DomainResultAssembler<?>[] resultAssemblers, Initializer<?>[] resultInitializers, Initializer<?>[] initializers, Initializer<?>[] sortedForResolveInitializers, boolean hasCollectionInitializers, RowTransformer<R> rowTransformer, Class<R> domainResultJavaType) {
        this.resultAssemblers = resultAssemblers;
        this.resultInitializers = resultInitializers;
        this.resultInitializersData = new InitializerData[resultInitializers.length];
        this.initializers = initializers;
        this.initializersData = new InitializerData[initializers.length];
        this.sortedForResolveInstance = sortedForResolveInitializers;
        this.sortedForResolveInstanceData = new InitializerData[this.sortedForResolveInstance.length];
        this.hasCollectionInitializers = hasCollectionInitializers;
        this.rowTransformer = rowTransformer;
        this.domainResultJavaType = domainResultJavaType;
        this.assemblerCount = resultAssemblers.length;
        if (domainResultJavaType == null || domainResultJavaType == Object[].class || domainResultJavaType == Object.class || !domainResultJavaType.isArray() || resultAssemblers.length == 1 && domainResultJavaType == resultAssemblers[0].getAssembledJavaType().getJavaTypeClass()) {
            this.resultElementClass = Object.class;
            this.componentType = ComponentType.OBJECT;
        } else {
            this.resultElementClass = domainResultJavaType.getComponentType();
            this.componentType = ComponentType.determineComponentType(domainResultJavaType);
        }
    }

    public int getInitializerCount() {
        return this.initializers.length;
    }

    public boolean hasCollectionInitializers() {
        return this.hasCollectionInitializers;
    }

    public R readRow(RowProcessingState processingState) {
        throw LOG.nonReactiveMethodCall("reactiveReadRow");
    }

    @Override
    public CompletionStage<R> reactiveReadRow(ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        LoadingLogger.LOGGER.trace((Object)"ReactiveStandardRowReader#readRow");
        return this.coordinateInitializers(rowProcessingState).thenCompose(v -> {
            switch (this.componentType) {
                case BOOLEAN: {
                    return this.booleanComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case BYTE: {
                    return this.byteComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case CHAR: {
                    return this.charComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case SHORT: {
                    return this.shortComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case INT: {
                    return this.intComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case LONG: {
                    return this.longComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case FLOAT: {
                    return this.floatComponent(this.resultAssemblers, rowProcessingState, options);
                }
                case DOUBLE: {
                    return this.doubleComponent(this.resultAssemblers, rowProcessingState, options);
                }
            }
            return this.objectComponent(this.resultAssemblers, rowProcessingState, options);
        });
    }

    private CompletionStage<R> booleanComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        boolean[] resultRow = new boolean[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = (Boolean)obj;
                });
            }
            resultRow[i] = (Boolean)assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> byteComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        byte[] resultRow = new byte[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = (Byte)obj;
                });
            }
            resultRow[i] = (Byte)assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> charComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        char[] resultRow = new char[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = ((Character)obj).charValue();
                });
            }
            resultRow[i] = ((Character)assembler.assemble((RowProcessingState)rowProcessingState)).charValue();
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> shortComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        short[] resultRow = new short[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = (Short)obj;
                });
            }
            resultRow[i] = (Short)assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> intComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        int[] resultRow = new int[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = (Integer)obj;
                });
            }
            resultRow[i] = (Integer)assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> longComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        long[] resultRow = new long[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = (Long)obj;
                });
            }
            resultRow[i] = (Long)assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> floatComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        float[] resultRow = new float[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = ((Float)obj).floatValue();
                });
            }
            resultRow[i] = ((Float)assembler.assemble((RowProcessingState)rowProcessingState)).floatValue();
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> doubleComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        double[] resultRow = new double[resultAssemblers.length];
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = (Double)obj;
                });
            }
            resultRow[i] = (Double)assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return resultRow;
        });
    }

    private CompletionStage<R> objectComponent(DomainResultAssembler<?>[] resultAssemblers, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Object[] resultRow = (Object[])Array.newInstance(this.resultElementClass, resultAssemblers.length);
        return CompletionStages.loop(0, this.assemblerCount, i -> {
            DomainResultAssembler assembler = resultAssemblers[i];
            LoadingLogger.LOGGER.debugf("Calling top-level assembler (%s / %s) : %s", i, this.assemblerCount, (Object)assembler);
            if (assembler instanceof ReactiveDomainResultsAssembler) {
                return ((ReactiveDomainResultsAssembler)assembler).reactiveAssemble(rowProcessingState, options).thenAccept(obj -> {
                    resultRow[i] = obj;
                });
            }
            resultRow[i] = assembler.assemble((RowProcessingState)rowProcessingState);
            return CompletionStages.voidFuture();
        }).thenApply(ignore -> {
            this.afterRow(rowProcessingState);
            return this.rowTransformer.transformRow(resultRow);
        });
    }

    public EntityKey resolveSingleResultEntityKey(RowProcessingState rowProcessingState) {
        return null;
    }

    public Class<R> getDomainResultResultJavaType() {
        return this.domainResultJavaType;
    }

    public List<JavaType<?>> getResultJavaTypes() {
        ArrayList javaTypes = new ArrayList(this.resultAssemblers.length);
        for (DomainResultAssembler<?> resultAssembler : this.resultAssemblers) {
            javaTypes.add(resultAssembler.getAssembledJavaType());
        }
        return javaTypes;
    }

    private void afterRow(RowProcessingState rowProcessingState) {
        LoadingLogger.LOGGER.trace((Object)"ReactiveStandardRowReader#afterRow");
        this.finishUpRow();
    }

    private void finishUpRow() {
        for (InitializerData data : this.initializersData) {
            data.setState(Initializer.State.UNINITIALIZED);
        }
    }

    private CompletionStage<Void> coordinateInitializers(RowProcessingState rowProcessingState) {
        return CompletionStages.loop(0, this.resultInitializers.length, i -> this.resolveKey(this.resultInitializers[i], this.resultInitializersData[i])).thenCompose(v -> CompletionStages.loop(0, this.sortedForResolveInstance.length, i -> this.resolveInstance(this.sortedForResolveInstance[i], this.sortedForResolveInstanceData[i]))).thenCompose(v -> CompletionStages.loop(0, this.initializers.length, i -> this.initializeInstance(this.initializers[i], this.initializersData[i])));
    }

    private CompletionStage<Void> resolveKey(Initializer<InitializerData> initializer, InitializerData initializerData) {
        if (initializer instanceof ReactiveInitializer) {
            return ((ReactiveInitializer)initializer).reactiveResolveKey(initializerData);
        }
        initializer.resolveKey(initializerData);
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> resolveInstance(Initializer<InitializerData> initializer, InitializerData initializerData) {
        if (initializerData.getState() == Initializer.State.KEY_RESOLVED) {
            if (initializer instanceof ReactiveInitializer) {
                return ((ReactiveInitializer)initializer).reactiveResolveInstance(initializerData);
            }
            initializer.resolveInstance(initializerData);
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> initializeInstance(Initializer<InitializerData> initializer, InitializerData initializerData) {
        if (initializerData.getState() == Initializer.State.RESOLVED) {
            if (initializer instanceof ReactiveInitializer) {
                return ((ReactiveInitializer)initializer).reactiveInitializeInstance(initializerData);
            }
            initializer.initializeInstance(initializerData);
        }
        return CompletionStages.voidFuture();
    }

    public void startLoading(RowProcessingState processingState) {
        int i;
        for (i = 0; i < this.resultInitializers.length; ++i) {
            Initializer<InitializerData> initializer = this.resultInitializers[i];
            initializer.startLoading(processingState);
            this.resultInitializersData[i] = initializer.getData(processingState);
        }
        for (i = 0; i < this.sortedForResolveInstance.length; ++i) {
            this.sortedForResolveInstanceData[i] = this.sortedForResolveInstance[i].getData(processingState);
        }
        for (i = 0; i < this.initializers.length; ++i) {
            this.initializersData[i] = this.initializers[i].getData(processingState);
        }
    }

    public void finishUp(RowProcessingState rowProcessingState) {
        for (int i = 0; i < this.initializers.length; ++i) {
            this.initializers[i].endLoading(this.initializersData[i]);
        }
    }

    static enum ComponentType {
        BOOLEAN(Boolean.TYPE),
        BYTE(Byte.TYPE),
        SHORT(Short.TYPE),
        CHAR(Character.TYPE),
        INT(Integer.TYPE),
        LONG(Long.TYPE),
        FLOAT(Float.TYPE),
        DOUBLE(Double.TYPE),
        OBJECT(Object.class);

        private final Class<?> componentType;

        private ComponentType(Class<?> componentType) {
            this.componentType = componentType;
        }

        public static ComponentType determineComponentType(Class<?> resultType) {
            if (resultType == boolean[].class) {
                return BOOLEAN;
            }
            if (resultType == byte[].class) {
                return BYTE;
            }
            if (resultType == short[].class) {
                return SHORT;
            }
            if (resultType == char[].class) {
                return CHAR;
            }
            if (resultType == int[].class) {
                return INT;
            }
            if (resultType == long[].class) {
                return LONG;
            }
            if (resultType == float[].class) {
                return FLOAT;
            }
            if (resultType == double[].class) {
                return DOUBLE;
            }
            return OBJECT;
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }
    }
}

