/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.query.Order;
import org.hibernate.query.Page;
import org.hibernate.reactive.query.ReactiveQuery;
import org.hibernate.reactive.stage.Stage;

public class StageQueryImpl<R>
implements Stage.Query<R> {
    private final ReactiveQuery<R> delegate;

    public StageQueryImpl(ReactiveQuery<R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    @Override
    public CompletionStage<Long> getResultCount() {
        return this.delegate.getReactiveResultCount();
    }

    @Override
    public CompletionStage<List<R>> getResultList() {
        return this.delegate.getReactiveResultList();
    }

    @Override
    public FlushMode getFlushMode() {
        return this.delegate.getHibernateFlushMode();
    }

    @Override
    public Stage.Query<R> setFlushMode(FlushMode flushMode) {
        this.delegate.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public Stage.Query<R> setLockMode(LockMode lockMode) {
        this.delegate.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public Stage.SelectionQuery<R> setOrder(List<Order<? super R>> orders) {
        this.delegate.setOrder(orders);
        return this;
    }

    @Override
    public Stage.SelectionQuery<R> setOrder(Order<? super R> order) {
        this.delegate.setOrder((List)order);
        return this;
    }

    @Override
    public Stage.Query<R> setPlan(EntityGraph<R> entityGraph) {
        this.delegate.applyGraph((RootGraphImplementor)entityGraph, GraphSemantic.FETCH);
        return this;
    }

    @Override
    public Stage.SelectionQuery<R> enableFetchProfile(String profileName) {
        this.delegate.enableFetchProfile(profileName);
        return this;
    }

    @Override
    public CompletionStage<R> getSingleResult() {
        return this.delegate.getReactiveSingleResult();
    }

    @Override
    public CompletionStage<R> getSingleResultOrNull() {
        return this.delegate.getReactiveSingleResultOrNull();
    }

    @Override
    public Stage.Query<R> setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public Stage.Query<R> setReadOnly(boolean readOnly) {
        this.delegate.setReadOnly(readOnly);
        return this;
    }

    @Override
    public Stage.Query<R> setMaxResults(int maxResult) {
        this.delegate.setMaxResults(maxResult);
        return this;
    }

    @Override
    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    @Override
    public Stage.Query<R> setFirstResult(int startPosition) {
        this.delegate.setFirstResult(startPosition);
        return this;
    }

    @Override
    public Stage.SelectionQuery<R> setPage(Page page) {
        this.setFirstResult(page.getFirstResult());
        this.setMaxResults(page.getMaxResults());
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.delegate.getCacheStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.delegate.getCacheRetrieveMode();
    }

    @Override
    public Stage.Query<R> setCacheMode(CacheMode cacheMode) {
        this.delegate.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public Stage.Query<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this.delegate.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public Stage.Query<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this.delegate.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.delegate.isCacheable();
    }

    @Override
    public Stage.Query<R> setCacheable(boolean cacheable) {
        this.delegate.setCacheable(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.delegate.getCacheRegion();
    }

    @Override
    public Stage.Query<R> setCacheRegion(String cacheRegion) {
        this.delegate.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public Stage.Query<R> setLockMode(LockModeType lockMode) {
        this.delegate.setLockMode(lockMode);
        return this;
    }

    @Override
    public Stage.Query<R> setLockMode(String alias, LockMode lockMode) {
        this.delegate.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public Stage.Query<R> setParameter(String name, Object value) {
        this.delegate.setParameter(name, value);
        return this;
    }

    @Override
    public Stage.Query<R> setParameter(int position, Object value) {
        this.delegate.setParameter(position, value);
        return this;
    }

    @Override
    public <T1> Stage.Query<R> setParameter(Parameter<T1> param, T1 value) {
        this.delegate.setParameter((Parameter)param, (Object)value);
        return this;
    }

    @Override
    public String getComment() {
        return this.delegate.getComment();
    }

    @Override
    public Stage.Query<R> setComment(String comment) {
        this.delegate.setComment(comment);
        return this;
    }

    @Override
    public CompletionStage<Integer> executeUpdate() {
        return this.delegate.executeReactiveUpdate();
    }
}

