/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.util.async.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hibernate.reactive.util.impl.CompletionStages;

public final class AsyncTrampoline {
    private AsyncTrampoline() {
    }

    public static <T> CompletionStage<T> asyncWhile(Predicate<? super T> shouldContinue, Function<? super T, ? extends CompletionStage<T>> fn, T initialValue) {
        return TrampolineInternal.trampoline(shouldContinue, fn, initialValue);
    }

    public static CompletionStage<Void> asyncWhile(Supplier<? extends CompletionStage<Boolean>> fn) {
        return AsyncTrampoline.asyncWhile(b -> b, b -> (CompletionStage)fn.get(), true).thenCompose(CompletionStages::voidFuture);
    }

    private static class TrampolineInternal<T>
    extends CompletableFuture<T> {
        private final Predicate<? super T> shouldContinue;
        private final Function<? super T, ? extends CompletionStage<T>> f;

        private TrampolineInternal(Predicate<? super T> shouldContinue, Function<? super T, ? extends CompletionStage<T>> f) {
            this.shouldContinue = shouldContinue;
            this.f = f;
        }

        private static <T> CompletionStage<T> trampoline(Predicate<? super T> shouldContinue, Function<? super T, ? extends CompletionStage<T>> f, T initialValue) {
            TrampolineInternal<T> trampolineInternal = new TrampolineInternal<T>(shouldContinue, f);
            trampolineInternal.unroll(initialValue, null, null);
            return trampolineInternal;
        }

        private void unroll(T completed, Thread previousThread, PassBack<T> previousPassBack) {
            Thread currentThread = Thread.currentThread();
            if (currentThread.equals(previousThread) && previousPassBack != null && previousPassBack.isRunning) {
                previousPassBack.item = completed;
            } else {
                PassBack currentPassBack = new PassBack();
                T c = completed;
                do {
                    try {
                        if (!this.shouldContinue.test(c)) {
                            this.complete(c);
                            return;
                        }
                        this.f.apply(c).whenComplete((? super T next, ? super Throwable ex) -> {
                            if (ex != null) {
                                this.completeExceptionally((Throwable)ex);
                            } else {
                                this.unroll(next, currentThread, currentPassBack);
                            }
                        });
                    }
                    catch (Throwable e) {
                        this.completeExceptionally(e);
                        return;
                    }
                } while ((c = currentPassBack.poll()) != PassBack.NIL);
                currentPassBack.isRunning = false;
            }
        }

        private static class PassBack<T> {
            private static final Object NIL = new Object();
            boolean isRunning = true;
            T item = NIL;

            private PassBack() {
            }

            T poll() {
                T c = this.item;
                this.item = NIL;
                return c;
            }
        }
    }
}

