/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.vertx.impl;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.invoke.MethodHandles;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.vertx.VertxInstance;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public final class DefaultVertxInstance
implements VertxInstance,
Stoppable,
Startable {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private Vertx vertx;
    private boolean vertxCreator;

    @Override
    public Vertx getVertx() {
        if (this.vertx == null) {
            throw LOG.serviceNotInitialized();
        }
        return this.vertx;
    }

    public void stop() {
        if (this.vertxCreator && this.vertx != null) {
            this.vertx.close().toCompletionStage().thenAccept(v -> LOG.vertxInstanceStopped()).toCompletableFuture().join();
        }
    }

    public void start() {
        Context context = Vertx.currentContext();
        boolean bl = this.vertxCreator = context == null || context.owner() == null;
        if (this.vertxCreator) {
            LOG.creatingVertxInstance();
            this.vertx = Vertx.vertx();
        } else {
            LOG.debugf("Vert.x instance detected", new Object[0]);
            this.vertx = context.owner();
        }
    }
}

