/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.impl;

import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.backend.lucene.scope.LuceneIndexScope;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeIndexManagerContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;

public class LuceneIndexScopeImpl
implements IndexScope,
LuceneIndexScope {
    private final LuceneSearchQueryIndexScope<?> searchScope;

    public LuceneIndexScopeImpl(SearchBackendContext backendContext, BackendMappingContext mappingContext, Set<? extends LuceneScopeIndexManagerContext> indexManagerContexts) {
        this.searchScope = backendContext.createSearchContext(mappingContext, indexManagerContexts);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[indexNames=" + this.searchScope.hibernateSearchIndexNames() + "]";
    }

    public LuceneSearchQueryIndexScope<?> searchScope() {
        return this.searchScope;
    }

    @Override
    public IndexReader openIndexReader(Set<String> routingKeys) {
        Set indexNames = this.searchScope.hibernateSearchIndexNames();
        Collection<LuceneSearchIndexContext> indexManagerContexts = this.searchScope.indexes();
        return HibernateSearchMultiReader.open(indexNames, indexManagerContexts, routingKeys);
    }
}

