/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.DirectoryReader;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryCreationContextImpl;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestratorImpl;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.common.resources.spi.SavedState;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public final class Shard {
    private static final ConfigurationProperty<BeanReference<? extends DirectoryProvider>> DIRECTORY_TYPE = ConfigurationProperty.forKey((String)"directory.type").asBeanReference(DirectoryProvider.class).withDefault((Object)BeanReference.of(DirectoryProvider.class, (String)"local-filesystem")).build();
    private static final SavedState.Key<DirectoryHolder> DIRECTORY_HOLDER_KEY = SavedState.key((String)"directory_holder");
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Optional<String> shardId;
    private final IndexManagerBackendContext backendContext;
    private final LuceneIndexModel model;
    private DirectoryHolder directoryHolder;
    private IndexAccessorImpl indexAccessor;
    private LuceneParallelWorkOrchestratorImpl managementOrchestrator;
    private LuceneSerialWorkOrchestratorImpl indexingOrchestrator;
    private boolean savedForRestart = false;

    Shard(Optional<String> shardId, IndexManagerBackendContext backendContext, LuceneIndexModel model) {
        this.shardId = shardId;
        this.backendContext = backendContext;
        this.model = model;
    }

    public SavedState saveForRestart() {
        try {
            SavedState savedState = SavedState.builder().put(DIRECTORY_HOLDER_KEY, (Object)this.directoryHolder, DirectoryHolder::close).build();
            return savedState;
        }
        finally {
            this.savedForRestart = true;
        }
    }

    void preStart(ConfigurationPropertySource propertySource, BeanResolver beanResolver, SavedState savedState) {
        block9: {
            Optional savedDirectoryHolder = savedState.get(DIRECTORY_HOLDER_KEY);
            try {
                if (savedDirectoryHolder.isPresent()) {
                    this.directoryHolder = (DirectoryHolder)savedDirectoryHolder.get();
                    break block9;
                }
                try (BeanHolder directoryProviderHolder = (BeanHolder)DIRECTORY_TYPE.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));){
                    String indexName = this.model.hibernateSearchName();
                    EventContext indexAndShardEventContext = EventContexts.fromIndexNameAndShardId((String)indexName, this.shardId);
                    DirectoryCreationContextImpl context = new DirectoryCreationContextImpl(indexAndShardEventContext, indexName, this.shardId, beanResolver, propertySource.withMask("directory"));
                    this.directoryHolder = ((DirectoryProvider)directoryProviderHolder.get()).createDirectoryHolder(context);
                }
                this.directoryHolder.start();
            }
            catch (IOException | RuntimeException e) {
                throw log.unableToStartShard(e.getMessage(), e);
            }
        }
    }

    void start(ConfigurationPropertySource propertySource) {
        String indexName = this.model.hibernateSearchName();
        EventContext indexAndShardEventContext = EventContexts.fromIndexNameAndShardId((String)indexName, this.shardId);
        try {
            IOStrategy ioStrategy = this.backendContext.createIOStrategy(propertySource);
            this.indexAccessor = this.backendContext.createIndexAccessor(this.model, indexAndShardEventContext, this.directoryHolder, ioStrategy, propertySource);
            this.managementOrchestrator = this.backendContext.createIndexManagementOrchestrator(indexAndShardEventContext, this.indexAccessor);
            this.indexingOrchestrator = this.backendContext.createIndexingOrchestrator(indexAndShardEventContext, this.indexAccessor);
            this.managementOrchestrator.start(propertySource);
            this.indexingOrchestrator.start(propertySource);
        }
        catch (RuntimeException e) {
            throw log.unableToStartShard(e.getMessage(), e);
        }
    }

    CompletableFuture<?> preStop() {
        return this.indexingOrchestrator.preStop();
    }

    void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.indexingOrchestrator);
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.managementOrchestrator);
            closer.push(IndexAccessorImpl::close, (Object)this.indexAccessor);
            if (!this.savedForRestart) {
                closer.push(DirectoryHolder::close, (Object)this.directoryHolder);
            }
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToShutdownShard(e.getMessage(), this.shardId.map(EventContexts::fromShardId).orElse(null), e);
        }
    }

    DirectoryReader openReader() throws IOException {
        return this.indexAccessor.getIndexReader();
    }

    LuceneSerialWorkOrchestrator indexingOrchestrator() {
        return this.indexingOrchestrator;
    }

    LuceneParallelWorkOrchestrator managementOrchestrator() {
        return this.managementOrchestrator;
    }

    public IndexAccessorImpl indexAccessorForTests() {
        return this.indexAccessor;
    }
}

