/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.loading.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.standalone.loading.LoadingTypeGroup;

public final class StandalonePojoLoadingTypeGroup<E>
implements LoadingTypeGroup<E> {
    private final PojoRuntimeIntrospector introspector;
    private final Set<? extends PojoLoadingTypeContext<? extends E>> includedTypes;

    public StandalonePojoLoadingTypeGroup(Set<? extends PojoLoadingTypeContext<? extends E>> includedTypes, PojoRuntimeIntrospector introspector) {
        this.introspector = introspector;
        this.includedTypes = includedTypes;
    }

    @Override
    public Map<String, Class<? extends E>> includedTypesMap() {
        return this.includedTypes.stream().collect(Collectors.toMap(PojoLoadingTypeContext::entityName, t -> t.typeIdentifier().javaClass(), (o1, o2) -> o1, LinkedHashMap::new));
    }

    @Override
    public boolean includesInstance(Object entity) {
        PojoRawTypeIdentifier targetType = this.introspector.detectEntityType(entity);
        if (targetType == null) {
            return false;
        }
        for (PojoLoadingTypeContext<? extends E> pojoLoadingTypeContext : this.includedTypes) {
            if (!pojoLoadingTypeContext.typeIdentifier().equals((Object)targetType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.includedTypes.stream().map(PojoLoadingTypeContext::entityName).collect(Collectors.joining(","));
    }
}

