/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.typedarrays.ByteIo;
import org.htmlunit.corejs.javascript.typedarrays.Conversions;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayView;

public class NativeInt16Array
extends NativeTypedArrayView<Short> {
    private static final long serialVersionUID = -8592870435287581398L;
    private static final String CLASS_NAME = "Int16Array";
    private static final int BYTES_PER_ELEMENT = 2;

    public NativeInt16Array() {
    }

    public NativeInt16Array(NativeArrayBuffer ab, int off, int len) {
        super(ab, off, len, len * 2);
    }

    public NativeInt16Array(int len) {
        this(new NativeArrayBuffer((double)len * 2.0), 0, len);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 3, 2, (lcx, lscope, args) -> NativeTypedArrayView.js_constructor(lcx, lscope, args, NativeInt16Array::new, 2));
        constructor.setPrototypePropertyAttributes(7);
        NativeTypedArrayView.init(cx, scope, constructor, NativeInt16Array::realThis);
        constructor.defineProperty("BYTES_PER_ELEMENT", (Object)2, 7);
        constructor.definePrototypeProperty("BYTES_PER_ELEMENT", (Object)2, 7);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
        }
        return constructor;
    }

    @Override
    public int getBytesPerElement() {
        return 2;
    }

    private static NativeInt16Array realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeInt16Array.class);
    }

    @Override
    protected Object js_get(int index) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        return ByteIo.readInt16(this.arrayBuffer.buffer, index * 2 + this.offset, true);
    }

    @Override
    protected Object js_set(int index, Object c) {
        if (this.checkIndex(index)) {
            return Undefined.instance;
        }
        int val = Conversions.toInt16(c);
        ByteIo.writeInt16(this.arrayBuffer.buffer, index * 2 + this.offset, val, true);
        return null;
    }

    @Override
    public Short get(int i) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (Short)this.js_get(i);
    }

    @Override
    public Short set(int i, Short aByte) {
        if (this.checkIndex(i)) {
            throw new IndexOutOfBoundsException();
        }
        return (Short)this.js_set(i, aByte);
    }
}

