/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import javax.servlet.ServletException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

public abstract class HttpResponseRenderer {
    public abstract boolean generateResponse(StaplerRequest var1, StaplerResponse var2, Object var3, Object var4) throws IOException, ServletException;

    public static class Default
    extends HttpResponseRenderer {
        @Override
        public boolean generateResponse(StaplerRequest req, StaplerResponse rsp, Object node, Object response) throws IOException, ServletException {
            return this.handleHttpResponse(req, rsp, node, response) || this.handleJSON(rsp, response) || this.handleJavaScriptProxyMethodCall(req, rsp, response) || this.handlePrimitive(rsp, response);
        }

        protected boolean handleJavaScriptProxyMethodCall(StaplerRequest req, StaplerResponse rsp, Object response) throws IOException {
            if (req.isJavaScriptProxyCall()) {
                rsp.setContentType(Flavor.JSON.contentType);
                PrintWriter w = rsp.getWriter();
                if (response instanceof String) {
                    w.print('\"' + response.toString().replace("\"", "\\\"") + '\"');
                } else if (response instanceof Number || response instanceof Boolean) {
                    w.print(response);
                } else if (response instanceof Collection || response != null && response.getClass().isArray()) {
                    JSONArray.fromObject((Object)response).write((Writer)w);
                } else {
                    JSONObject.fromObject((Object)response).write((Writer)w);
                }
                return true;
            }
            return false;
        }

        protected boolean handlePrimitive(StaplerResponse rsp, Object response) throws IOException {
            if (response instanceof String || response instanceof Integer) {
                rsp.setContentType("text/plain;charset=UTF-8");
                rsp.getWriter().print(response);
                return true;
            }
            return false;
        }

        protected boolean handleHttpResponse(StaplerRequest req, StaplerResponse rsp, Object node, Object response) throws IOException, ServletException {
            if (response instanceof HttpResponse) {
                HttpResponse r = (HttpResponse)response;
                r.generateResponse(req, rsp, node);
                return true;
            }
            return false;
        }

        protected boolean handleJSON(StaplerResponse rsp, Object response) throws IOException {
            if (response instanceof JSON) {
                rsp.setContentType(Flavor.JSON.contentType);
                ((JSON)response).write((Writer)rsp.getWriter());
                return true;
            }
            return false;
        }
    }
}

