/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.kohsuke.stapler.AbstractAPT6;

final class QueryParameterContent
implements AbstractAPT6.Content {
    private final ExecutableElement method;

    QueryParameterContent(ExecutableElement method) {
        this.method = method;
    }

    @Override
    public String location() {
        TypeElement clazz = (TypeElement)this.method.getEnclosingElement();
        String path = clazz.getQualifiedName().toString().replace('.', '/');
        return path + '/' + this.method.getSimpleName() + ".stapler";
    }

    @Override
    public void load(InputStream is) {
    }

    @Override
    public void store(OutputStream os) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (VariableElement variableElement : this.method.getParameters()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(variableElement.getSimpleName());
        }
        byte[] bytes = buf.toString().getBytes(Charsets.UTF_8);
        ByteStreams.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])bytes), (OutputStream)os);
    }
}

