/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.stapler.AncestorImpl;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.EvaluationTrace;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.HttpDeletable;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.TokenList;
import org.kohsuke.stapler.TruncatedInputStream;
import org.kohsuke.stapler.WebApp;

public class Stapler
extends HttpServlet {
    private ServletContext context;
    private WebApp webApp;
    private static final Pattern RANGE_SPEC = Pattern.compile("([\\d]+)-([\\d]*)");
    static final ThreadLocal<SimpleDateFormat> HTTP_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    static ThreadLocal<RequestImpl> CURRENT_REQUEST = new ThreadLocal();
    static ThreadLocal<ResponseImpl> CURRENT_RESPONSE = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(Stapler.class.getName());
    private static final Set<String> TEXT_FILES = new HashSet<String>(Arrays.asList("css", "js", "html", "txt", "java", "htm", "c", "cpp", "h", "rb", "pl", "py", "xml"));
    public static final ConvertUtilsBean CONVERT_UTILS = new ConvertUtilsBean();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        this.webApp = WebApp.get(this.context);
        String defaultEncodings = servletConfig.getInitParameter("default-encodings");
        if (defaultEncodings != null) {
            for (String t : defaultEncodings.split(";")) {
                int idx = (t = t.trim()).indexOf(61);
                if (idx < 0) {
                    throw new ServletException("Invalid format: " + t);
                }
                this.webApp.defaultEncodingForStaticResources.put(t.substring(0, idx), t.substring(idx + 1));
            }
        }
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            Object root;
            OpenConnection con;
            t.setName("Handling " + req.getMethod() + ' ' + req.getRequestURI() + " : " + oldName);
            String servletPath = this.getServletPath(req);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Processing request for " + servletPath);
            }
            if (servletPath.startsWith("/$stapler/bound/")) {
                this.invoke(req, rsp, this.webApp.boundObjectTable, servletPath.substring("/$stapler/bound/".length()));
                return;
            }
            boolean staticLink = false;
            if (servletPath.startsWith("/static/")) {
                int idx = servletPath.indexOf(47, 8);
                servletPath = servletPath.substring(idx);
                staticLink = true;
            }
            String resPath = servletPath.toLowerCase(Locale.ENGLISH);
            if (servletPath.length() != 0 && !resPath.startsWith("/web-inf") && !resPath.startsWith("/meta-inf") && (con = this.openResourcePathByLocale(req, servletPath)) != null) {
                long expires;
                long l = expires = MetaClass.NO_CACHE ? 0L : 86400000L;
                if (staticLink) {
                    expires *= 365L;
                }
                if (this.serveStaticResource(req, (StaplerResponse)new ResponseImpl(this, rsp), con, expires)) {
                    return;
                }
            }
            if ((root = this.webApp.getApp()) == null) {
                throw new ServletException("there's no \"app\" attribute in the application context.");
            }
            this.invoke(req, rsp, root, servletPath);
        }
        finally {
            t.setName(oldName);
        }
    }

    private OpenConnection openResourcePathByLocale(HttpServletRequest req, String resourcePath) throws IOException {
        URL url = this.getServletContext().getResource(resourcePath);
        if (url == null) {
            return null;
        }
        return this.selectResourceByLocale(url, req.getLocale());
    }

    OpenConnection selectResourceByLocale(URL url, Locale locale) throws IOException {
        String s = url.toString();
        int idx = s.lastIndexOf(46);
        if (idx < 0) {
            return this.openURL(url);
        }
        String base = s.substring(0, idx);
        String ext = s.substring(idx);
        if (ext.indexOf(47) >= 0) {
            return this.openURL(url);
        }
        OpenConnection con = this.openURL(new URL(base + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant() + ext));
        if (con != null) {
            return con;
        }
        con = this.openURL(new URL(base + '_' + locale.getLanguage() + '_' + locale.getCountry() + ext));
        if (con != null) {
            return con;
        }
        con = this.openURL(new URL(base + '_' + locale.getLanguage() + ext));
        if (con != null) {
            return con;
        }
        return this.openURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean serveStaticResource(HttpServletRequest req, StaplerResponse rsp, OpenConnection con, long expiration) throws IOException {
        if (con == null) {
            return false;
        }
        try {
            boolean bl = this.serveStaticResource(req, rsp, con.stream, con.connection.getLastModified(), expiration, con.connection.getContentLength(), con.connection.getURL().toString());
            return bl;
        }
        finally {
            con.close();
        }
    }

    boolean serveStaticResource(HttpServletRequest req, StaplerResponse rsp, URL url, long expiration) throws IOException {
        return this.serveStaticResource(req, rsp, this.openURL(url), expiration);
    }

    private OpenConnection openURL(URL url) {
        if (url == null) {
            return null;
        }
        File f = this.toFile(url);
        if (f != null && f.isDirectory()) {
            return null;
        }
        try {
            URLConnection con = url.openConnection();
            OpenConnection c = new OpenConnection(con);
            if (c.stream == null) {
                return null;
            }
            return c;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean serveStaticResource(HttpServletRequest req, StaplerResponse rsp, InputStream in, long lastModified, long expiration, long contentLength, String fileName) throws IOException {
        try {
            int len;
            Matcher m;
            String range;
            String acceptEncoding;
            if (lastModified != 0L) {
                String since = req.getHeader("If-Modified-Since");
                SimpleDateFormat format = HTTP_DATE_FORMAT.get();
                if (since != null) {
                    try {
                        long ims = format.parse(since).getTime();
                        if (lastModified < ims + 1000L) {
                            rsp.setStatus(304);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (ParseException e) {
                    }
                    catch (NumberFormatException e) {
                        this.getServletContext().log("Error parsing [" + since + "]", (Throwable)e);
                        throw e;
                    }
                }
                String lastModifiedStr = format.format(new Date(lastModified));
                rsp.setHeader("Last-Modified", lastModifiedStr);
                if (expiration <= 0L) {
                    rsp.setHeader("Expires", lastModifiedStr);
                } else {
                    rsp.setHeader("Expires", format.format(new Date(new Date().getTime() + expiration)));
                }
            }
            rsp.setHeader("Accept-Ranges", "bytes");
            String mimeType = this.getMimeType(fileName);
            rsp.setContentType(mimeType);
            int idx = fileName.lastIndexOf(46);
            String ext = fileName.substring(idx + 1);
            OutputStream out = null;
            if ((mimeType.startsWith("text/") || TEXT_FILES.contains(ext)) && (acceptEncoding = req.getHeader("Accept-Encoding")) != null && acceptEncoding.indexOf("gzip") != -1) {
                out = rsp.getCompressedOutputStream(req);
            }
            if ((range = req.getHeader("Range")) != null && contentLength != -1L && range.startsWith("bytes=") && (m = RANGE_SPEC.matcher(range = range.substring(6))).matches()) {
                long toSkip;
                long thisSkip;
                long s = Long.valueOf(m.group(1));
                long e = m.group(2).length() > 0 ? Long.valueOf(m.group(2)) + 1L : contentLength;
                e = Math.min(e, contentLength);
                rsp.setStatus(206);
                rsp.setHeader("Content-Range", s + "-" + (e - 1L) + '/' + contentLength);
                DataInputStream dis = new DataInputStream(in);
                for (toSkip = s; toSkip > 0L && (thisSkip = (long)dis.skipBytes((int)Math.min(toSkip, Integer.MAX_VALUE))) > 0L; toSkip -= thisSkip) {
                }
                if (toSkip > 0L) {
                    throw new IOException("skipBytes failure (" + toSkip + " of " + s + " bytes unskipped)");
                }
                in = new TruncatedInputStream(in, e - s);
                contentLength = Math.min(e - s, contentLength);
            }
            if (out == null) {
                if (contentLength != -1L) {
                    rsp.setHeader("Content-Length", Long.toString(contentLength));
                }
                out = rsp.getOutputStream();
            }
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            boolean bl = true;
            return bl;
        }
        finally {
            in.close();
        }
    }

    private String getMimeType(String fileName) {
        if (fileName.startsWith("mime-type:")) {
            return fileName.substring("mime-type:".length());
        }
        int idx = fileName.lastIndexOf(47);
        fileName = fileName.substring(idx + 1);
        idx = fileName.lastIndexOf(92);
        String extension = (fileName = fileName.substring(idx + 1)).substring(fileName.lastIndexOf(46) + 1);
        String mimeType = this.webApp.mimeTypes.get(extension);
        if (mimeType == null) {
            mimeType = this.getServletContext().getMimeType(fileName);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        if (this.webApp.defaultEncodingForStaticResources.containsKey(mimeType)) {
            mimeType = mimeType + ";charset=" + this.webApp.defaultEncodingForStaticResources.get(mimeType);
        }
        return mimeType;
    }

    private File toFile(URL url) {
        String urlstr = url.toExternalForm();
        if (!urlstr.startsWith("file:")) {
            return null;
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            try {
                return new File(new URI(null, urlstr, null).getPath());
            }
            catch (URISyntaxException _) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpServletRequest req, HttpServletResponse rsp, Object root, String url) throws IOException, ServletException {
        RequestImpl sreq = new RequestImpl(this, req, new ArrayList<AncestorImpl>(), new TokenList(url));
        RequestImpl oreq = CURRENT_REQUEST.get();
        CURRENT_REQUEST.set(sreq);
        ResponseImpl srsp = new ResponseImpl(this, rsp);
        ResponseImpl orsp = CURRENT_RESPONSE.get();
        CURRENT_RESPONSE.set(srsp);
        try {
            this.invoke(sreq, srsp, root);
        }
        finally {
            CURRENT_REQUEST.set(oreq);
            CURRENT_RESPONSE.set(orsp);
        }
    }

    boolean tryInvoke(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
        StaplerOverridable o;
        Collection<?> list;
        if (Dispatcher.traceable()) {
            Dispatcher.traceEval(req, rsp, node);
        }
        if (node instanceof StaplerProxy) {
            Object n;
            if (Dispatcher.traceable()) {
                Dispatcher.traceEval(req, rsp, node, "((StaplerProxy)", ").getTarget()");
            }
            if ((n = ((StaplerProxy)node).getTarget()) != node && n != null) {
                this.invoke(req, rsp, n);
                return true;
            }
        }
        AncestorImpl a = new AncestorImpl(req.ancestors);
        a.set(node, req);
        if (node instanceof StaplerOverridable && (list = (o = (StaplerOverridable)node).getOverrides()) != null) {
            int count = 0;
            for (Object subject : list) {
                if (subject == null) continue;
                if (Dispatcher.traceable()) {
                    Dispatcher.traceEval(req, rsp, node, "((StaplerOverridable)", ").getOverrides()[" + count++ + ']');
                }
                if (!this.tryInvoke(req, rsp, subject)) continue;
                return true;
            }
        }
        MetaClass metaClass = this.webApp.getMetaClass(node.getClass());
        if (!req.tokens.hasMore()) {
            String servletPath = this.getServletPath(req);
            if (!servletPath.endsWith("/")) {
                String target = req.getContextPath() + servletPath + '/';
                if (req.getQueryString() != null) {
                    target = target + '?' + req.getQueryString();
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Redirecting to " + target);
                }
                rsp.sendRedirect2(target);
                return true;
            }
            if (req.getMethod().equals("DELETE") && node instanceof HttpDeletable) {
                ((HttpDeletable)node).delete(req, rsp);
                return true;
            }
            for (Facet f : this.webApp.facets) {
                if (!f.handleIndexRequest(req, rsp, node, metaClass)) continue;
                return true;
            }
            URL indexHtml = this.getSideFileURL(node, "index.html");
            if (indexHtml != null && this.serveStaticResource((HttpServletRequest)req, (StaplerResponse)rsp, indexHtml, 0L)) {
                return true;
            }
        }
        try {
            for (Dispatcher d : metaClass.dispatchers) {
                if (!d.dispatch(req, rsp, node)) continue;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Handled by " + d);
                }
                return true;
            }
        }
        catch (IllegalAccessException e) {
            this.getServletContext().log("Error while serving " + req.getRequestURL(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                this.getServletContext().log("Error while serving " + req.getRequestURL(), (Throwable)e);
                throw new ServletException();
            }
            for (HttpResponseRenderer r : this.webApp.getResponseRenderers()) {
                if (!r.generateResponse(req, rsp, node, cause)) continue;
                return true;
            }
            StringBuffer url = req.getRequestURL();
            if (cause instanceof IOException) {
                this.getServletContext().log("Error while serving " + url, (Throwable)e);
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                this.getServletContext().log("Error while serving " + url, (Throwable)e);
                throw (ServletException)cause;
            }
            for (Class<?> c = cause.getClass(); c != null; c = c.getSuperclass()) {
                if (c == Object.class) {
                    this.getServletContext().log("Error while serving " + url, (Throwable)e);
                    continue;
                }
                if (!c.getName().equals("org.acegisecurity.AccessDeniedException")) continue;
                this.getServletContext().log("While serving " + url + ": " + cause);
                break;
            }
            throw new ServletException(cause);
        }
        if (node instanceof StaplerFallback) {
            Object n;
            if (Dispatcher.traceable()) {
                Dispatcher.traceEval(req, rsp, node, "((StaplerFallback)", ").getStaplerFallback()");
            }
            if ((n = ((StaplerFallback)node).getStaplerFallback()) != node && n != null) {
                this.invoke(req, rsp, n);
                return true;
            }
        }
        return false;
    }

    void invoke(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
        if (node == null) {
            if (!Dispatcher.isTraceEnabled(req)) {
                rsp.sendError(404);
            } else {
                rsp.setStatus(404);
                rsp.setContentType("text/html;charset=UTF-8");
                PrintWriter w = rsp.getWriter();
                w.println("<html><body>");
                w.println("<h1>404 Not Found</h1>");
                w.println("<p>Stapler processed this HTTP request as follows, but couldn't find the resource to consume the request");
                w.println("<pre>");
                EvaluationTrace.get(req).printHtml(w);
                w.println("<font color=red>-&gt; unexpected null!</font>");
                w.println("</pre>");
                w.println("<p>If this 404 is unexpected, double check the last part of the trace to see if it should have evaluated to null.");
                w.println("</body></html>");
            }
            return;
        }
        if (this.tryInvoke(req, rsp, node)) {
            return;
        }
        if (!Dispatcher.isTraceEnabled(req)) {
            rsp.sendError(404);
        } else {
            rsp.setStatus(404);
            rsp.setContentType("text/html;charset=UTF-8");
            PrintWriter w = rsp.getWriter();
            w.println("<html><body>");
            w.println("<h1>404 Not Found</h1>");
            w.println("<p>Stapler processed this HTTP request as follows, but couldn't find the resource to consume the request");
            w.println("<pre>");
            EvaluationTrace.get(req).printHtml(w);
            w.printf("<font color=red>-&gt; No matching rule was found on &lt;%s&gt; for \"%s\"</font>\n", node, req.tokens.assembleOriginalRestOfPath());
            w.println("</pre>");
            w.printf("<p>&lt;%s&gt; has the following URL mappings, in the order of preference:", node);
            w.println("<ol>");
            MetaClass metaClass = this.webApp.getMetaClass(node.getClass());
            for (Dispatcher d : metaClass.dispatchers) {
                w.println("<li>");
                w.println(d.toString());
            }
            w.println("</ol>");
            w.println("</body></html>");
        }
    }

    public void forward(RequestDispatcher dispatcher, StaplerRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        dispatcher.forward((ServletRequest)req, (ServletResponse)new ResponseImpl(this, rsp));
    }

    private URL getSideFileURL(Object node, String fileName) throws MalformedURLException {
        for (Class<?> c = node.getClass(); c != Object.class; c = c.getSuperclass()) {
            String name = "/WEB-INF/side-files/" + c.getName().replace('.', '/') + '/' + fileName;
            URL url = this.getServletContext().getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static String getViewURL(Class clazz, String jspName) {
        return "/WEB-INF/side-files/" + clazz.getName().replace('.', '/') + '/' + jspName;
    }

    public static void setRoot(ServletContextEvent event, Object rootApp) {
        event.getServletContext().setAttribute("app", rootApp);
    }

    public static void setClassLoader(ServletContext context, ClassLoader classLoader) {
        WebApp.get(context).setClassLoader(classLoader);
    }

    public static ClassLoader getClassLoader(ServletContext context) {
        return WebApp.get(context).getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.webApp.getClassLoader();
    }

    public static StaplerRequest getCurrentRequest() {
        return CURRENT_REQUEST.get();
    }

    public static StaplerResponse getCurrentResponse() {
        return CURRENT_RESPONSE.get();
    }

    public static Stapler getCurrent() {
        return CURRENT_REQUEST.get().getStapler();
    }

    private String getServletPath(HttpServletRequest req) {
        return Stapler.canonicalPath(req.getRequestURI().substring(req.getContextPath().length()));
    }

    static String canonicalPath(String path) {
        ArrayList<String> r = new ArrayList<String>(Arrays.asList(path.split("/+")));
        int i = 0;
        while (i < r.size()) {
            if (((String)r.get(i)).length() == 0 || ((String)r.get(i)).equals(".")) {
                r.remove(i);
                continue;
            }
            if (((String)r.get(i)).equals("..")) {
                r.remove(i);
                if (i <= 0) continue;
                r.remove(i - 1);
                --i;
                continue;
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        if (path.startsWith("/")) {
            buf.append('/');
        }
        boolean first = true;
        for (String token : r) {
            if (!first) {
                buf.append('/');
            } else {
                first = false;
            }
            buf.append(token);
        }
        if (path.endsWith("/") && (buf.length() == 0 || buf.charAt(buf.length() - 1) != '/')) {
            buf.append('/');
        }
        return buf.toString();
    }

    public static Converter lookupConverter(Class type) {
        Converter c = CONVERT_UTILS.lookup(type);
        if (c != null) {
            return c;
        }
        c = ConvertUtils.lookup((Class)type);
        if (c != null) {
            return c;
        }
        try {
            if (type.getClassLoader() == null) {
                return null;
            }
            Class<?> cl = type.getClassLoader().loadClass(type.getName() + "$StaplerConverterImpl");
            c = (Converter)cl.newInstance();
            CONVERT_UTILS.register(c, type);
            return c;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError();
            x.initCause(e);
            throw x;
        }
        catch (InstantiationException e) {
            InstantiationError x = new InstantiationError();
            x.initCause(e);
            throw x;
        }
    }

    static {
        CONVERT_UTILS.register(new Converter(){

            public Object convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new ConversionException((Throwable)e);
                }
            }
        }, URL.class);
        CONVERT_UTILS.register(new Converter(){

            public FileItem convert(Class type, Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    return Stapler.getCurrentRequest().getFileItem(value.toString());
                }
                catch (ServletException e) {
                    throw new ConversionException((Throwable)e);
                }
                catch (IOException e) {
                    throw new ConversionException((Throwable)e);
                }
            }
        }, FileItem.class);
        CONVERT_UTILS.register((Converter)new IntegerConverter(null), Integer.class);
        CONVERT_UTILS.register((Converter)new FloatConverter(null), Float.class);
        CONVERT_UTILS.register((Converter)new DoubleConverter(null), Double.class);
    }

    private static final class OpenConnection {
        final URLConnection connection;
        final InputStream stream;

        private OpenConnection(URLConnection connection, InputStream stream) {
            this.connection = connection;
            this.stream = stream;
        }

        private OpenConnection(URLConnection connection) throws IOException {
            this(connection, connection.getInputStream());
        }

        private void close() throws IOException {
            this.stream.close();
        }
    }
}

