/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import org.kohsuke.stapler.AbstractAPT6;

final class ExportedBeanContent
implements AbstractAPT6.Content {
    private final Set<String> beans = new TreeSet<String>();

    ExportedBeanContent(Iterable<TypeElement> beans) {
        for (TypeElement b : beans) {
            this.beans.add(b.getQualifiedName().toString());
        }
    }

    @Override
    public String location() {
        return "META-INF/exposed.stapler-beans";
    }

    @Override
    public void load(InputStream is) throws IOException {
        this.beans.addAll(CharStreams.readLines((Readable)new InputStreamReader(is, Charsets.UTF_8)));
    }

    @Override
    public void store(OutputStream os) throws IOException {
        byte[] bytes = Joiner.on((char)'\n').join(this.beans).getBytes(Charsets.UTF_8);
        ByteStreams.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])bytes), (OutputStream)os);
    }
}

