/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.export.Property;
import org.kohsuke.stapler.export.TreePruner;

public final class NamedPathPruner
extends TreePruner {
    private final Tree tree;

    static Tree parse(String spec) throws IllegalArgumentException {
        Reader r = new Reader(spec);
        Tree t = new Tree();
        NamedPathPruner.list(r, t);
        r.expect(Token.EOF);
        return t;
    }

    private static void list(Reader r, Tree t) throws IllegalArgumentException {
        NamedPathPruner.node(r, t);
        if (r.accept(Token.COMMA)) {
            NamedPathPruner.list(r, t);
        }
    }

    private static void node(Reader r, Tree t) throws IllegalArgumentException {
        Object actual = r.peek();
        if (actual instanceof Token) {
            throw new IllegalArgumentException("expected name at " + r.pos);
        }
        r.advance();
        Tree subtree = new Tree();
        t.children.put((String)actual, subtree);
        if (r.accept(Token.LBRACE)) {
            NamedPathPruner.list(r, subtree);
            r.expect(Token.RBRACE);
        }
    }

    public NamedPathPruner(String spec) throws IllegalArgumentException {
        this(NamedPathPruner.parse(spec));
    }

    private NamedPathPruner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public TreePruner accept(Object node, Property prop) {
        Tree subtree = this.tree.children.get(prop.name);
        return subtree != null ? new NamedPathPruner(subtree) : null;
    }

    private static class Reader {
        private final String text;
        int pos;
        int next;

        Reader(String text) {
            this.text = text;
            this.pos = 0;
        }

        Object peek() {
            if (this.pos == this.text.length()) {
                return Token.EOF;
            }
            switch (this.text.charAt(this.pos)) {
                case ',': {
                    this.next = this.pos + 1;
                    return Token.COMMA;
                }
                case '[': {
                    this.next = this.pos + 1;
                    return Token.LBRACE;
                }
                case ']': {
                    this.next = this.pos + 1;
                    return Token.RBRACE;
                }
            }
            this.next = this.text.length();
            for (char c : new char[]{',', '[', ']'}) {
                int x = this.text.indexOf(c, this.pos);
                if (x == -1 || x >= this.next) continue;
                this.next = x;
            }
            return this.text.substring(this.pos, this.next);
        }

        void advance() {
            this.pos = this.next;
        }

        void expect(Token tok) throws IllegalArgumentException {
            Object actual = this.peek();
            if (actual != tok) {
                throw new IllegalArgumentException("expected " + (Object)((Object)tok) + " at " + this.pos);
            }
            this.advance();
        }

        boolean accept(Token tok) {
            if (this.peek() == tok) {
                this.advance();
                return true;
            }
            return false;
        }
    }

    private static enum Token {
        COMMA,
        LBRACE,
        RBRACE,
        EOF;

    }

    static class Tree {
        final Map<String, Tree> children = new TreeMap<String, Tree>();

        Tree() {
        }

        public String toString() {
            return this.children.toString();
        }
    }
}

