/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework;

import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.framework.errors.NoHomeDirError;

public abstract class AbstractWebAppMain<T>
implements ServletContextListener {
    protected final Class<T> rootType;
    private static final String APP = "app";
    protected ServletContext context;
    protected File home;
    private static final Logger LOGGER = Logger.getLogger(AbstractWebAppMain.class.getName());

    protected AbstractWebAppMain(Class<T> rootType) {
        this.rootType = rootType;
    }

    protected abstract String getApplicationName();

    protected Object createPlaceHolderForAsyncLoad() {
        return null;
    }

    protected abstract Object createApplication() throws Exception;

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.context = event.getServletContext();
            this.installLocaleProvider();
            if (!this.checkEnvironment()) {
                return;
            }
            Object ph = this.createPlaceHolderForAsyncLoad();
            if (ph != null) {
                this.context.setAttribute(APP, ph);
                new Thread(this.getApplicationName() + " initialization thread"){

                    @Override
                    public void run() {
                        AbstractWebAppMain.this.setApplicationObject();
                    }
                }.start();
            } else {
                this.setApplicationObject();
            }
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            throw e;
        }
    }

    protected void setApplicationObject() {
        try {
            this.context.setAttribute(APP, this.createApplication());
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize " + this.getApplicationName(), e);
            throw new Error(e);
        }
    }

    protected boolean checkEnvironment() {
        this.home = this.getHomeDir().getAbsoluteFile();
        this.home.mkdirs();
        LOGGER.info(this.getApplicationName() + " home directory: " + this.home);
        if (!this.home.exists()) {
            this.context.setAttribute(APP, (Object)new NoHomeDirError(this.home));
            return false;
        }
        return true;
    }

    private void installLocaleProvider() {
        LocaleProvider.setProvider((LocaleProvider)new LocaleProvider(){

            public Locale get() {
                Locale locale = null;
                StaplerRequest req = Stapler.getCurrentRequest();
                if (req != null) {
                    locale = req.getLocale();
                }
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return locale;
            }
        });
    }

    protected File getHomeDir() {
        Object env;
        String varName = this.getApplicationName().toUpperCase() + "_HOME";
        try {
            InitialContext iniCtxt = new InitialContext();
            env = (Context)iniCtxt.lookup("java:comp/env");
            String value = (String)env.lookup(varName);
            if (value != null && value.trim().length() > 0) {
                return new File(value.trim());
            }
            value = (String)iniCtxt.lookup(varName);
            if (value != null && value.trim().length() > 0) {
                return new File(value.trim());
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        String sysProp = System.getProperty(varName);
        if (sysProp != null) {
            return new File(sysProp.trim());
        }
        env = System.getenv(varName);
        if (env != null) {
            return new File(((String)env).trim()).getAbsoluteFile();
        }
        return this.getDefaultHomeDir();
    }

    protected File getDefaultHomeDir() {
        return new File(new File(System.getProperty("user.home")), '.' + this.getApplicationName().toLowerCase());
    }

    public void contextDestroyed(ServletContextEvent event) {
        Object o = event.getServletContext().getAttribute(APP);
        if (this.rootType.isInstance(o)) {
            this.cleanUp(this.rootType.cast(o));
        }
    }

    protected void cleanUp(T app) {
    }
}

