/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.utils;

public class JSONBuilder {
    private StringBuilder params = new StringBuilder();

    public static JSONBuilder create() {
        return new JSONBuilder();
    }

    public JSONBuilder beginMap() {
        this.params.append("{");
        return this;
    }

    public JSONBuilder beginMap(String key) {
        this.appendCommaAndKey(key);
        return this.beginMap();
    }

    public JSONBuilder endMap() {
        this.params.append("}");
        return this;
    }

    public JSONBuilder beginArray(String key) {
        this.appendCommaAndKey(key);
        this.params.append("[");
        return this;
    }

    public JSONBuilder endArray() {
        this.params.append("]");
        return this;
    }

    public JSONBuilder entry(String key, int value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, long value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, float value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, double value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, boolean value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, String[] keyValuePairs) {
        this.beginArray(key);
        int argCount = keyValuePairs.length / 2;
        StringBuilder localCopy = new StringBuilder();
        for (int idx = 0; idx < argCount; ++idx) {
            localCopy.append('\"').append(this.escapeString(keyValuePairs[2 * idx])).append('\"').append(",").append('\"').append(this.escapeString(keyValuePairs[2 * idx + 1])).append('\"');
            localCopy.append(",");
        }
        if (localCopy.length() > 0) {
            localCopy.setLength(localCopy.length() - 1);
        }
        this.params.append(localCopy.toString());
        this.endArray();
        return this;
    }

    public JSONBuilder entry(String key, String value) {
        return this.entry(key, value, false);
    }

    public JSONBuilder entry(String key, String value, boolean isStringLiteral) {
        this.appendCommaAndKey(key);
        if (isStringLiteral) {
            this.params.append(value);
        } else {
            value = this.escapeString(value);
            this.params.append('\"').append(value).append('\"');
        }
        return this;
    }

    public JSONBuilder item(String value) {
        this.conditionallyAppendComma();
        value = this.escapeString(value);
        this.params.append('\"').append(value).append('\"');
        return this;
    }

    private String escapeString(String value) {
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("/", "\\/");
        value = value.replace("\b", "\\b");
        value = value.replace("\f", "\\f");
        value = value.replace("\n", "\\n");
        value = value.replace("\r", "\\r");
        value = value.replace("\t", "\\t");
        return value;
    }

    public String toString() {
        return this.params.toString();
    }

    private void appendCommaAndKey(String key) {
        this.conditionallyAppendComma();
        this.params.append('\"').append(key).append('\"').append(":");
    }

    private void conditionallyAppendComma() {
        char lastChar = this.params.charAt(this.params.length() - 1);
        if (lastChar != '{' && lastChar != '[') {
            this.params.append(",");
        }
    }
}

