/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.application.Resource;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.dataexporter.Exporter;
import org.icefaces.ace.component.dataexporter.ExporterResource;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.row.Row;
import org.icefaces.application.ResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter
extends Exporter {
    private static final Logger logger = Logger.getLogger(PDFExporter.class.getName());
    private Class documentClass;
    private Class fontClass;
    private Class fontFactoryClass;
    private Class paragraphClass;
    private Class phraseClass;
    private Class pdfPTableClass;
    private Class elementClass;
    private Class pdfWriterClass;
    private Method addCellMethod;
    private Constructor paragraphConstructor;

    private void loadClasses() throws ClassNotFoundException {
        this.documentClass = Class.forName("com.lowagie.text.Document");
        this.fontClass = Class.forName("com.lowagie.text.Font");
        this.fontFactoryClass = Class.forName("com.lowagie.text.FontFactory");
        this.paragraphClass = Class.forName("com.lowagie.text.Paragraph");
        this.phraseClass = Class.forName("com.lowagie.text.Phrase");
        this.pdfPTableClass = Class.forName("com.lowagie.text.pdf.PdfPTable");
        this.elementClass = Class.forName("com.lowagie.text.Element");
        this.pdfWriterClass = Class.forName("com.lowagie.text.pdf.PdfWriter");
    }

    private void loadMethods() throws NoSuchMethodException {
        this.addCellMethod = this.pdfPTableClass.getMethod("addCell", this.phraseClass);
        this.paragraphConstructor = this.paragraphClass.getConstructor(String.class, this.fontClass);
    }

    @Override
    public String export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean includeHeaders, boolean includeFooters, boolean selectedRowsOnly) throws IOException {
        try {
            Object pdfTable;
            Boolean isOpen;
            this.loadClasses();
            this.loadMethods();
            Object document = this.documentClass.newInstance();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.pdfWriterClass.getMethod("getInstance", this.documentClass, OutputStream.class).invoke(null, document, baos);
            if (preProcessor != null) {
                preProcessor.invoke(facesContext.getELContext(), new Object[]{document});
            }
            if (!(isOpen = (Boolean)this.documentClass.getMethod("isOpen", new Class[0]).invoke(document, new Object[0])).booleanValue()) {
                this.documentClass.getMethod("open", new Class[0]).invoke(document, new Object[0]);
            }
            Constructor pdfPTableConstructor = this.pdfPTableClass.getConstructor(Integer.TYPE);
            Method add = this.documentClass.getMethod("add", this.elementClass);
            List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
            if (columns.size() > 0) {
                pdfTable = pdfPTableConstructor.newInstance(new Integer(columns.size()));
                this.exportPDFTable(pdfTable, table, pageOnly, excludeColumns, encodingType, includeHeaders, includeFooters, selectedRowsOnly);
                add.invoke(document, pdfTable);
            } else {
                pdfTable = pdfPTableConstructor.newInstance(new Integer(1));
                Object paragraph = this.paragraphClass.getConstructor(String.class).newInstance("");
                this.addCellMethod.invoke(pdfTable, paragraph);
                add.invoke(document, pdfTable);
            }
            if (postProcessor != null) {
                postProcessor.invoke(facesContext.getELContext(), new Object[]{document});
            }
            this.documentClass.getMethod("close", new Class[0]).invoke(document, new Object[0]);
            byte[] bytes = baos.toByteArray();
            ExporterResource resource = new ExporterResource(bytes);
            resource.setContentType("application/pdf");
            Map<String, String> headers = resource.getResponseHeaders();
            headers.put("Expires", "0");
            headers.put("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            headers.put("Pragma", "public");
            headers.put("Content-disposition", "attachment;filename=" + filename + ".pdf");
            String path = ResourceRegistry.addSessionResource((Resource)resource);
            return path;
        }
        catch (ClassNotFoundException e) {
            logger.severe("Exporting data to PDF format was attempted by a user, but the iText library was not found.");
            return "unsupported format";
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void exportPDFTable(Object pdfTable, DataTable table, boolean pageOnly, int[] excludeColumns, String encoding, boolean includeHeaders, boolean includeFooters, boolean selectedRowsOnly) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int numberOfColumns = columns.size();
        Object font = this.fontFactoryClass.getMethod("getFont", String.class, String.class).invoke(null, "Times", encoding);
        Object headerFont = this.fontFactoryClass.getMethod("getFont", String.class, String.class, Float.TYPE, Integer.TYPE).invoke(null, "Times", encoding, new Integer(12), new Integer(1));
        int rowCount = table.getRowCount();
        int first = pageOnly ? table.getFirst() : 0;
        int size = pageOnly ? first + table.getRows() : rowCount;
        int n = size = size > rowCount ? rowCount : size;
        if (includeHeaders) {
            ColumnGroup columnGroup = this.getColumnGroupHeader(table);
            if (columnGroup != null) {
                List<Row> rows = this.getRows(columnGroup);
                for (Row row : rows) {
                    List<UIColumn> rowColumns = this.getRowColumnsToExport(row, table, excludeColumns);
                    this.addFacetColumns(pdfTable, rowColumns, headerFont, Exporter.ColumnType.HEADER);
                }
            } else {
                this.addFacetColumns(pdfTable, columns, headerFont, Exporter.ColumnType.HEADER);
            }
        }
        Object originalData = null;
        if (selectedRowsOnly) {
            originalData = table.getValue();
            table.setValue(table.getStateMap().getSelected());
            first = 0;
            size = table.getRowCount();
        }
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            for (int j = 0; j < numberOfColumns; ++j) {
                this.addColumnValue(pdfTable, columns.get(j).getChildren(), j, font);
            }
        }
        if (selectedRowsOnly) {
            table.setValue(originalData);
        }
        if (this.hasColumnFooter(columns) && includeFooters) {
            this.addFacetColumns(pdfTable, columns, headerFont, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
    }

    private void addFacetColumns(Object pdfTable, List<UIColumn> columns, Object font, Exporter.ColumnType columnType) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn uiColumn = columns.get(i);
            UIComponent facet = uiColumn.getFacet(columnType.facet());
            if (facet != null) {
                this.addColumnValue(pdfTable, facet, font);
                continue;
            }
            String value = "";
            if (uiColumn instanceof Column) {
                Column column = (Column)uiColumn;
                if (columnType == Exporter.ColumnType.HEADER) {
                    String headerText = column.getHeaderText();
                    value = headerText != null ? headerText : "";
                } else if (columnType == Exporter.ColumnType.FOOTER) {
                    String footerText = column.getFooterText();
                    value = footerText != null ? footerText : "";
                }
            }
            Object paragraph = this.paragraphConstructor.newInstance(value, font);
            this.addCellMethod.invoke(pdfTable, paragraph);
        }
    }

    private void addColumnValue(Object pdfTable, UIComponent component, Object font) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        Object paragraph = this.paragraphConstructor.newInstance(value, font);
        this.addCellMethod.invoke(pdfTable, paragraph);
    }

    private void addColumnValue(Object pdfTable, List<UIComponent> components, int index, Object font) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        Object paragraph = this.paragraphConstructor.newInstance(builder.toString(), font);
        this.addCellMethod.invoke(pdfTable, paragraph);
    }
}

