/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.fileentry.FileEntryResults;
import org.icefaces.ace.component.fileentry.ProgressResource;
import org.icefaces.ace.component.fileentry.PushUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.apache.commons.fileupload.ProgressListener;
import org.icefaces.application.ResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressListenerResourcePusher
implements ProgressListener {
    private static final long MIN_INTERVAL = 2000L;
    private Map<String, FileEntryResults> clientId2Results;
    private ProgressResource pushResource;
    private String pushGroupName;
    private long lastPushTime;
    private long lastPercent;
    private int lastDeltaGottenPushed;

    ProgressListenerResourcePusher(Map<String, FileEntryResults> clientId2Results) {
        this.clientId2Results = clientId2Results;
    }

    @Override
    public void update(long read, long total, int chunkIndex) {
        if (read > 0L && total > 0L) {
            boolean force = read == total;
            long currPercent = read * 100L / total;
            if (force || currPercent > this.lastPercent) {
                long now = System.currentTimeMillis();
                if ((force || now - this.lastPushTime >= 2000L) && this.tryPush(currPercent, force)) {
                    this.lastPushTime = now;
                    this.lastPercent = currPercent;
                }
            }
        } else {
            this.lastPercent = 0L;
        }
    }

    protected boolean tryPush(long percent, boolean force) {
        if (this.pushResource == null || this.pushGroupName == null) {
            return false;
        }
        int deltaGottenPushed = this.updateResourceContents(percent);
        int localLastDeltaGottenPushed = this.lastDeltaGottenPushed;
        if (!force && deltaGottenPushed > 2 && deltaGottenPushed > localLastDeltaGottenPushed + 1) {
            this.lastDeltaGottenPushed = deltaGottenPushed;
            return true;
        }
        PushUtils.push(this.pushGroupName);
        return true;
    }

    void setPushResourcePathAndGroupName(FacesContext facesContext, String pushResourcePath, String pushGroupName) {
        Resource res = ResourceRegistry.getResourceByPath((FacesContext)facesContext, (String)pushResourcePath);
        this.pushResource = res instanceof ProgressResource ? (ProgressResource)res : null;
        this.pushGroupName = pushGroupName;
    }

    void clear() {
        this.clientId2Results = null;
        this.pushResource = null;
        this.pushGroupName = null;
        this.lastPushTime = 0L;
        this.lastPercent = 0L;
        this.lastDeltaGottenPushed = 0;
    }

    private int updateResourceContents(long percent) {
        JSONBuilder contents = JSONBuilder.create().beginMap();
        contents.entry("percent", percent);
        contents.beginArray("results");
        for (String clientId : this.clientId2Results.keySet()) {
            contents.item(clientId);
        }
        contents.endArray();
        contents.endMap();
        return this.pushResource.updateProgressInfo(contents.toString());
    }
}

