/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menubutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.menu.AbstractMenu;
import org.icefaces.ace.component.menu.BaseMenuRenderer;
import org.icefaces.ace.component.menubutton.MenuButton;
import org.icefaces.ace.component.menuitem.MenuItem;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="menuButton", value="org.icefaces.ace.component.menubutton.MenuButton")
public class MenuButtonRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        String style;
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        String buttonId = clientId + "_button";
        String menuId = clientId + "_menu";
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = button.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        if ((style = button.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        if (button.getValue() != null) {
            writer.write(button.getValue());
        }
        writer.endElement("button");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)menuId, null);
        for (UIComponent child : button.getChildren()) {
            MenuItem item = (MenuItem)child;
            if (!item.isRendered()) continue;
            writer.startElement("li", (UIComponent)item);
            this.encodeMenuItem(context, item);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        String formClientId = form.getClientId(context);
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSONBuilder json = JSONBuilder.create();
        writer.write(this.resolveWidgetVar((UIComponent)button) + " = new ");
        json.beginFunction("ice.ace.MenuButton").item(clientId).beginMap().beginMap("animation").entry("animated", button.getEffect()).entry("duration", button.getEffectDuration()).endMap().entry("zindex", button.getZindex());
        if (button.isDisabled()) {
            json.entry("disabled", true);
        }
        json.endMap().endFunction();
        writer.write(json.toString());
        writer.endElement("script");
    }
}

