/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.renderkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.icefaces.ace.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputRenderer
extends CoreRenderer {
    protected List<SelectItem> getSelectItems(FacesContext context, UIInput component) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                selectItems.add(new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            UISelectItems uiSelectItems = (UISelectItems)child;
            Object value = uiSelectItems.getValue();
            if (value instanceof SelectItem[]) {
                selectItems.addAll(Arrays.asList((SelectItem[])value));
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Object key : map.keySet()) {
                    selectItems.add(new SelectItem(map.get(key), String.valueOf(key)));
                }
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            String var = (String)uiSelectItems.getAttributes().get("var");
            if (var != null) {
                for (Object object : collection) {
                    context.getExternalContext().getRequestMap().put(var, object);
                    String itemLabel = (String)uiSelectItems.getAttributes().get("itemLabel");
                    Object itemValue = uiSelectItems.getAttributes().get("itemValue");
                    selectItems.add(new SelectItem(itemValue, itemLabel));
                }
                continue;
            }
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                selectItems.add((SelectItem)it.next());
            }
        }
        return selectItems;
    }

    protected String getOptionAsString(FacesContext context, UIInput component, Converter converter, Object value) {
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)component, value);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected Converter getConverter(FacesContext context, UIInput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            return context.getApplication().createConverter(valueType);
        }
        return null;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UIInput uiInput = (UIInput)component;
        String value = (String)submittedValue;
        Converter converter = uiInput.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)uiInput, value);
        }
        ValueExpression ve = uiInput.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)uiInput, value);
            }
        }
        return value;
    }
}

