/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tabset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.ace.component.tabset.TabPane;
import org.icefaces.ace.component.tabset.TabPaneCache;
import org.icefaces.ace.component.tabset.TabSet;
import org.icefaces.ace.component.tabset.Tabs;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.ScriptWriter;
import org.icefaces.ace.util.Utils;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MandatoryResourceComponent(tagName="tabSet", value="org.icefaces.ace.component.tabset.TabSet")
public class TabSetRenderer
extends CoreRenderer {
    private static String YUI_TABSET_INDEX = "yti";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        TabSet tabSet;
        int old;
        Integer index = this.decodeSelectedIndex(facesContext, uiComponent);
        if (index != null && (old = (tabSet = (TabSet)uiComponent).getSelectedIndex()) != index) {
            uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, (Object)new Integer(old), (Object)index));
        }
        this.decodeBehaviors(facesContext, uiComponent);
    }

    protected Integer decodeSelectedIndex(FacesContext facesContext, UIComponent uiComponent) {
        Integer index = null;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(YUI_TABSET_INDEX)) {
            String param = String.valueOf(requestParameterMap.get(YUI_TABSET_INDEX));
            String[] info = param.split("=");
            String clientId = uiComponent.getClientId(facesContext);
            if (clientId.equals(info[0])) {
                try {
                    index = Integer.parseInt(info[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return index;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        TabSet tabSet = (TabSet)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        String style = tabSet.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        TabSet tabSet = (TabSet)uiComponent;
        boolean isBottom = "bottom".equals(tabSet.getOrientation());
        if (isBottom) {
            writer.startElement("div", uiComponent);
            writer.writeAttribute("tabindex", (Object)0, "tabindex");
            writer.writeAttribute("id", (Object)(clientId + "cnt"), "id");
            writer.writeAttribute("class", (Object)"yui-content ui-tabs-panel ui-widget-content ui-corner-top", "class");
            writer.endElement("div");
            writer.startElement("ul", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_nav"), "id");
            writer.writeAttribute("class", (Object)"yui-nav ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all", "class");
            if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
                writer.writeAttribute("role", (Object)"tablist", "role");
            }
            TabSetRenderer.doTabs(facesContext, uiComponent, Do.RENDER_LABEL, null, null, null);
            writer.endElement("ul");
        } else if ("top".equals(tabSet.getOrientation())) {
            writer.startElement("ul", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_nav"), "id");
            writer.writeAttribute("class", (Object)"yui-nav ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all", "class");
            if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
                writer.writeAttribute("role", (Object)"tablist", "role");
            }
            TabSetRenderer.doTabs(facesContext, uiComponent, Do.RENDER_LABEL, null, null, null);
            writer.endElement("ul");
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "cnt"), "id");
            writer.writeAttribute("class", (Object)"yui-content ui-tabs-panel ui-widget-content ui-corner-bottom", "class");
            writer.endElement("div");
        } else {
            writer.startElement("ul", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_nav"), "id");
            writer.writeAttribute("class", (Object)"yui-nav ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all ui-tabs-vertical", "class");
            if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
                writer.writeAttribute("role", (Object)"tablist", "role");
            }
            TabSetRenderer.doTabs(facesContext, uiComponent, Do.RENDER_LABEL, null, null, null);
            writer.endElement("ul");
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "cnt"), "id");
            writer.writeAttribute("class", (Object)"yui-content ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-content-vertical", "class");
            writer.endElement("div");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String tabClientId2;
        int i;
        ResponseWriter writer = facesContext.getResponseWriter();
        TabSet tabSet = (TabSet)uiComponent;
        String clientId = uiComponent.getClientId(facesContext);
        String styleClass = "yui-navset yui-navset-top ui-tabset ui-widget ui-widget-content ui-corner-all ";
        String orientation = tabSet.getOrientation();
        if ("left".equalsIgnoreCase(orientation)) {
            styleClass = "yui-navset yui-navset-left ui-tabset-vertical ui-widget ui-widget-content ui-corner-all ";
        } else if ("right".equalsIgnoreCase(orientation)) {
            styleClass = "yui-navset yui-navset-right ui-tabset-vertical ui-widget ui-widget-content ui-corner-all ";
        } else if ("bottom".equalsIgnoreCase(orientation)) {
            styleClass = "yui-navset yui-navset-bottom ui-tabset ui-widget ui-widget-content ui-corner-all ";
        }
        Object userDefinedClass = tabSet.getAttributes().get("styleClass");
        if (userDefinedClass != null) {
            styleClass = styleClass + userDefinedClass.toString();
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        boolean isClientSide = tabSet.isClientSide();
        String showEffect = tabSet.getShowEffect();
        showEffect = showEffect == null || showEffect.trim().equals("") ? "" : showEffect;
        int showEffectLength = tabSet.getShowEffectLength();
        int selectedIndex = tabSet.getSelectedIndex();
        if (selectedIndex >= this.getRenderedChildCount((UIComponent)tabSet)) {
            selectedIndex = 0;
        }
        ArrayList<String> clickableTabs = new ArrayList<String>();
        ArrayList<Integer> disabledTabs = new ArrayList<Integer>();
        HashMap<String, TabPaneCache> tabPaneClientId2Cache = new HashMap<String, TabPaneCache>();
        TabSetRenderer.doTabs(facesContext, uiComponent, Do.GET_CLIENT_IDS, clickableTabs, tabPaneClientId2Cache, disabledTabs);
        ArrayList<String> visitedTabClientIds = tabSet.getVisitedTabClientIds();
        if (visitedTabClientIds == null) {
            visitedTabClientIds = new ArrayList<String>();
            tabSet.setVisitedTabClientIds(visitedTabClientIds);
        }
        ArrayList<String> toRender = new ArrayList<String>();
        HashSet<String> renderWithoutUpdate = new HashSet<String>();
        if (isClientSide) {
            toRender.addAll(clickableTabs);
        } else {
            for (i = 0; i < clickableTabs.size(); ++i) {
                tabClientId2 = (String)clickableTabs.get(i);
                TabPaneCache cache = (TabPaneCache)((Object)tabPaneClientId2Cache.get(tabClientId2));
                if (cache == null) {
                    cache = TabPaneCache.get("none");
                }
                if (cache.isCached() && visitedTabClientIds.contains(tabClientId2)) {
                    toRender.add(tabClientId2);
                    if (!cache.isCachedStatically()) continue;
                    renderWithoutUpdate.add(tabClientId2);
                    continue;
                }
                if (selectedIndex != i) continue;
                toRender.add(tabClientId2);
            }
        }
        for (i = 0; i < visitedTabClientIds.size(); ++i) {
            tabClientId2 = (String)visitedTabClientIds.get(i);
            if (tabClientId2 == null || toRender.contains(tabClientId2)) continue;
            visitedTabClientIds.set(i, null);
        }
        for (String tabClientId2 : toRender) {
            if (visitedTabClientIds.contains(tabClientId2)) continue;
            visitedTabClientIds.add(tabClientId2);
        }
        String safeIdPrefix = clientId + "_safe_";
        int clickableLen = clickableTabs.size();
        String[] safeIds = new String[clickableLen];
        for (int i2 = 0; i2 < clickableLen; ++i2) {
            int safeIndex = visitedTabClientIds.indexOf(clickableTabs.get(i2));
            if (safeIndex < 0) continue;
            safeIds[i2] = safeIdPrefix + safeIndex;
        }
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_safe"), "id");
        writer.writeAttribute("style", (Object)"display:none;", "style");
        this.recursivelyRenderSafe(facesContext, writer, tabSet, safeIdPrefix, visitedTabClientIds, renderWithoutUpdate, 0);
        writer.endElement("div");
        Integer decSelIdx = this.decodeSelectedIndex(facesContext, uiComponent);
        boolean unexpected = decSelIdx != null && decSelIdx != selectedIndex;
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.tabset.updateProperties").item(clientId).beginMap().entry("orientation", orientation).entry("showEffect", showEffect).entry("showEffectLength", showEffectLength).endMap().beginMap().entry("isClientSide", isClientSide).entry("aria", EnvUtils.isAriaEnabled((FacesContext)facesContext)).entry("selectedIndex", selectedIndex).entry("safeIds", safeIds).beginArray("disabledTabs");
        for (Integer i3 : disabledTabs) {
            jb.item(i3);
        }
        jb.endArray().entry("overrideSelectedIndex", unexpected ? System.currentTimeMillis() : 0L);
        this.encodeClientBehaviors(facesContext, tabSet, jb);
        jb.endMap().endFunction();
        ScriptWriter.insertScript(facesContext, uiComponent, jb.toString());
        writer.endElement("div");
    }

    private void recursivelyRenderSafe(FacesContext facesContext, ResponseWriter writer, TabSet tabSet, String idPrefix, List visitedTabClientIds, Set<String> renderWithoutUpdate, int index) throws IOException {
        if (index >= visitedTabClientIds.size()) {
            return;
        }
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("id", (Object)(idPrefix + index), "id");
        String tabClientId = (String)visitedTabClientIds.get(index);
        if (tabClientId != null) {
            if (renderWithoutUpdate.contains(tabClientId)) {
                TabSetRenderer.doTabs(facesContext, (UIComponent)tabSet, Do.RENDER_CONTENT_DIV_BY_CLIENT_ID, visitedTabClientIds.subList(index, index + 1), null, null);
            } else {
                TabSetRenderer.doTabs(facesContext, (UIComponent)tabSet, Do.RENDER_CONTENTS_BY_CLIENT_ID, visitedTabClientIds.subList(index, index + 1), null, null);
            }
        }
        writer.endElement("div");
        writer.startElement("div", (UIComponent)tabSet);
        writer.writeAttribute("id", (Object)(idPrefix + index + "_nxt"), "id");
        this.recursivelyRenderSafe(facesContext, writer, tabSet, idPrefix, visitedTabClientIds, renderWithoutUpdate, index + 1);
        writer.endElement("div");
    }

    private static void renderTabNav(FacesContext facesContext, TabSet tabSet, UIComponent tab, int index) throws IOException {
        String clientId = tab.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("li", tab);
        if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
            writer.writeAttribute("role", (Object)"presentation", "role");
        }
        writer.writeAttribute("id", (Object)(clientId + "li" + index), "id");
        UIComponent labelFacet = ((TabPane)tab).getLabelFacet();
        String styleClass = "";
        styleClass = tabSet.isDisabled() ? styleClass + "ui-state-disabled" : styleClass + "ui-state-default";
        styleClass = "top".equals(tabSet.getOrientation()) ? styleClass + " ui-corner-top" : ("bottom".equals(tabSet.getOrientation()) ? styleClass + " ui-corner-bottom" : styleClass + " ui-corner-all");
        writer.writeAttribute("class", (Object)styleClass, "class");
        writer.startElement("div", tab);
        if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
            writer.writeAttribute("role", (Object)"tab", "role");
        }
        writer.writeAttribute("id", (Object)(clientId + "tab" + index), "id");
        writer.writeAttribute("tabindex", (Object)"0", "tabindex");
        writer.writeAttribute("class", (Object)"yui-navdiv", "class");
        writer.startElement("em", tab);
        writer.writeAttribute("id", (Object)(clientId + "Lbl"), "id");
        writer.writeAttribute("onclick", (Object)"if(ice.ace.util.isEventSourceInputElement(event)) event.cancelBubble = true;", "onclick");
        if (labelFacet != null) {
            Utils.renderChild(facesContext, ((TabPane)tab).getLabelFacet());
        } else {
            writer.write(String.valueOf(tab.getAttributes().get("label")));
        }
        writer.endElement("em");
        writer.endElement("div");
        writer.startElement("a", tab);
        writer.writeAttribute("style", (Object)"display:none;", "style");
        writer.endElement("a");
        writer.endElement("li");
    }

    private static void renderTabBody(FacesContext facesContext, TabSet tabSet, UIComponent tab, int index, Do d) throws IOException {
        String clientId = tab.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", tab);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("tabindex", (Object)0, "tabindex");
        writer.writeAttribute("class", (Object)"ui-tabs-panel ui-widget-content ui-corner-bottom", "class");
        if (EnvUtils.isAriaEnabled((FacesContext)facesContext)) {
            writer.writeAttribute("role", (Object)"tabpanel", "role");
        }
        if (Do.RENDER_CONTENT_DIV_BY_CLIENT_ID.equals((Object)d)) {
            writer.writeAttribute(DOMUtils.DIFF_SUPPRESS, (Object)DOMUtils.DIFF_TRUE, null);
        }
        if (!Do.RENDER_CONTENT_DIV_BY_CLIENT_ID.equals((Object)d)) {
            Utils.renderChild(facesContext, tab);
        }
        writer.endElement("div");
    }

    static void doTabs(FacesContext facesContext, UIComponent uiComponent, Do d, List<String> clickableTabs, Map<String, TabPaneCache> tabPaneClientId2Cache, ArrayList<Integer> disabledTabs) throws IOException {
        TabSet tabSet = (TabSet)uiComponent;
        Iterator children = tabSet.getChildren().iterator();
        int index = -1;
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (child instanceof TabPane) {
                if (!child.isRendered()) continue;
                TabSetRenderer.doTab(facesContext, tabSet, (TabPane)child, ++index, d, clickableTabs, tabPaneClientId2Cache, disabledTabs);
                continue;
            }
            if (!(child instanceof Tabs)) continue;
            Tabs uiList = (Tabs)child;
            int rowIndex = uiList.getFirst();
            int numberOfRowsToDisplay = uiList.getRows();
            for (int countOfRowsDisplayed = 0; numberOfRowsToDisplay == 0 || numberOfRowsToDisplay > 0 && countOfRowsDisplayed < numberOfRowsToDisplay; ++countOfRowsDisplayed) {
                uiList.setRowIndex(rowIndex);
                if (!uiList.isRowAvailable()) break;
                if (uiList.getChildCount() > 0) {
                    for (UIComponent nextChild : uiList.getChildren()) {
                        if (!(nextChild instanceof TabPane) || !nextChild.isRendered()) continue;
                        TabSetRenderer.doTab(facesContext, tabSet, (TabPane)nextChild, ++index, d, clickableTabs, tabPaneClientId2Cache, disabledTabs);
                    }
                }
                ++rowIndex;
            }
            uiList.setRowIndex(-1);
        }
    }

    private static void doTab(FacesContext facesContext, TabSet tabSet, TabPane tab, int index, Do d, List<String> clickableTabs, Map<String, TabPaneCache> tabPaneClientId2Cache, ArrayList<Integer> disabledTabs) throws IOException {
        if (Do.RENDER_LABEL.equals((Object)d)) {
            TabSetRenderer.renderTabNav(facesContext, tabSet, (UIComponent)tab, index);
        } else if (Do.RENDER_CONTENTS.equals((Object)d)) {
            TabSetRenderer.renderTabBody(facesContext, tabSet, (UIComponent)tab, index, d);
        } else if (Do.GET_CLIENT_IDS.equals((Object)d)) {
            String clientId = tab.getClientId(facesContext);
            clickableTabs.add(clientId);
            TabPaneCache orig = TabPaneCache.get(tab.getCache());
            TabPaneCache cache = orig.resolve(facesContext, (UIComponent)tab);
            tabPaneClientId2Cache.put(clientId, cache);
            TabPaneCache revert = cache.getRevertTo();
            if (tab.isDisabled()) {
                disabledTabs.add(index);
            }
            if (revert != null && revert != orig) {
                tab.setCache(revert.getNamed());
            }
        } else if (Do.RENDER_CONTENTS_BY_CLIENT_ID.equals((Object)d)) {
            if (clickableTabs.contains(tab.getClientId(facesContext))) {
                TabSetRenderer.renderTabBody(facesContext, tabSet, (UIComponent)tab, index, d);
            }
        } else if (Do.RENDER_CONTENT_DIV_BY_CLIENT_ID.equals((Object)d)) {
            if (clickableTabs.contains(tab.getClientId(facesContext))) {
                TabSetRenderer.renderTabBody(facesContext, tabSet, (UIComponent)tab, index, d);
            }
        } else if (Do.GET_CLIENT_IDS_ONLY.equals((Object)d)) {
            String clientId = tab.getClientId(facesContext);
            clickableTabs.add(clientId);
        }
    }

    private int getRenderedChildCount(UIComponent uiComponent) {
        int count = 0;
        for (UIComponent component : uiComponent.getChildren()) {
            if (!(component instanceof TabPane) || !component.isRendered()) continue;
            ++count;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Do {
        RENDER_LABEL,
        RENDER_CONTENTS,
        RENDER_CONTENTS_BY_CLIENT_ID,
        RENDER_CONTENT_DIV_BY_CLIENT_ID,
        GET_CLIENT_IDS,
        GET_CLIENT_IDS_ONLY;

    }
}

