/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.ajax;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorListener;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.icefaces.ace.api.IceClientBehaviorHolder;
import org.icefaces.ace.component.ajax.AjaxBehavior;
import org.icefaces.ace.component.ajax.AjaxBehaviorHandlerBase;
import org.icefaces.ace.component.ajax.AjaxBehaviorListenerImpl;

public class AjaxBehaviorHandler
extends AjaxBehaviorHandlerBase
implements BehaviorHolderAttachedObjectHandler {
    protected final boolean wrapping = this.isWrapping();

    public AjaxBehaviorHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String eventName = this.getEventName();
        if (this.wrapping) {
            this.applyWrapping(ctx, parent, eventName);
        } else {
            this.applyNested(ctx, parent, eventName);
        }
    }

    protected boolean isWrapping() {
        return this.nextHandler instanceof TagHandler || this.nextHandler instanceof CompositeFaceletHandler;
    }

    protected void applyWrapping(FaceletContext ctx, UIComponent parent, String eventName) throws IOException {
        this.nextHandler.apply(ctx, parent);
    }

    private void applyNested(FaceletContext ctx, UIComponent parent, String eventName) {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        boolean isClientBehaviorHolder = parent instanceof ClientBehaviorHolder;
        boolean isCompositeComponent = UIComponent.isCompositeComponent((UIComponent)parent);
        this.verifyNestClientBehaviorHolderAndOrCompositeComp(isClientBehaviorHolder, isCompositeComponent);
        if (isClientBehaviorHolder) {
            this.applyAttachedObject(ctx, parent, eventName, true);
        }
        if (isCompositeComponent) {
            BeanInfo beanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            this.verifyNestCompositeCompBeanInfo(beanInfo);
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            this.verifyNestCompositeCompBeanDescriptor(beanDescriptor);
            List attachedObjectTargetList = (List)beanDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            boolean isCorrespondingAttachedObjectTarget = this.verifyNestCompositeCompTakesBehaviorEvent(isClientBehaviorHolder, attachedObjectTargetList, eventName);
            if (isCorrespondingAttachedObjectTarget) {
                Map attrs = parent.getAttributes();
                String key = "javax.faces.RetargetableHandlers";
                ArrayList<AjaxBehaviorHandler> handlers = (ArrayList<AjaxBehaviorHandler>)attrs.get("javax.faces.RetargetableHandlers");
                if (null == handlers) {
                    handlers = new ArrayList<AjaxBehaviorHandler>(6);
                    attrs.put("javax.faces.RetargetableHandlers", handlers);
                }
                handlers.add(this);
            }
        }
    }

    public String getEventName() {
        return this.event != null ? this.event.getValue() : null;
    }

    public String getFor() {
        return null;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        this.applyAttachedObject(ctx, parent, this.getEventName(), false);
    }

    protected void applyAttachedObject(FaceletContext ctx, UIComponent parent, String eventName, boolean calledOurselves) {
        ClientBehaviorHolder parentClientBehaviorHolder = (ClientBehaviorHolder)parent;
        boolean applicable = this.verifyAttachClientBehaviorHolder(eventName, parentClientBehaviorHolder, calledOurselves);
        if (applicable) {
            if (null == eventName) {
                eventName = parentClientBehaviorHolder.getDefaultEventName();
            }
            ClientBehavior ajaxBehavior = this.createAjaxBehavior(ctx, parent, eventName);
            parentClientBehaviorHolder.addClientBehavior(eventName, ajaxBehavior);
        }
    }

    protected ClientBehavior createAjaxBehavior(FaceletContext ctx, UIComponent parent, String eventName) {
        Application application = ctx.getFacesContext().getApplication();
        AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("org.icefaces.ace.component.AjaxBehavior");
        this.setBehaviorAttribute(ctx, behavior, this.onStart, AjaxBehavior.Property.onStart);
        this.setBehaviorAttribute(ctx, behavior, this.onComplete, AjaxBehavior.Property.onComplete);
        this.setBehaviorAttribute(ctx, behavior, this.onSuccess, AjaxBehavior.Property.onSuccess);
        this.setBehaviorAttribute(ctx, behavior, this.onError, AjaxBehavior.Property.onError);
        this.setBehaviorAttribute(ctx, behavior, this.disabled, AjaxBehavior.Property.disabled);
        this.setBehaviorAttribute(ctx, behavior, this.immediate, AjaxBehavior.Property.immediate);
        this.setBehaviorAttribute(ctx, behavior, this.execute, AjaxBehavior.Property.execute);
        this.setBehaviorAttribute(ctx, behavior, this.render, AjaxBehavior.Property.render);
        this.addListenerToAjaxBehavior(ctx, parent, behavior, eventName);
        return behavior;
    }

    protected void setBehaviorAttribute(FaceletContext ctx, AjaxBehavior behavior, TagAttribute attr, AjaxBehavior.Property property) {
        if (null != attr) {
            if (attr.isLiteral()) {
                behavior.setLiteral(property, attr.getObject(ctx, property.expectedType));
            } else {
                behavior.setValueExpression(property, attr.getValueExpression(ctx, property.expectedType));
            }
        }
    }

    protected void addListenerToAjaxBehavior(FaceletContext ctx, UIComponent parent, AjaxBehavior ajaxBehavior, String eventName) {
        if (null == this.listener) {
            return;
        }
        Class<AjaxBehaviorEvent> superArgEventClass = AjaxBehaviorEvent.class;
        Class oneArgEventClass = this.deriveEventClass(parent, eventName, superArgEventClass);
        Class returnType = null;
        MethodExpression noArg = this.listener.getMethodExpression(ctx, returnType, new Class[0]);
        MethodExpression oneArg = oneArgEventClass == null ? null : this.listener.getMethodExpression(ctx, returnType, new Class[]{oneArgEventClass});
        MethodExpression superArg = this.listener.getMethodExpression(ctx, returnType, new Class[]{superArgEventClass});
        AjaxBehaviorListenerImpl behaviorListener = new AjaxBehaviorListenerImpl(noArg, oneArg, superArg);
        ajaxBehavior.addBehaviorListener((BehaviorListener)behaviorListener);
    }

    protected Class deriveEventClass(UIComponent parent, String eventName, Class superArgEventClass) {
        Class<?> oneArgEventClass = null;
        if (parent instanceof IceClientBehaviorHolder) {
            IceClientBehaviorHolder aceParent = (IceClientBehaviorHolder)parent;
            if (eventName != null) {
                StringBuilder className = new StringBuilder("org.icefaces.ace.event.");
                int toUpperIndex = className.length();
                className.append(eventName).append("Event");
                className.setCharAt(toUpperIndex, Character.toUpperCase(className.charAt(toUpperIndex)));
                try {
                    Class<?> clazz = Class.forName(className.toString());
                    if (superArgEventClass.isAssignableFrom(clazz)) {
                        oneArgEventClass = clazz;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return oneArgEventClass;
    }

    protected void verifyNestClientBehaviorHolderAndOrCompositeComp(boolean isClientBehaviorHolder, boolean isCompositeComponent) {
        if (!isClientBehaviorHolder && !isCompositeComponent) {
            throw new TagException(this.tag, "Error: ace:ajax is nested in a parent that does not support behaviors");
        }
    }

    protected void verifyNestCompositeCompBeanInfo(BeanInfo bi) {
        if (null == bi) {
            throw new TagException(this.tag, "Error: ace:ajax is nested in a composite component that does not have a BeanInfo attribute");
        }
    }

    protected void verifyNestCompositeCompBeanDescriptor(BeanDescriptor beanDescriptor) {
        if (null == beanDescriptor) {
            throw new TagException(this.tag, "Error: ace:ajax is nested in a composite component that does not have a BeanDescriptor");
        }
    }

    protected boolean verifyNestCompositeCompTakesBehaviorEvent(boolean isClientBehaviorHolder, List<AttachedObjectTarget> attachedObjectTargetList, String eventName) {
        if (!isClientBehaviorHolder && null == attachedObjectTargetList) {
            throw new TagException(this.tag, "Error: ace:ajax is nested in a composite component that does not support behaviors");
        }
        boolean isCorrespondingAttachedObjectTarget = false;
        if (null != attachedObjectTargetList) {
            for (AttachedObjectTarget target : attachedObjectTargetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                isCorrespondingAttachedObjectTarget = true;
                break;
            }
        }
        if (!isClientBehaviorHolder && !isCorrespondingAttachedObjectTarget) {
            throw new TagException(this.tag, "Error: ace:ajax is nested in a composite component that does not support its event: " + eventName);
        }
        return isCorrespondingAttachedObjectTarget;
    }

    protected boolean verifyAttachClientBehaviorHolder(String eventName, ClientBehaviorHolder parentClientBehaviorHolder, boolean doThrow) {
        if (null == eventName) {
            eventName = parentClientBehaviorHolder.getDefaultEventName();
            if (null == eventName) {
                if (!doThrow) {
                    return false;
                }
                throw new TagException(this.tag, "Error: ace:ajax has unspecified event name, and is nested in a ClientBehaviorHolder that does not specify a default event name");
            }
        } else {
            Collection eventNames = parentClientBehaviorHolder.getEventNames();
            if (!eventNames.contains(eventName)) {
                if (!doThrow) {
                    return false;
                }
                throw new TagException(this.tag, "Error: ace:ajax specifies an event name that is unsupported by its parent ClientBehaviorHolder. Event name: " + eventName + ", Parent: " + parentClientBehaviorHolder + ", Valid values: " + eventNames);
            }
        }
        return true;
    }
}

