/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.autocompleteentry;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.icefaces.ace.component.autocompleteentry.AutoCompleteEntry;
import org.icefaces.ace.component.autocompleteentry.KeyEvent;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="autoCompleteEntry", value="org.icefaces.ace.component.autocompleteentry.AutoCompleteEntry")
public class AutoCompleteEntryRenderer
extends InputRenderer {
    private static final String AUTOCOMPLETE_DIV = "_div";
    static final String AUTOCOMPLETE_INDEX = "_idx";

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        this.decodeBehaviors(facesContext, uiComponent);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean focus;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        AutoCompleteEntry autoCompleteEntry = (AutoCompleteEntry)uiComponent;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)autoCompleteEntry.getStyleClass(), null);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        Map<String, Object> labelAttributes = this.getLabelAttributes(uiComponent);
        String inFieldLabel = (String)labelAttributes.get("inFieldLabel");
        String inFieldLabelStyleClass = "";
        String iceFocus = (String)paramMap.get("ice.focus");
        String value = (String)autoCompleteEntry.getValue();
        boolean labelIsInField = false;
        if (this.isValueBlank(value)) {
            value = null;
        }
        String inputClientId = clientId + "_input";
        if (value == null && !this.isValueBlank(inFieldLabel) && !inputClientId.equals(iceFocus)) {
            value = inFieldLabel;
            inFieldLabelStyleClass = " ui-input-label-infield";
            labelIsInField = true;
        }
        this.writeLabelAndIndicatorBefore(labelAttributes);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("name", (Object)inputClientId, null);
        String mousedownScript = (String)uiComponent.getAttributes().get("onmousedown");
        mousedownScript = mousedownScript == null ? "" : mousedownScript;
        writer.writeAttribute("onmousedown", (Object)(mousedownScript + "this.focus();"), null);
        int width = autoCompleteEntry.getWidth();
        writer.writeAttribute("style", (Object)("width: " + width + "px;"), null);
        writer.writeAttribute("class", (Object)("ui-inputfield ui-widget ui-state-default ui-corner-all" + this.getStateStyleClasses((UIInput)autoCompleteEntry) + inFieldLabelStyleClass), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        String onfocusCombinedValue = "setFocus(this.id);";
        Object onfocusAppValue = uiComponent.getAttributes().get("onfocus");
        if (onfocusAppValue != null) {
            onfocusCombinedValue = onfocusCombinedValue + onfocusAppValue.toString();
        }
        writer.writeAttribute("onfocus", (Object)onfocusCombinedValue, null);
        String onblurCombinedValue = "";
        Object onblurAppValue = uiComponent.getAttributes().get("onblur");
        if (onblurAppValue != null) {
            onblurCombinedValue = onblurCombinedValue + onblurAppValue.toString();
        }
        writer.writeAttribute("onblur", (Object)onblurCombinedValue, null);
        Object onchangeAppValue = uiComponent.getAttributes().get("onchange");
        if (onchangeAppValue != null) {
            writer.writeAttribute("onchange", (Object)onchangeAppValue.toString(), null);
        }
        if (value != null) {
            Object submittedValue = autoCompleteEntry.getSubmittedValue();
            if (submittedValue != null && "".equals((String)submittedValue) && !"".equals(value) && autoCompleteEntry.isRequired()) {
                value = "";
            }
            writer.writeAttribute("value", (Object)value, null);
        } else {
            writer.writeAttribute("value", (Object)"", null);
        }
        writer.endElement("input");
        this.writeLabelAndIndicatorAfter(labelAttributes);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        String indexId = clientId + AUTOCOMPLETE_INDEX;
        writer.writeAttribute("name", (Object)indexId, null);
        writer.endElement("input");
        writer.startElement("div", null);
        String divId = clientId + AUTOCOMPLETE_DIV;
        writer.writeAttribute("id", (Object)(clientId + AUTOCOMPLETE_DIV), null);
        writer.writeAttribute("class", (Object)"ui-widget ui-widget-content ui-corner-all", null);
        writer.writeAttribute("style", (Object)"display:none;z-index:500;", null);
        writer.endElement("div");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String direction = autoCompleteEntry.getDirection();
        direction = direction != null ? ("up".equalsIgnoreCase(direction) || "down".equalsIgnoreCase(direction) ? direction : "auto") : "auto";
        boolean isEventSource = false;
        Object componenetId = paramMap.get("ice.event.captured");
        if (componenetId != null && componenetId.toString().equals(inputClientId)) {
            isEventSource = true;
        }
        boolean isBlurEvent = false;
        KeyEvent keyEvent = new KeyEvent((UIComponent)autoCompleteEntry, paramMap);
        if (keyEvent.getKeyCode() == 9) {
            isBlurEvent = true;
        }
        boolean bl = focus = isEventSource && !isBlurEvent;
        if (!autoCompleteEntry.isDisabled() && !autoCompleteEntry.isReadonly()) {
            JSONBuilder jb = JSONBuilder.create();
            jb.beginFunction("ice.ace.Autocompleter").item(clientId).item(divId).item("ui-widget-content").item("ui-state-active").item(autoCompleteEntry.getDelay()).item(autoCompleteEntry.getMinChars()).item(autoCompleteEntry.getHeight()).item(direction).item(focus).beginMap().entry("p", "");
            this.encodeClientBehaviors(facesContext, autoCompleteEntry, jb);
            jb.endMap();
            jb.beginMap().entryNonNullValue("inFieldLabel", inFieldLabel).entry("inFieldLabelStyleClass", "ui-input-label-infield").entry("labelIsInField", labelIsInField);
            jb.endMap().endFunction();
            writer.writeText((Object)("new " + jb.toString()), null);
        }
        writer.endElement("script");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        AutoCompleteEntry autoCompleteEntry = (AutoCompleteEntry)uiComponent;
        String clientId = autoCompleteEntry.getClientId(facesContext);
        if (autoCompleteEntry.getValue() != null && autoCompleteEntry.hasChanged()) {
            this.populateList(facesContext, autoCompleteEntry);
            autoCompleteEntry.setChangedComponentId(null);
        } else {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_update"), null);
            this.encodeDynamicScript(facesContext, (UIComponent)autoCompleteEntry, "");
            writer.endElement("div");
        }
    }

    public void populateList(FacesContext facesContext, AutoCompleteEntry autoCompleteEntry) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = autoCompleteEntry.getClientId(facesContext);
        autoCompleteEntry.populateItemList();
        Iterator matches = autoCompleteEntry.getItemList();
        String filter = (String)autoCompleteEntry.getValue();
        FilterMatchMode filterMatchMode = this.getFilterMatchMode(autoCompleteEntry);
        String mainValue = (String)autoCompleteEntry.getValue();
        int rows = autoCompleteEntry.getRows();
        if (rows == 0) {
            rows = Integer.MAX_VALUE;
        }
        int rowCounter = 0;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_update"), null);
        if (autoCompleteEntry.getSelectFacet() != null) {
            UIComponent facet = autoCompleteEntry.getSelectFacet();
            ValueExpression filterBy = autoCompleteEntry.getValueExpression("filterBy");
            ELContext elContext = facesContext.getELContext();
            String listVar = autoCompleteEntry.getListVar();
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)"display: none;", null);
            writer.startElement("div", null);
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            autoCompleteEntry.setIndex(0);
            while (matches.hasNext() && rowCounter < rows) {
                requestMap.put(listVar, matches.next());
                String value = (String)filterBy.getValue(elContext);
                if (this.satisfiesFilter(value, filter, filterMatchMode, autoCompleteEntry)) {
                    ++rowCounter;
                    writer.startElement("div", null);
                    writer.writeAttribute("style", (Object)"border: 0;", null);
                    writer.startElement("span", null);
                    writer.writeAttribute("class", (Object)"informal", null);
                    AutoCompleteEntryRenderer.encodeParentAndChildren(facesContext, facet);
                    writer.endElement("span");
                    writer.startElement("span", null);
                    writer.writeAttribute("style", (Object)"visibility:hidden;display:none;", null);
                    String itemLabel = value;
                    if (itemLabel == null) {
                        itemLabel = value;
                    }
                    writer.writeText((Object)itemLabel, null);
                    writer.endElement("span");
                    autoCompleteEntry.resetId(facet);
                    writer.endElement("div");
                }
                requestMap.remove(listVar);
            }
            autoCompleteEntry.setIndex(-1);
            writer.endElement("div");
            String call = "ice.ace.Autocompleters[\"" + clientId + "\"].updateNOW(ice.ace.jq(ice.ace.escapeClientId('" + clientId + "_update')).get(0).firstChild.innerHTML);";
            this.encodeDynamicScript(facesContext, (UIComponent)autoCompleteEntry, call + "// " + mainValue);
            writer.endElement("div");
        } else if (matches.hasNext()) {
            StringBuffer sb = new StringBuffer("<div>");
            SelectItem item = null;
            while (matches.hasNext() && rowCounter < rows) {
                item = (SelectItem)matches.next();
                String itemLabel = item.getLabel();
                if (itemLabel == null) {
                    itemLabel = item.getValue().toString();
                }
                if (!this.satisfiesFilter(itemLabel, filter, filterMatchMode, autoCompleteEntry)) continue;
                sb.append("<div style=\"border: 0;\">").append(itemLabel).append("</div>");
                ++rowCounter;
            }
            sb.append("</div>");
            String call = "ice.ace.Autocompleters[\"" + clientId + "\"]" + ".updateNOW('" + AutoCompleteEntryRenderer.escapeSingleQuote(sb.toString()) + "');";
            this.encodeDynamicScript(facesContext, (UIComponent)autoCompleteEntry, call + "// " + mainValue);
        }
        writer.endElement("div");
    }

    public void encodeDynamicScript(FacesContext facesContext, UIComponent uiComponent, String call) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        writer.startElement("span", null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)call, null);
        writer.endElement("script");
        writer.endElement("span");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    private static String escapeSingleQuote(String text) {
        if (null == text) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch == '\'') {
                buffer.append("&#39;");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static void encodeParentAndChildren(FacesContext facesContext, UIComponent parent) throws IOException {
        parent.encodeBegin(facesContext);
        if (parent.getRendersChildren()) {
            parent.encodeChildren(facesContext);
        } else if (parent.getChildCount() > 0) {
            for (UIComponent nextChild : parent.getChildren()) {
                if (!nextChild.isRendered()) continue;
                AutoCompleteEntryRenderer.encodeParentAndChildren(facesContext, nextChild);
            }
        }
        parent.encodeEnd(facesContext);
    }

    private FilterMatchMode getFilterMatchMode(AutoCompleteEntry autoCompleteEntry) {
        String filterMatchMode = autoCompleteEntry.getFilterMatchMode();
        if ("contains".equalsIgnoreCase(filterMatchMode)) {
            return FilterMatchMode.contains;
        }
        if ("exact".equalsIgnoreCase(filterMatchMode)) {
            return FilterMatchMode.exact;
        }
        if ("endsWith".equalsIgnoreCase(filterMatchMode)) {
            return FilterMatchMode.endsWith;
        }
        if ("none".equalsIgnoreCase(filterMatchMode)) {
            return FilterMatchMode.none;
        }
        return FilterMatchMode.startsWith;
    }

    private boolean satisfiesFilter(String string, String filter, FilterMatchMode filterMatchMode, AutoCompleteEntry autoCompleteEntry) {
        if (string != null) {
            if (!autoCompleteEntry.isCaseSensitive()) {
                string = string.toLowerCase();
                filter = filter.toLowerCase();
            }
            switch (filterMatchMode) {
                case contains: {
                    if (string.indexOf(filter) < 0) break;
                    return true;
                }
                case exact: {
                    if (!string.equals(filter)) break;
                    return true;
                }
                case startsWith: {
                    if (!string.startsWith(filter)) break;
                    return true;
                }
                case endsWith: {
                    if (!string.endsWith(filter)) break;
                    return true;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    private static enum FilterMatchMode {
        contains,
        exact,
        startsWith,
        endsWith,
        none;

    }
}

