/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datetimeentry;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.ace.component.datetimeentry.DateTimeEntry;
import org.icefaces.ace.component.datetimeentry.DateTimeEntryUtils;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="dateTimeEntry", value="org.icefaces.ace.component.datetimeentry.DateTimeEntry")
public class DateTimeEntryRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        if (dateTimeEntry.isDisabled() || dateTimeEntry.isReadonly()) {
            return;
        }
        String clientId = dateTimeEntry.getClientId(context);
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)parameterMap.get(clientId + "_input");
        if (submittedValue == null && parameterMap.get(clientId + "_label") != null) {
            submittedValue = "";
        }
        if (submittedValue != null) {
            dateTimeEntry.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)dateTimeEntry);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String value = DateTimeEntryUtils.getValueAsString(context, dateTimeEntry);
        Map<String, Object> labelAttributes = this.getLabelAttributes(component);
        this.encodeMarkup(context, dateTimeEntry, value, labelAttributes);
    }

    protected void encodeMarkup(FacesContext context, DateTimeEntry dateTimeEntry, String value, Map<String, Object> labelAttributes) throws IOException {
        String inFieldLabel;
        String type;
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dateTimeEntry.getClientId(context);
        String inputId = clientId + "_input";
        boolean popup = dateTimeEntry.isPopup();
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String iceFocus = (String)paramMap.get("ice.focus");
        writer.startElement("span", (UIComponent)dateTimeEntry);
        writer.writeAttribute("id", (Object)clientId, null);
        String style = dateTimeEntry.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = dateTimeEntry.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (!popup) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        String string = type = popup ? "text" : "hidden";
        if (popup) {
            this.writeLabelAndIndicatorBefore(labelAttributes);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)type, null);
        writer.writeAttribute("tabindex", (Object)dateTimeEntry.getTabindex(), null);
        String styleClasses = (this.themeForms() ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "") + this.getStateStyleClasses(dateTimeEntry);
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        } else if (popup && !clientId.equals(iceFocus) && !this.isValueBlank(inFieldLabel = (String)labelAttributes.get("inFieldLabel"))) {
            writer.writeAttribute("name", (Object)(clientId + "_label"), null);
            writer.writeAttribute("value", (Object)inFieldLabel, null);
            styleClasses = styleClasses + " ui-input-label-infield";
            labelAttributes.put("labelIsInField", true);
        }
        if (popup) {
            int size;
            if (!this.isValueBlank(styleClasses)) {
                writer.writeAttribute("class", (Object)styleClasses, null);
            }
            if (dateTimeEntry.isReadOnlyInputText()) {
                writer.writeAttribute("readonly", (Object)"readonly", null);
            }
            if (dateTimeEntry.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            if ((size = dateTimeEntry.getSize()) <= 0) {
                String formattedDate;
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeEntry.getPattern(), dateTimeEntry.calculateLocale(context));
                try {
                    formattedDate = dateFormat.format(new SimpleDateFormat("yyy-M-d H:m:s:S z").parse("2012-12-21 20:12:12:212 MST"));
                }
                catch (ParseException e) {
                    formattedDate = dateFormat.format(new Date());
                }
                size = formattedDate.length();
            }
            writer.writeAttribute("size", (Object)size, null);
        }
        writer.endElement("input");
        if (popup) {
            this.writeLabelAndIndicatorAfter(labelAttributes);
        }
        this.encodeScript(context, dateTimeEntry, value, labelAttributes);
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, DateTimeEntry dateTimeEntry, String value, Map<String, Object> labelAttributes) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dateTimeEntry.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String showOn = dateTimeEntry.getShowOn();
        boolean timeOnly = dateTimeEntry.isTimeOnly();
        StringBuilder script = new StringBuilder();
        JSONBuilder json = JSONBuilder.create();
        script.append("ice.ace.jq(function(){").append(DateTimeEntryRenderer.resolveWidgetVar((UIComponent)dateTimeEntry)).append(" = new ");
        json.beginFunction("ice.ace.Calendar").item(clientId).beginMap().entry("popup", dateTimeEntry.isPopup()).entry("locale", dateTimeEntry.calculateLocale(context).toString());
        if (!this.isValueBlank(value) && !timeOnly && dateTimeEntry.isValid()) {
            json.entry("defaultDate", value);
        }
        json.entryNonNullValue("pattern", DateTimeEntryUtils.convertPattern(dateTimeEntry.getPattern()));
        if (dateTimeEntry.getPages() != 1) {
            json.entry("numberOfMonths", dateTimeEntry.getPages());
        }
        json.entryNonNullValue("minDate", DateTimeEntryUtils.getDateAsString(dateTimeEntry, dateTimeEntry.getMindate())).entryNonNullValue("maxDate", DateTimeEntryUtils.getDateAsString(dateTimeEntry, dateTimeEntry.getMaxdate()));
        json.entryNonNullValue("showButtonPanel", dateTimeEntry.isShowButtonPanel());
        if (dateTimeEntry.isShowWeek()) {
            json.entry("showWeek", true);
        }
        if (dateTimeEntry.isDisabled()) {
            json.entry("disabled", true);
        }
        json.entryNonNullValue("yearRange", dateTimeEntry.getYearRange());
        if (dateTimeEntry.isNavigator()) {
            json.entry("changeMonth", true).entry("changeYear", true);
        }
        if (dateTimeEntry.getEffect() != null) {
            json.entry("showAnim", dateTimeEntry.getEffect()).entry("duration", dateTimeEntry.getEffectDuration());
        }
        if (!showOn.equalsIgnoreCase("focus")) {
            String iconSrc = dateTimeEntry.getPopupIcon() != null ? this.getResourceURL(context, dateTimeEntry.getPopupIcon()) : this.getResourceRequestPath(context, DateTimeEntry.POPUP_ICON);
            json.entry("showOn", showOn).entry("buttonImage", iconSrc).entry("buttonImageOnly", dateTimeEntry.isPopupIconOnly());
        }
        if (dateTimeEntry.isShowOtherMonths()) {
            json.entry("showOtherMonths", true).entry("selectOtherMonths", dateTimeEntry.isSelectOtherMonths());
        }
        if (dateTimeEntry.hasTime()) {
            json.entry("timeOnly", timeOnly).entry("stepHour", dateTimeEntry.getStepHour()).entry("stepMinute", dateTimeEntry.getStepMinute()).entry("stepSecond", dateTimeEntry.getStepSecond()).entry("hourMin", dateTimeEntry.getMinHour()).entry("hourMax", dateTimeEntry.getMaxHour()).entry("minuteMin", dateTimeEntry.getMinMinute()).entry("minuteMax", dateTimeEntry.getMaxMinute()).entry("secondMin", dateTimeEntry.getMinSecond()).entry("secondMax", dateTimeEntry.getMaxSecond());
        }
        this.encodeClientBehaviors(context, dateTimeEntry, json);
        if (!this.themeForms()) {
            json.entry("theme", false);
        }
        json.entry("disableHoverStyling", dateTimeEntry.isDisableHoverStyling());
        json.entry("showCurrentAtPos", 0 - dateTimeEntry.getLeftMonthOffset());
        json.entry("clientId", clientId);
        json.entryNonNullValue("inFieldLabel", (String)labelAttributes.get("inFieldLabel"));
        json.entry("inFieldLabelStyleClass", "ui-input-label-infield");
        json.entry("labelIsInField", (Boolean)labelAttributes.get("labelIsInField"));
        json.endMap();
        json.endFunction();
        script.append(json.toString()).append("});");
        writer.write(script.toString());
        writer.endElement("script");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String submittedValue = (String)value;
        Converter converter = dateTimeEntry.getConverter();
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)dateTimeEntry, submittedValue);
        }
        try {
            Locale locale = dateTimeEntry.calculateLocale(context);
            SimpleDateFormat format = new SimpleDateFormat(dateTimeEntry.getPattern(), locale);
            format.setTimeZone(dateTimeEntry.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public static void printParams() {
        Map paramValuesMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterValuesMap();
        for (Map.Entry entry : paramValuesMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            System.out.print(key);
            System.out.print(" = ");
            for (String value : values) {
                System.out.print(value);
                System.out.print(", ");
            }
            System.out.println();
        }
    }
}

