/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.icefaces.ace.component.fileentry.FileEntryBase;
import org.icefaces.ace.component.fileentry.FileEntryConfig;
import org.icefaces.ace.component.fileentry.FileEntryEvent;
import org.icefaces.ace.component.fileentry.FileEntryResults;
import org.icefaces.ace.component.fileentry.FileEntryStatus;
import org.icefaces.ace.component.fileentry.FileEntryStatuses;
import org.icefaces.ace.component.fileentry.PushUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.util.JavaScriptRunner;

public class FileEntry
extends FileEntryBase {
    private static final String RESULTS_KEY = "org.icefaces.ace.component.fileEntry.results";
    private static final String EVENT_KEY = "org.icefaces.ace.component.fileEntry.events";

    @Override
    public void setResults(FileEntryResults results) {
        try {
            super.setResults(results);
        }
        catch (RuntimeException e) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext.isProjectStage(ProjectStage.Development) || facesContext.isProjectStage(ProjectStage.UnitTest)) {
                System.out.println("Problem setting results property on FileEntry component: " + e);
                e.printStackTrace();
            }
            throw e;
        }
    }

    public void reset() {
        this.setResults(null);
    }

    static String getGloballyUniqueComponentIdentifier(FacesContext facesContext, String clientId) {
        String viewId = BridgeSetup.getViewID((ExternalContext)facesContext.getExternalContext());
        String id = clientId + "::" + viewId;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntryConfig storeConfigForNextLifecycle(FacesContext facesContext, String clientId) {
        String resPath = null;
        String groupName = null;
        if (PushUtils.isPushPresent()) {
            UIForm form = Utils.findParentForm((UIComponent)this);
            resPath = PushUtils.getProgressResourcePath(facesContext, (UIComponent)form);
            groupName = PushUtils.getPushGroupName(facesContext, (UIComponent)form);
        }
        String identifier = FileEntry.getGloballyUniqueComponentIdentifier(facesContext, clientId);
        ValueExpression callbackExpression = this.getValueExpression("callback");
        String callbackEL = callbackExpression == null ? null : callbackExpression.getExpressionString();
        FileEntryConfig config = new FileEntryConfig(identifier, clientId, this.getAbsolutePath(), this.getRelativePath(), this.isUseSessionSubdir(), this.isUseOriginalFilename(), callbackEL, this.getMaxTotalSize(), this.getMaxFileSize(), this.getMaxFileCount(), this.isRequired(), resPath, groupName);
        Object sessionObj = facesContext.getExternalContext().getSession(false);
        if (sessionObj != null) {
            Object object = sessionObj;
            synchronized (object) {
                Map map = facesContext.getExternalContext().getSessionMap();
                map.put(identifier, config);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileEntryConfig retrieveConfigFromPreviousLifecycle(FacesContext facesContext, String identifier) {
        FileEntryConfig config = null;
        Object sessionObj = facesContext.getExternalContext().getSession(false);
        if (sessionObj != null) {
            Object object = sessionObj;
            synchronized (object) {
                Map map = facesContext.getExternalContext().getSessionMap();
                config = (FileEntryConfig)map.get(identifier);
            }
        }
        return config;
    }

    static void storeResultsForLaterInLifecycle(FacesContext facesContext, Map<String, FileEntryResults> clientId2Results) {
        facesContext.getAttributes().put(RESULTS_KEY, clientId2Results);
    }

    static FileEntryResults retrieveResultsFromEarlierInLifecycle(FacesContext facesContext, String clientId) {
        FileEntryResults results = null;
        Map clientId2Result = (Map)facesContext.getAttributes().get(RESULTS_KEY);
        if (clientId2Result != null) {
            results = (FileEntryResults)clientId2Result.get(clientId);
        }
        return results;
    }

    static void removeResults(FacesContext facesContext) {
        facesContext.getAttributes().remove(RESULTS_KEY);
    }

    protected void validateResults(FacesContext facesContext) {
        FileEntryResults results = FileEntry.retrieveResultsFromEarlierInLifecycle(facesContext, this.getClientId(facesContext));
        boolean failed = false;
        if (results != null) {
            for (FileEntryResults.FileInfo fi : results.getFiles()) {
                if (fi.isSaved()) continue;
                failed = true;
                break;
            }
        } else {
            String partialSubmitValue = (String)facesContext.getExternalContext().getRequestParameterMap().get("ice.submit.partial");
            boolean partialSubmit = "true".equals(partialSubmitValue);
            if (!partialSubmit && this.isRequired()) {
                this.addMessageFromRequired(facesContext);
                failed = true;
            }
        }
        if (failed) {
            facesContext.validationFailed();
            facesContext.renderResponse();
        }
    }

    protected void addMessagesFromResults(FacesContext facesContext) {
        String clientId = this.getClientId(facesContext);
        FileEntryResults results = this.getResults();
        if (results != null) {
            ArrayList<FileEntryResults.FileInfo> files = results.getFiles();
            for (FileEntryResults.FileInfo fi : files) {
                FileEntryStatus status = fi.getStatus();
                FacesMessage fm = status.getFacesMessage(facesContext, (UIComponent)this, fi);
                facesContext.addMessage(clientId, fm);
            }
        }
    }

    protected void addMessageFromRequired(FacesContext facesContext) {
        String clientId = this.getClientId(facesContext);
        FacesMessage fm = FileEntryStatuses.REQUIRED.getFacesMessage(facesContext, (UIComponent)this, null);
        facesContext.addMessage(clientId, fm);
    }

    public String getFacesMessageLabel() {
        String label = this.getLabel();
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getClientId();
    }

    @Override
    public boolean isImmediateValidation() {
        return this.isImmediate() ? true : super.isImmediateValidation();
    }

    public void processDecodes(FacesContext facesContext) {
        super.processDecodes(facesContext);
        if (this.isImmediateValidation()) {
            this.validateResults(facesContext);
        }
    }

    public void processValidators(FacesContext facesContext) {
        super.processValidators(facesContext);
        if (!this.isImmediateValidation()) {
            this.validateResults(facesContext);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (this.isImmediate()) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            super.queueEvent(event);
        } else {
            event.setPhaseId(PhaseId.RENDER_RESPONSE);
            this.storeEventForPreRender(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) {
        if (event instanceof FileEntryEvent) {
            FileEntryEvent fee = (FileEntryEvent)event;
            FacesContext context = FacesContext.getCurrentInstance();
            try {
                if (!fee.isInvoke()) return;
                MethodExpression listener = this.getFileEntryListener();
                if (listener != null) {
                    ELContext elContext = context.getELContext();
                    try {
                        Object result = listener.invoke(elContext, new Object[]{event});
                        if (result != null) {
                            String outcome = result.toString();
                            context.getApplication().getNavigationHandler().handleNavigation(context, null != listener ? listener.getExpressionString() : null, outcome);
                            context.renderResponse();
                            return;
                        }
                    }
                    catch (ELException ee) {
                        throw new AbortProcessingException(ee.getMessage(), ee.getCause());
                    }
                }
                if (!this.getResults().isLifecycleAndUploadsSuccessful(context)) return;
                String script = "ice.ace.fileentry.clearFileSelection(\"" + JSONBuilder.escapeString(this.getClientId(context)) + "\")";
                JavaScriptRunner.runScript((FacesContext)context, (String)script);
                return;
            }
            finally {
                this.addMessagesFromResults(context);
            }
        }
        super.broadcast(event);
    }

    private void storeEventForPreRender(FacesEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HashMap<String, FacesEvent> clientId2FacesEvent = (HashMap<String, FacesEvent>)facesContext.getAttributes().get(EVENT_KEY);
        if (clientId2FacesEvent == null) {
            clientId2FacesEvent = new HashMap<String, FacesEvent>(6);
            facesContext.getAttributes().put(EVENT_KEY, clientId2FacesEvent);
        }
        clientId2FacesEvent.put(this.getClientId(facesContext), event);
    }

    static Map<String, FacesEvent> removeEventsForPreRender(FacesContext facesContext) {
        Map clientId2FacesEvent = (Map)facesContext.getAttributes().remove(EVENT_KEY);
        return clientId2FacesEvent;
    }
}

