/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.fileentry.FileEntryResults;
import org.icefaces.ace.component.fileentry.FileEntryStatus;
import org.icefaces.ace.util.MessageUtils;

public enum FileEntryStatuses implements FileEntryStatus
{
    UPLOADING(false),
    SUCCESS(true),
    INVALID(false),
    MAX_TOTAL_SIZE_EXCEEDED(false){

        @Override
        public FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
            String pattern = (String)fileEntry.getAttributes().get("maxTotalSizeMessage");
            return pattern != null && pattern.length() > 0 ? this.getFacesMessage(facesContext, fileEntry, fi, pattern) : super.getFacesMessage(facesContext, fileEntry, fi);
        }
    }
    ,
    MAX_FILE_SIZE_EXCEEDED(false){

        @Override
        public FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
            String pattern = (String)fileEntry.getAttributes().get("maxFileSizeMessage");
            return pattern != null && pattern.length() > 0 ? this.getFacesMessage(facesContext, fileEntry, fi, pattern) : super.getFacesMessage(facesContext, fileEntry, fi);
        }
    }
    ,
    MAX_FILE_COUNT_EXCEEDED(false){

        @Override
        public FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
            String pattern = (String)fileEntry.getAttributes().get("maxFileCountMessage");
            return pattern != null && pattern.length() > 0 ? this.getFacesMessage(facesContext, fileEntry, fi, pattern) : super.getFacesMessage(facesContext, fileEntry, fi);
        }
    }
    ,
    REQUIRED(false){

        @Override
        public FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
            FacesMessage.Severity sev = this.getSeverity();
            Object[] params = this.getParametersForRequired(facesContext, fileEntry);
            String pattern = (String)fileEntry.getAttributes().get("requiredMessage");
            if (pattern != null && pattern.length() > 0) {
                Locale locale = facesContext.getViewRoot().getLocale();
                return MessageUtils.getMessage(locale, sev, pattern, pattern, params);
            }
            String messageId = FileEntryStatuses.MESSAGE_KEY_PREFIX + this.name();
            return MessageUtils.getMessage(facesContext, sev, messageId, params);
        }
    }
    ,
    UNKNOWN_SIZE(false),
    UNSPECIFIED_NAME(false),
    INVALID_CONTENT_TYPE(false),
    PROBLEM_WITH_CALLBACK(false),
    PROBLEM_READING_MULTIPART(false){

        @Override
        public FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
            FacesMessage.Severity sev = this.getSeverity();
            String messageId = FileEntryStatuses.MESSAGE_KEY_PREFIX + this.name();
            return MessageUtils.getMessage(facesContext, sev, messageId, null);
        }
    };

    private static final String MESSAGE_KEY_PREFIX = "org.icefaces.ace.component.fileEntry.";
    private boolean success;

    private FileEntryStatuses(boolean success) {
        this.success = success;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
        FacesMessage.Severity sev = this.getSeverity();
        String messageId = MESSAGE_KEY_PREFIX + this.name();
        Object[] params = this.getParameters(facesContext, fileEntry, fi);
        FacesMessage fm = MessageUtils.getMessage(facesContext, sev, messageId, params);
        return fm;
    }

    protected FacesMessage.Severity getSeverity() {
        FacesMessage.Severity sev = this.isSuccess() ? FacesMessage.SEVERITY_INFO : FacesMessage.SEVERITY_ERROR;
        return sev;
    }

    protected Object[] getParameters(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi) {
        Object[] params = new Object[]{fileEntry.getAttributes().get("facesMessageLabel"), fi.getFileName(), fi.getContentType(), fi.getFile(), fi.getSize(), fileEntry.getAttributes().get("maxTotalSize"), fileEntry.getAttributes().get("maxFileSize"), fileEntry.getAttributes().get("maxFileCount")};
        return params;
    }

    protected Object[] getParametersForRequired(FacesContext facesContext, UIComponent fileEntry) {
        Object[] params = new Object[]{fileEntry.getAttributes().get("facesMessageLabel")};
        return params;
    }

    protected FacesMessage getFacesMessage(FacesContext facesContext, UIComponent fileEntry, FileEntryResults.FileInfo fi, String pattern) {
        Locale locale = facesContext.getViewRoot().getLocale();
        FacesMessage.Severity sev = this.getSeverity();
        Object[] params = this.getParameters(facesContext, fileEntry, fi);
        return MessageUtils.getMessage(locale, sev, pattern, pattern, params);
    }
}

