/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.list;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.icefaces.ace.component.list.ACEList;
import org.icefaces.ace.component.list.ListDecoder;
import org.icefaces.ace.json.JSONException;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="list", value="org.icefaces.ace.component.list.ACEList")
public class ListRenderer
extends CoreRenderer {
    public static final String containerStyleClass = "if-list ui-widget ui-widget-content ui-corner-all";
    public static final String controlsContainerStyleClass = "if-list-ctrls";
    public static final String pointerStyleClass = "if-pntr";
    public static final String bodyStyleClass = "if-list-body";
    public static final String itemStyleClass = "if-list-item ui-state-default";
    public static final String selectedItemStyleClass = "ui-state-active";
    public static final String controlsItemStyleClass = "if-list-ctrl";
    public static final String controlsItemSpacerClass = "if-list-ctrl-spcr";
    public static final String headerStyleClass = "if-list-head ui-widget-header";
    public static final String footerStyleClass = "if-list-foot ui-widget-content";
    public static final String placeholderStyleClass = "if-list-plhld if-list-item ui-state-default";

    public void decode(FacesContext context, UIComponent component) {
        ACEList list = (ACEList)component;
        String id = list.getClientId(context);
        String select = id + "_selections";
        String deselect = id + "_deselections";
        String reordering = id + "_reorderings";
        String immigration = id + "_immigration";
        String emigration = id + "_emigration";
        Map params = context.getExternalContext().getRequestParameterMap();
        String selectInput = (String)params.get(select);
        String deselectInput = (String)params.get(deselect);
        String reorderingInput = (String)params.get(reordering);
        String immigrationInput = (String)params.get(immigration);
        String emigrationInput = (String)params.get(emigration);
        ListDecoder decoder = new ListDecoder(list);
        try {
            decoder.processSelections(selectInput).processDeselections(deselectInput).attachEmigrants(context, emigrationInput).processReorderings(reorderingInput).fetchImmigrants(context, immigrationInput).insertImmigrants().removeEmigrants(context, emigrationInput);
        }
        catch (JSONException e) {
            throw new FacesException((Throwable)e);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ACEList list = (ACEList)component;
        String clientId = component.getClientId(context);
        String styleClass = list.getStyleClass();
        String style = list.getStyle();
        styleClass = styleClass == null ? containerStyleClass : styleClass + " " + containerStyleClass;
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (list.getFacet("header") != null) {
            this.encodeHeader(context, writer, list);
        }
        if (list.isControlsEnabled().booleanValue()) {
            this.encodeControls(context, writer, list);
        }
    }

    private void encodeControls(FacesContext context, ResponseWriter writer, ACEList component) throws IOException {
        String styleClass = component.getControlsContainerClass();
        styleClass = styleClass == null ? controlsContainerStyleClass : styleClass + " " + controlsContainerStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "controlsContainerClass");
        for (String buttonCode : component.getControlsFormat().split(" ")) {
            this.encodeControl(context, writer, component, buttonCode);
        }
        writer.endElement("div");
    }

    private void encodeControl(FacesContext context, ResponseWriter writer, ACEList component, String buttonCode) throws IOException {
        UIComponent facet;
        String property;
        String iconStyleClass;
        String itemStyleClass = "if-list-ctrl-" + buttonCode + " " + component.getControlsItemClass();
        String string = itemStyleClass = itemStyleClass != null ? itemStyleClass + " " + controlsItemStyleClass : controlsItemStyleClass;
        if (buttonCode.equals("top")) {
            iconStyleClass = component.getTopButtonClass();
            property = "topButtonClass";
            facet = component.getFacet("topButton");
        } else if (buttonCode.equals("up")) {
            iconStyleClass = component.getUpButtonClass();
            property = "upButtonClass";
            facet = component.getFacet("upButton");
        } else if (buttonCode.equals("dwn")) {
            iconStyleClass = component.getDownButtonClass();
            property = "downButtonClass";
            facet = component.getFacet("downButton");
        } else if (buttonCode.equals("btm")) {
            iconStyleClass = component.getBottomButtonClass();
            property = "bottomButtonClass";
            facet = component.getFacet("bottomButton");
        } else {
            return;
        }
        if (facet != null) {
            facet.encodeAll(context);
        } else {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)controlsItemSpacerClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)itemStyleClass, "controlsItemClass");
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconStyleClass, property);
            writer.endElement("span");
            writer.endElement("span");
            writer.endElement("span");
        }
    }

    private void encodeHeader(FacesContext context, ResponseWriter writer, ACEList component) throws IOException {
        UIComponent facet;
        String styleClass = component.getHeaderClass();
        styleClass = styleClass == null ? headerStyleClass : styleClass + " " + headerStyleClass;
        String style = component.getHeaderStyle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "headerClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "headerStyle");
        }
        if ((facet = component.getFacet("header")) != null) {
            facet.encodeAll(context);
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ACEList list = (ACEList)component;
        String dropGroup = list.getDropGroup();
        String style = list.getBodyStyle();
        String bodyHeight = list.getHeight();
        String styleClass = list.getBodyClass();
        String string = styleClass = styleClass == null ? bodyStyleClass : styleClass + " " + bodyStyleClass;
        if (dropGroup != null) {
            styleClass = styleClass + " dg-" + dropGroup;
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)styleClass, "bodyClass");
        if (bodyHeight != null) {
            bodyHeight = " height:" + bodyHeight + ";";
            String string2 = style = style == null ? bodyHeight : style + "; " + bodyHeight;
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "bodyStyle");
        }
        this.encodeChildren(context, writer, list);
        writer.endElement("ul");
    }

    private void encodeChildren(FacesContext context, ResponseWriter writer, ACEList list) throws IOException {
        Set<Object> selections = list.getSelections();
        String style = list.getItemStyle();
        String styleClass = list.getItemClass();
        String selectionMode = list.getSelectionMode();
        styleClass = styleClass == null ? itemStyleClass : styleClass + " " + itemStyleClass;
        styleClass = "single".equals(selectionMode) || "multiple".equals(selectionMode) || list.isDragging() != false ? styleClass + " " + pointerStyleClass : styleClass;
        list.setRowIndex(0);
        boolean selectItems = false;
        if (list.isRowAvailable()) {
            selectItems = list.getRowData() instanceof SelectItem;
        }
        while (list.isRowAvailable()) {
            Object obj = list.getRowData();
            Boolean selected = selections.contains(obj);
            if (selectItems) {
                this.encodeStringChild(context, writer, list, (SelectItem)obj, selected != false ? styleClass + " " + selectedItemStyleClass : styleClass, style);
            } else {
                this.encodeCompositeChild(context, writer, list, selected != false ? styleClass + " " + selectedItemStyleClass : styleClass, style);
            }
            list.setRowIndex(list.getRowIndex() + 1);
        }
        list.setRowIndex(-1);
    }

    private void encodeStringChild(FacesContext context, ResponseWriter writer, ACEList list, SelectItem item, String styleClass, String style) throws IOException {
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)list.getContainerClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, "itemClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "itemStyle");
        }
        writer.write(item.getLabel());
        writer.endElement("li");
    }

    private void encodeCompositeChild(FacesContext context, ResponseWriter writer, ACEList list, String styleClass, String style) throws IOException {
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)list.getContainerClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, "itemClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "itemStyle");
        }
        for (UIComponent component : list.getChildren()) {
            component.encodeAll(context);
        }
        writer.endElement("li");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ACEList list = (ACEList)component;
        if (component.getFacet("header") != null) {
            this.encodeFooter(context, writer, list);
        }
        this.encodeHiddenFields(context, writer, list);
        this.encodeScript(context, writer, list);
        writer.endElement("div");
    }

    private void encodeHiddenFields(FacesContext context, ResponseWriter writer, ACEList list) throws IOException {
        String id = list.getClientId(context);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(id + "_selections"), null);
        writer.writeAttribute("name", (Object)(id + "_selections"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(id + "_deselections"), null);
        writer.writeAttribute("name", (Object)(id + "_deselections"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(id + "_reorderings"), null);
        writer.writeAttribute("name", (Object)(id + "_reorderings"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
    }

    private void encodeScript(FacesContext context, ResponseWriter writer, ACEList component) throws IOException {
        String widgetVar = ListRenderer.resolveWidgetVar((UIComponent)component);
        String clientId = component.getClientId(context);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String styleClass = component.getPlaceholderClass();
        styleClass = styleClass == null ? placeholderStyleClass : styleClass + " " + placeholderStyleClass;
        String dropGroup = component.getDropGroup();
        JSONBuilder cfgBuilder = new JSONBuilder();
        String selectionMode = component.getSelectionMode();
        cfgBuilder.beginMap();
        cfgBuilder.entry("separator", UINamingContainer.getSeparatorChar((FacesContext)context));
        if (component.isPlaceholder().booleanValue()) {
            cfgBuilder.entry("placeholder", styleClass);
        }
        if (dropGroup != null) {
            cfgBuilder.entry("connectWith", ".dg-" + dropGroup);
        }
        if ("single".equals(selectionMode) || "multiple".equals(selectionMode)) {
            cfgBuilder.entry("selection", selectionMode);
        }
        if (component.isDragging().booleanValue()) {
            cfgBuilder.entry("dragging", true);
        }
        if (component.isControlsEnabled().booleanValue()) {
            cfgBuilder.entry("controls", true);
        }
        if (component.isDoubleClickMigration().booleanValue()) {
            cfgBuilder.entry("dblclk_migrate", true);
        }
        this.encodeClientBehaviors(context, component, cfgBuilder);
        cfgBuilder.endMap();
        writer.write("var " + widgetVar + " = new ice.ace.List('" + clientId + "', " + cfgBuilder + ");");
        writer.endElement("script");
        writer.endElement("span");
    }

    private void encodeFooter(FacesContext context, ResponseWriter writer, ACEList component) throws IOException {
        UIComponent facet;
        String styleClass = component.getFooterClass();
        styleClass = styleClass == null ? footerStyleClass : styleClass + " " + footerStyleClass;
        String style = component.getFooterStyle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "footerClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "footerStyle");
        }
        if ((facet = component.getFacet("footer")) != null) {
            facet.encodeAll(context);
        }
        writer.endElement("div");
    }
}

