/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menubutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.menu.AbstractMenu;
import org.icefaces.ace.component.menu.BaseMenuRenderer;
import org.icefaces.ace.component.menubutton.MenuButton;
import org.icefaces.ace.component.menuitem.MenuItem;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="menuButton", value="org.icefaces.ace.component.menubutton.MenuButton")
public class MenuButtonRenderer
extends BaseMenuRenderer {
    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.shouldBuildFromModel()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        String style;
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        String buttonId = clientId + "_button";
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = button.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        if ((style = button.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        if (button.getValue() != null) {
            writer.write(button.getValue());
        }
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function(){var b = ice.ace.jq(ice.ace.escapeClientId('" + buttonId + "')); if (!b.hasClass('ui-button')) { " + this.getInitCall(writer, button, clientId) + " }});");
        writer.endElement("script");
        writer.endElement("button");
        writer.startElement("ul", null);
        for (UIComponent child : button.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", child);
            if (child instanceof MenuItem) {
                this.encodeMenuItem(context, (MenuItem)child);
            }
            writer.endElement("li");
        }
        writer.endElement("ul");
        this.encodeScript(context, button);
        writer.endElement("span");
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        String formClientId = form.getClientId(context);
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(this.getInitCall(writer, button, clientId));
        writer.endElement("script");
    }

    private String getInitCall(ResponseWriter writer, MenuButton button, String clientId) throws IOException {
        JSONBuilder json = JSONBuilder.create();
        writer.write(MenuButtonRenderer.resolveWidgetVar((UIComponent)button) + " = new ");
        json.beginFunction("ice.ace.MenuButton").item(clientId).beginMap().beginMap("animation").entry("animated", button.getEffect()).entry("duration", button.getEffectDuration()).endMap().entry("zindex", button.getZindex());
        if (button.isDisabled()) {
            json.entry("disabled", true);
        }
        json.endMap().endFunction();
        return json.toString();
    }
}

