/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.panel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.menu.Menu;
import org.icefaces.ace.component.panel.Panel;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="panel", value="org.icefaces.ace.component.panel.Panel")
public class PanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String visibleParam;
        Panel panel = (Panel)component;
        String clientId = panel.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String collapsedParam = (String)params.get(clientId + "_collapsed");
        if (collapsedParam != null) {
            panel.setCollapsed(Boolean.valueOf(collapsedParam));
        }
        if ((visibleParam = (String)params.get(clientId + "_visible")) != null) {
            panel.setVisible(Boolean.valueOf(visibleParam));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Panel panel = (Panel)component;
        this.encodeMarkup(facesContext, panel);
    }

    protected void encodeScript(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(PanelRenderer.resolveWidgetVar((UIComponent)panel) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.Panel").item(clientId).beginMap().entry("visible", panel.isVisible());
        if (panel.isToggleable()) {
            jb.entry("toggleable", true);
            jb.entry("toggleSpeed", panel.getToggleSpeed());
            jb.entry("collapsed", panel.isCollapsed());
        }
        if (panel.isClosable()) {
            jb.entry("closable", true);
            jb.entry("closeSpeed", panel.getCloseSpeed());
        }
        if (panel.getOptionsMenu() != null) {
            jb.entry("hasMenu", true);
        }
        this.encodeClientBehaviors(context, panel, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        Menu optionsMenu = panel.getOptionsMenu();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String styleClass = panel.getStyleClass();
        Utils.writeConcatenatedStyleClasses(writer, "ui-panel ui-widget ui-widget-content ui-corner-all", styleClass);
        String style = panel.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, panel);
        this.encodeContent(context, panel);
        this.encodeFooter(context, panel);
        if (panel.isToggleable()) {
            this.encodeStateHolder(context, panel, clientId + "_collapsed", String.valueOf(panel.isCollapsed()));
        }
        if (panel.isClosable()) {
            this.encodeStateHolder(context, panel, clientId + "_visible", String.valueOf(panel.isVisible()));
        }
        if (optionsMenu != null) {
            optionsMenu.setPosition("dynamic");
            optionsMenu.setTrigger(clientId + "_menu");
            optionsMenu.setMy("left top");
            optionsMenu.setAt("left bottom");
            optionsMenu.encodeAll(context);
        }
        this.encodeScript(context, panel);
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String widgetVar = PanelRenderer.resolveWidgetVar((UIComponent)panel);
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        String clientId = panel.getClientId(context);
        if (headerText == null && header == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_header"), null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar ui-widget-header ui-corner-all", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-panel-title", null);
        if (header != null) {
            this.renderChild(context, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (panel.isClosable()) {
            this.encodeIcon(context, panel, "ui-icon-closethick", clientId + "_closer");
        }
        if (panel.isToggleable()) {
            String icon = panel.isCollapsed() ? "ui-icon-plusthick" : "ui-icon-minusthick";
            this.encodeIcon(context, panel, icon, clientId + "_toggler");
        }
        if (panel.getOptionsMenu() != null) {
            this.encodeIcon(context, panel, "ui-icon-gear", clientId + "_menu");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId() + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-panel-content ui-widget-content", null);
        if (panel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(facesContext, (UIComponent)panel);
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent footer = panel.getFacet("footer");
        String footerText = panel.getFooter();
        if (footer != null || footerText != null) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_footer"), null);
            writer.writeAttribute("class", (Object)"ui-panel-footer ui-widget-content", null);
            if (footer != null) {
                this.renderChild(facesContext, footer);
            } else if (footerText != null) {
                writer.write(footerText);
            }
            writer.endElement("div");
        }
    }

    protected void encodeIcon(FacesContext context, Panel panel, String iconClass, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar-icon ui-corner-all ui-state-default", null);
        writer.startElement("span", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeStateHolder(FacesContext context, Panel panel, String name, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

