/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.resizable;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.resizable.Resizable;
import org.icefaces.ace.event.ResizeEvent;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="resizable", value="org.icefaces.ace.component.resizable.Resizable")
public class ResizableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Resizable resizable;
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey((clientId = (resizable = (Resizable)component).getClientId(context)) + "_ajaxResize")) {
            int width = new Double((String)params.get(clientId + "_width")).intValue();
            int height = new Double((String)params.get(clientId + "_height")).intValue();
            resizable.queueEvent(new ResizeEvent((UIComponent)resizable, width, height));
        }
        this.decodeBehaviors(context, (UIComponent)resizable);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        int grid;
        String handles;
        int maxHeight;
        int minHeight;
        int maxWidth;
        ResponseWriter writer = context.getResponseWriter();
        Resizable resizable = (Resizable)component;
        String clientId = resizable.getClientId(context);
        UIComponent target = this.findTarget(context, resizable);
        String targetId = target.getClientId(context);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("script", (UIComponent)resizable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (target instanceof UIGraphic) {
            writer.write("ice.ace.jq(ice.ace.escapeClientId('" + targetId + "')).load(function(){");
        } else {
            writer.write("ice.ace.jq(function(){");
        }
        writer.write(ResizableRenderer.resolveWidgetVar((UIComponent)resizable) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.Resizable").item(clientId).beginMap().entry("target", targetId);
        int minWidth = resizable.getMinWidth();
        if (minWidth != Integer.MIN_VALUE) {
            jb.entry("minWidth", minWidth);
        }
        if ((maxWidth = resizable.getMaxWidth()) != Integer.MAX_VALUE) {
            jb.entry("maxWidth", maxWidth);
        }
        if ((minHeight = resizable.getMinHeight()) != Integer.MIN_VALUE) {
            jb.entry("minHeight", minHeight);
        }
        if ((maxHeight = resizable.getMaxHeight()) != Integer.MAX_VALUE) {
            jb.entry("maxHeight", maxHeight);
        }
        if (resizable.isAnimate()) {
            jb.entry("animate", true);
            jb.entry("animateEasing", resizable.getEffect());
            jb.entry("animateDuration", resizable.getEffectDuration());
        }
        if (resizable.isProxy()) {
            jb.entry("helper", "ui-resizable-proxy");
        }
        if ((handles = resizable.getHandles()) != null) {
            jb.entry("handles", handles);
        }
        if ((grid = resizable.getGrid()) != 1) {
            jb.entry("grid", grid);
        }
        if (resizable.isAspectRatio()) {
            jb.entry("aspectRatio", true);
        }
        if (resizable.isGhost()) {
            jb.entry("ghost", true);
        }
        if (resizable.isContainment()) {
            jb.entry("containment", "ice.ace.escapeClientId('" + resizable.getParent().getClientId(context) + "')", true);
        }
        if (resizable.getResizeListener() != null) {
            jb.entry("ajaxResize", true);
        }
        this.encodeClientBehaviors(context, resizable, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.write("});");
        writer.endElement("script");
        writer.endElement("span");
    }

    protected UIComponent findTarget(FacesContext context, Resizable resizable) {
        String _for = resizable.getFor();
        if (_for != null) {
            UIComponent component = resizable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return resizable.getParent();
    }
}

