/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.sliderentry;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.ace.component.sliderentry.SliderEntry;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="sliderEntry", value="org.icefaces.ace.component.sliderentry.SliderEntry")
public class SliderEntryRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        SliderEntry slider = (SliderEntry)component;
        String clientId = slider.getClientId(context);
        boolean foundInMap = false;
        if (requestParameterMap.containsKey(clientId + "_hidden")) {
            foundInMap = true;
        }
        if (requestParameterMap.containsKey("ice.event.captured") || foundInMap) {
            String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
            if ("ice.ser".equals(requestParameterMap.get("ice.submit.type"))) {
                context.renderResponse();
                return;
            }
            Object hiddenValue = requestParameterMap.get(clientId + "_hidden");
            if (hiddenValue == null) {
                return;
            }
            int submittedValue = 0;
            try {
                submittedValue = Float.valueOf(hiddenValue.toString()).intValue();
            }
            catch (NumberFormatException nfe) {
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            if (clientId.equals(source) || foundInMap) {
                try {
                    int value = slider.getValue();
                    if (value != submittedValue) {
                        component.queueEvent((FacesEvent)new ValueChangeEvent(component, (Object)new Integer(value), (Object)new Integer(submittedValue)));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        this.decodeBehaviors(context, (UIComponent)slider);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        SliderEntry slider = (SliderEntry)component;
        this.encodeMarkup(facesContext, slider);
    }

    protected void encodeMarkup(FacesContext context, SliderEntry slider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = slider.getClientId(context);
        writer.startElement("input", (UIComponent)slider);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.writeAttribute("type", (Object)"hidden", "type");
        writer.writeAttribute("value", (Object)slider.getValue(), "value");
        writer.endElement("input");
        writer.startElement("div", (UIComponent)slider);
        writer.writeAttribute("id", (Object)clientId, "id");
        String style = slider.getStyle();
        style = style == null ? "" : style;
        String length = slider.getLength();
        if (length.toLowerCase().indexOf("px") == -1) {
            length = length + "px";
        }
        String dimension = "y".equals(slider.getAxis()) ? "height" : "width";
        style = style + ";" + dimension + ":" + length + ";";
        writer.writeAttribute("style", (Object)style, null);
        if (slider.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)slider.getStyleClass(), null);
        }
        this.encodeScript(context, slider);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SliderEntry slider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = slider.getClientId(context);
        writer.startElement("script", (UIComponent)slider);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSONBuilder jb = JSONBuilder.create();
        writer.write(SliderEntryRenderer.resolveWidgetVar((UIComponent)slider) + " = new ");
        jb.beginFunction("ice.ace.Slider").item(clientId).beginMap().entry("value", slider.getValue()).entry("input", clientId + "_hidden");
        int min = slider.getMin();
        jb.entry("min", min);
        int max = slider.getMax();
        jb.entry("max", max);
        jb.entry("animate", slider.isAnimate());
        float stepPercent = slider.getStepPercent();
        float step = (float)(max - min) * stepPercent / 100.0f;
        jb.entry("step", step);
        String orientation = "y".equals(slider.getAxis()) ? "vertical" : "horizontal";
        jb.entry("orientation", orientation);
        String length = slider.getLength();
        if (length.toLowerCase().indexOf("px") == -1) {
            length = length + "px";
        }
        jb.entry("length", length);
        Integer tabindex = slider.getTabindex();
        if (tabindex != null) {
            jb.entry("tabindex", tabindex.toString());
        }
        jb.entry("clickableRail", slider.isClickableRail());
        if (slider.isDisabled()) {
            jb.entry("disabled", true);
        }
        if (slider.getOnSlideStart() != null) {
            jb.entry("onSlideStart", "function(event, ui) {" + slider.getOnSlideStart() + "}", true);
        }
        if (slider.getOnSlide() != null) {
            jb.entry("onSlide", "function(event, ui) {" + slider.getOnSlide() + "}", true);
        }
        if (slider.getOnSlideEnd() != null) {
            jb.entry("onSlideEnd", "function(event, ui) {" + slider.getOnSlideEnd() + "}", true);
        }
        this.encodeClientBehaviors(context, slider, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
    }
}

