/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tabset;

import java.util.EnumSet;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.tabset.TabPaneUtil;

public enum TabPaneCache {
    NONE("none", false, false, null),
    DYNAMIC("dynamic", true, false, null),
    STATIC("static", true, true, null),
    STATIC_AUTO("staticAuto", true, true, null){

        @Override
        public TabPaneCache resolve(FacesContext facesContext, UIComponent tab) {
            if (TabPaneUtil.isAutoDynamic(facesContext, tab)) {
                return DYNAMIC_REVERT_STATIC_AUTO;
            }
            return this;
        }
    }
    ,
    DYNAMIC_REVERT_STATIC_AUTO("dynamicRevertStaticAuto", true, false, STATIC_AUTO);

    public static final String DEFAULT = "none";
    private String named;
    private boolean cached;
    private boolean cachedStatically;
    private TabPaneCache revertTo;

    public static TabPaneCache get(String find) {
        if (find == null || find.trim().length() == 0) {
            find = DEFAULT;
        }
        EnumSet<TabPaneCache> s = EnumSet.allOf(TabPaneCache.class);
        for (TabPaneCache tpc : s) {
            if (!tpc.named.equals(find)) continue;
            return tpc;
        }
        throw new IllegalArgumentException("'" + find + "' is not a valid TabPaneCache");
    }

    private TabPaneCache(String named, boolean cached, boolean cachedStatically, TabPaneCache revertTo) {
        this.named = named;
        this.cached = cached;
        this.cachedStatically = cachedStatically;
        this.revertTo = revertTo;
    }

    public TabPaneCache resolve(FacesContext facesContext, UIComponent tab) {
        return this;
    }

    public String getNamed() {
        return this.named;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isCachedStatically() {
        return this.cachedStatically;
    }

    public TabPaneCache getRevertTo() {
        return this.revertTo;
    }
}

