/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.textareaentry;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.textareaentry.TextAreaEntry;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="textAreaEntry", value="org.icefaces.ace.component.textareaentry.TextAreaEntry")
public class TextAreaEntryRenderer
extends InputRenderer {
    Map<String, Object> domUpdateMap = new HashMap<String, Object>();

    public void decode(FacesContext context, UIComponent component) {
        TextAreaEntry textAreaEntry = (TextAreaEntry)component;
        if (textAreaEntry.isDisabled() || textAreaEntry.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)textAreaEntry);
        String clientId = textAreaEntry.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)requestParameterMap.get(clientId + "_input");
        if (submittedValue == null && requestParameterMap.get(clientId + "_label") != null) {
            submittedValue = "";
        }
        if (submittedValue != null) {
            textAreaEntry.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TextAreaEntry textAreaEntry = (TextAreaEntry)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = textAreaEntry.getClientId(context);
        this.domUpdateMap.clear();
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        Map<String, Object> labelAttributes = this.getLabelAttributes(component);
        writer.startElement("span", (UIComponent)textAreaEntry);
        writer.writeAttribute("id", (Object)(clientId + "_markup"), null);
        writer.writeAttribute("class", (Object)"ui-textareaentry-container", null);
        this.encodeLabelAndInput(component, labelAttributes);
        writer.endElement("span");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(TextAreaEntryRenderer.resolveWidgetVar((UIComponent)textAreaEntry) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.TextAreaEntry").item(clientId).beginMap();
        jb.entryNonNullValue("inFieldLabel", (String)labelAttributes.get("inFieldLabel"));
        jb.entry("inFieldLabelStyleClass", "ui-input-label-infield");
        this.encodeClientBehaviors(context, textAreaEntry, jb);
        if (!this.themeForms()) {
            jb.entry("theme", false);
        }
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
        this.domUpdateMap.putAll(labelAttributes);
        writer.startElement("span", (UIComponent)textAreaEntry);
        writer.writeAttribute("data-hashcode", (Object)((Object)this.domUpdateMap).hashCode(), null);
        writer.writeAttribute("style", (Object)"display: none;", null);
        writer.endElement("span");
        writer.endElement("span");
    }

    @Override
    protected void writeInputField(UIComponent component, Map<String, Object> labelAttributes) throws IOException {
        String style;
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter writer = context.getResponseWriter();
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        TextAreaEntry textAreaEntry = (TextAreaEntry)component;
        String clientId = textAreaEntry.getClientId(context);
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        String iceFocus = (String)paramMap.get("ice.focus");
        String inFieldLabel = (String)labelAttributes.get("inFieldLabel");
        String value = ComponentUtils.getStringValueToRender(context, component);
        String defaultClass = this.themeForms() ? "ui-inputfield ui-textareaentry ui-widget ui-state-default ui-corner-all" : "ui-textareaentry";
        defaultClass = defaultClass + this.getStateStyleClasses((UIInput)textAreaEntry);
        if (this.isValueBlank(value) && !this.isValueBlank(inFieldLabel) && !clientId.equals(iceFocus)) {
            writer.writeAttribute("name", (Object)(clientId + "_label"), null);
            value = inFieldLabel;
            defaultClass = defaultClass + " ui-input-label-infield";
            labelAttributes.put("labelIsInField", true);
        }
        defaultClass = defaultClass + (textAreaEntry.isResizable() ? " ui-textareaentry-resizable" : " ui-textareaentry-non-resizable");
        this.renderPassThruAttributes(context, (UIComponent)textAreaEntry, HTML.INPUT_TEXTAREA_ATTRS);
        if (textAreaEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (textAreaEntry.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if ((style = textAreaEntry.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        String styleClass = textAreaEntry.getStyleClass();
        Utils.writeConcatenatedStyleClasses(writer, defaultClass, styleClass);
        this.domUpdateMap.put("defaultClass", defaultClass);
        this.domUpdateMap.put("styleClass", styleClass);
        this.domUpdateMap.put("value", value);
        if (value != null) {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("textarea");
    }

    public static void printMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            System.out.println(entry.getKey() + " = " + entry.getValue() + ";");
        }
    }
}

