/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import org.icefaces.ace.context.RequestContext;
import org.icefaces.ace.json.JSONObject;

public class CallbackPartialResponseWriter
extends PartialResponseWriter {
    private PartialResponseWriter wrapped;

    public CallbackPartialResponseWriter(PartialResponseWriter writer) {
        super((ResponseWriter)writer);
        this.wrapped = writer;
    }

    public void endDocument() throws IOException {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (requestContext != null) {
            requestContext.addCallbackParam("validationFailed", FacesContext.getCurrentInstance().isValidationFailed());
            Map<String, Object> params = requestContext.getCallbackParams();
            try {
                for (String paramName : params.keySet()) {
                    HashMap<String, String> callbackParamExtension = new HashMap<String, String>();
                    callbackParamExtension.put("aceCallbackParam", paramName);
                    this.startExtension(callbackParamExtension);
                    Object paramValue = params.get(paramName);
                    String json = this.isBean(paramValue) ? "{\"" + paramName + "\":" + new JSONObject(paramValue).toString() + "}" : new JSONObject().put(paramName, paramValue).toString();
                    this.write(json);
                    this.endExtension();
                }
            }
            catch (Exception exception) {
                throw new AbortProcessingException((Throwable)exception);
            }
            finally {
                requestContext.release();
            }
        }
        this.wrapped.endDocument();
    }

    public void delete(String targetId) throws IOException {
        this.wrapped.delete(targetId);
    }

    public void endError() throws IOException {
        this.wrapped.endError();
    }

    public void endEval() throws IOException {
        this.wrapped.endEval();
    }

    public void endExtension() throws IOException {
        this.wrapped.endExtension();
    }

    public void endInsert() throws IOException {
        this.wrapped.endInsert();
    }

    public void endUpdate() throws IOException {
        this.wrapped.endUpdate();
    }

    public void redirect(String url) throws IOException {
        this.wrapped.redirect(url);
    }

    public void startDocument() throws IOException {
        this.wrapped.startDocument();
    }

    public void startError(String errorName) throws IOException {
        this.wrapped.startError(errorName);
    }

    public void startEval() throws IOException {
        this.wrapped.startEval();
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.wrapped.startExtension(attributes);
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.wrapped.startInsertAfter(targetId);
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.wrapped.startInsertBefore(targetId);
    }

    public void startUpdate(String targetId) throws IOException {
        this.wrapped.startUpdate(targetId);
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.wrapped.updateAttributes(targetId, attributes);
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }
}

