/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.model.chart;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.icefaces.ace.component.chart.Axis;
import org.icefaces.ace.component.chart.AxisType;
import org.icefaces.ace.component.chart.Chart;
import org.icefaces.ace.model.SimpleEntry;
import org.icefaces.ace.model.chart.ChartSeries;
import org.icefaces.ace.model.chart.DragConstraintAxis;
import org.icefaces.ace.model.chart.LinePattern;
import org.icefaces.ace.util.JSONBuilder;

public class CartesianSeries
extends ChartSeries {
    Boolean pointLabels;
    Integer pointLabelTolerance;
    Boolean pointLabelStacked;
    String[] pointLabelList;
    Boolean dragable;
    DragConstraintAxis dragConstraintAxis;
    long fillToValue;
    String fillAxis;
    String fillColor;
    int fillAlpha;
    boolean highlightMouseOver;
    boolean highlightMouseDown;
    String[] highlightColors;
    int barMargin;
    int barPadding;
    int barWidth;
    LinePattern linePattern;
    Boolean horizontalBar;
    Boolean smooth;
    boolean varyBarColor;
    boolean waterfall;
    int groups;

    @Override
    public ChartSeries.ChartType getDefaultType() {
        return CartesianType.LINE;
    }

    public void add(Object y) {
        this.getData().add(new SimpleEntry<Object, Object>(null, y));
    }

    public void add(Object x, Object y) {
        this.getData().add(new SimpleEntry<Object, Object>(x, y));
    }

    @Override
    public JSONBuilder getDataJSON(UIComponent component) {
        JSONBuilder data = super.getDataJSON(component);
        Chart chart = (Chart)component;
        Map<String, Integer> xCategoryToIndexMap = null;
        Map<String, Integer> yCategoryToIndexMap = null;
        Class valueType = null;
        Class keyType = null;
        for (Object obj : this.getData()) {
            Map.Entry point = (Map.Entry)obj;
            Object key = point.getKey();
            Object value = point.getValue();
            Object outObj = null;
            if (key != null && keyType == null) {
                if (key instanceof Number) {
                    keyType = Number.class;
                } else if (key instanceof String) {
                    keyType = String.class;
                } else if (key instanceof Date) {
                    keyType = Date.class;
                }
            }
            if (valueType == null) {
                if (value instanceof Number) {
                    valueType = Number.class;
                } else if (value instanceof String) {
                    valueType = String.class;
                } else if (value instanceof Date) {
                    valueType = Date.class;
                }
            }
            if (key != null) {
                data.beginArray();
                if (keyType == Number.class) {
                    data.item(((Number)key).doubleValue());
                } else if (keyType == String.class) {
                    String strKey = key.toString();
                    if (this.areAxisTicksPredefined(chart, 'x')) {
                        if (xCategoryToIndexMap == null) {
                            xCategoryToIndexMap = this.createCategoryToIndexMap(chart, 'x');
                        }
                        data.item((Integer)xCategoryToIndexMap.get(strKey));
                    } else {
                        data.item(strKey);
                    }
                } else if (keyType == Date.class) {
                    data.item(((Date)key).getTime());
                }
            }
            if (valueType == Number.class) {
                data.item(((Number)value).doubleValue());
            } else if (valueType == String.class) {
                String strVal = value.toString();
                if (this.areAxisTicksPredefined(chart, 'y')) {
                    if (yCategoryToIndexMap == null) {
                        yCategoryToIndexMap = this.createCategoryToIndexMap(chart, 'y');
                    }
                    data.item((Integer)yCategoryToIndexMap.get(strVal));
                } else {
                    data.item(strVal);
                }
            } else if (keyType == Date.class) {
                data.item(((Date)key).getTime());
            }
            if (key == null) continue;
            data.endArray();
        }
        data.endArray();
        return data;
    }

    private Map<String, Integer> createCategoryToIndexMap(Chart chart, char axisDir) {
        String[] ticks;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Axis axis = null;
        if (axisDir == 'x') {
            axis = Integer.valueOf(2).equals(this.getXAxis()) ? chart.getX2Axis() : chart.getXAxis();
        } else if (axisDir == 'y') {
            Axis[] yAxes = chart.getYAxes();
            Integer yAxisIndex = this.getYAxis();
            axis = yAxisIndex < 2 ? yAxes[0] : yAxes[yAxisIndex - 1];
        }
        Integer index = 0;
        for (String tick : ticks = axis.getTicks()) {
            index = index + 1;
            map.put(tick, index);
        }
        return map;
    }

    private boolean areAxisTicksPredefined(Chart chart, char axisDir) {
        String[] ticks;
        Axis axis = null;
        if (axisDir == 'x') {
            axis = Integer.valueOf(2).equals(this.getXAxis()) ? chart.getX2Axis() : chart.getXAxis();
        } else if (axisDir == 'y') {
            Axis[] yAxes = chart.getYAxes();
            Integer yAxisIndex = this.getYAxis();
            axis = yAxisIndex < 2 ? yAxes[0] : yAxes[yAxisIndex - 1];
        }
        return axis != null && (ticks = axis.getTicks()) != null && ticks.length > 0;
    }

    @Override
    public JSONBuilder getConfigJSON(UIComponent component) {
        Boolean dragable;
        JSONBuilder cfg = super.getConfigJSON(component);
        Chart chart = (Chart)component;
        LinePattern pattern = this.getLinePattern();
        if (this.type != null) {
            if (this.type.equals(CartesianType.BAR)) {
                cfg.entry("renderer", "ice.ace.jq.jqplot.BarRenderer", true);
            } else if (this.type.equals(CartesianType.LINE)) {
                cfg.entry("renderer", "ice.ace.jq.jqplot.LineRenderer", true);
            }
        }
        if (this.hasPointLabelOptionSet()) {
            this.encodePointLabelOptions(cfg);
        }
        if (this.hasRenderOptionsSet()) {
            cfg.beginMap("rendererOptions");
            Boolean fill = this.getFill();
            Boolean horiz = this.isHorizontalBar();
            Boolean smooth = this.getSmooth();
            if (smooth != null) {
                cfg.entry("smooth", smooth);
            }
            if (fill != null) {
                cfg.entry("fill", fill);
            }
            if (horiz != null) {
                cfg.entry("barDirection", horiz != false ? "horizontal" : "vertical");
            }
            cfg.endMap();
        }
        if (pattern != null) {
            cfg.entry("linePattern", pattern.toString());
        }
        if ((dragable = this.getDragable()) != null && this.isConfiguredForDragging(chart)) {
            cfg.entry("isDragable", dragable);
            if (this.getDragConstraintAxis() != null) {
                cfg.beginMap("dragable");
                cfg.entry("constrainTo", this.getDragConstraintAxis().toString());
                cfg.endMap();
            }
        }
        cfg.endMap();
        return cfg;
    }

    private boolean isConfiguredForDragging(Chart chart) {
        if (!this.explicitXValuesDefined()) {
            throw new FacesException("Points in a dragable series must be added with an explicit x and y value.");
        }
        if (!this.categoryAxesHaveExplicitTicks(chart)) {
            throw new FacesException("Category axes of a dragable series must have explicit ticks to prevent loss of categories during reordering.");
        }
        if (!this.xValuesAreSortedAscending()) {
            throw new FacesException("Dragable points must be added in an ascending order of X value. This is to prevent reindexing during plotting that breaks index association of points in the model on the server and the model internal to the plot on the client.");
        }
        return true;
    }

    private boolean xValuesAreSortedAscending() {
        boolean ret = true;
        Date lastDate = null;
        Number lastNumber = null;
        Class keyType = null;
        for (Object o : this.getData()) {
            Object key;
            SimpleEntry entry = (SimpleEntry)o;
            if (keyType == null) {
                key = entry.getKey();
                if (key instanceof Number) {
                    keyType = Number.class;
                } else if (key instanceof Date) {
                    keyType = Date.class;
                } else {
                    return true;
                }
            }
            if (keyType == Date.class) {
                key = (Date)entry.getKey();
                if (lastDate != null) {
                    ret = ret && 0 < ((Date)key).compareTo(lastDate);
                }
                lastDate = (Date)key;
                continue;
            }
            if (keyType != Number.class) continue;
            key = (Number)entry.getKey();
            if (lastNumber != null) {
                ret = ret && ((Number)key).doubleValue() > lastNumber.doubleValue();
            }
            lastNumber = (Number)key;
        }
        return ret;
    }

    private boolean categoryAxesHaveExplicitTicks(Chart chart) {
        Axis x;
        String[] ticks;
        Axis y;
        boolean ret = true;
        Integer yIndex = this.getYAxis();
        yIndex = yIndex != null && yIndex > 1 ? yIndex - 1 : 0;
        Axis[] ys = chart.getYAxes();
        if (ys != null && (y = ys[yIndex]) != null && y.getType() == AxisType.CATEGORY) {
            ret = ret && (ticks = y.getTicks()) != null && ticks.length > 0;
        }
        Axis axis = x = this.getXAxis() != null && this.getXAxis() == 2 ? chart.getX2Axis() : chart.getXAxis();
        if (x != null && x.getType() == AxisType.CATEGORY) {
            ret = ret && (ticks = x.getTicks()) != null && ticks.length > 0;
        }
        return ret;
    }

    private boolean explicitXValuesDefined() {
        boolean ret = true;
        for (Object o : this.getData()) {
            SimpleEntry entry = (SimpleEntry)o;
            ret = ret && entry.getKey() != null;
        }
        return ret;
    }

    private void encodePointLabelOptions(JSONBuilder cfg) {
        cfg.beginMap("pointLabels");
        if (this.pointLabels != null) {
            cfg.entry("show", this.pointLabels);
        }
        if (this.pointLabelList != null) {
            cfg.beginArray("labels");
            for (String s : this.pointLabelList) {
                cfg.item(s);
            }
            cfg.endArray();
        }
        if (this.pointLabelTolerance != null) {
            cfg.entry("edgeTolerance", this.pointLabelTolerance);
        }
        if (this.pointLabelStacked != null) {
            cfg.entry("stackedValue", this.pointLabelStacked);
        }
        cfg.endMap();
    }

    private boolean hasPointLabelOptionSet() {
        return this.pointLabels != null || this.pointLabelList != null || this.pointLabelTolerance != null || this.pointLabelStacked != null;
    }

    private boolean hasRenderOptionsSet() {
        return this.getFill() != null || this.isHorizontalBar() != null || this.getSmooth() != null;
    }

    public Boolean isHorizontalBar() {
        return this.horizontalBar;
    }

    public void setHorizontalBar(Boolean horizontalBar) {
        this.horizontalBar = horizontalBar;
    }

    public Boolean isPointLabels() {
        return this.pointLabels;
    }

    public void setPointLabels(Boolean pointLabels) {
        this.pointLabels = pointLabels;
    }

    public Integer getPointLabelTolerance() {
        return this.pointLabelTolerance;
    }

    public void setPointLabelTolerance(Integer pointLabelTolerance) {
        this.pointLabelTolerance = pointLabelTolerance;
    }

    public Boolean getPointLabelStacked() {
        return this.pointLabelStacked;
    }

    public void setPointLabelStacked(Boolean pointLabelStacked) {
        this.pointLabelStacked = pointLabelStacked;
    }

    public String[] getPointLabelList() {
        return this.pointLabelList;
    }

    public void setPointLabelList(String[] pointLabelList) {
        this.pointLabelList = pointLabelList;
    }

    public Boolean getDragable() {
        return this.dragable;
    }

    public void setDragable(Boolean dragable) {
        this.dragable = dragable;
    }

    public DragConstraintAxis getDragConstraintAxis() {
        return this.dragConstraintAxis;
    }

    public void setDragConstraintAxis(DragConstraintAxis dragConstraintAxis) {
        this.dragConstraintAxis = dragConstraintAxis;
    }

    public LinePattern getLinePattern() {
        return this.linePattern;
    }

    public void setLinePattern(LinePattern linePattern) {
        this.linePattern = linePattern;
    }

    public Boolean getSmooth() {
        return this.smooth;
    }

    public void setSmooth(Boolean smooth) {
        this.smooth = smooth;
    }

    public static enum CartesianType implements ChartSeries.ChartType
    {
        BAR,
        LINE;

    }
}

