/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.model.chart;

import java.util.Date;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.icefaces.ace.model.SimpleEntry;
import org.icefaces.ace.model.chart.ChartSeries;
import org.icefaces.ace.util.JSONBuilder;

public class OHLCSeries
extends ChartSeries {
    boolean isHLC;
    int tickLength;
    int bodyWidth;
    String openColor;
    String closeColor;
    String wickColor;
    String upBodyColor;
    String downBodyColor;
    boolean fillUpBody;
    boolean fillDownBody;

    public void add(Date x, Number o, Number h, Number l, Number c) {
        this.getData().add(new SimpleEntry<Date, Number[]>(x, new Number[]{o, h, l, c}));
    }

    @Override
    public JSONBuilder getDataJSON(UIComponent chart) {
        JSONBuilder json = super.getDataJSON(chart);
        for (Object o : this.getData()) {
            Map.Entry entry = (Map.Entry)o;
            Date key = (Date)entry.getKey();
            Number[] value = (Number[])entry.getValue();
            json.beginArray();
            json.item(key.getTime());
            for (Number n : value) {
                if (n != null) {
                    json.item(n.doubleValue());
                    continue;
                }
                json.item("undefined", false);
            }
            json.endArray();
        }
        json.endArray();
        return json;
    }

    @Override
    public JSONBuilder getConfigJSON(UIComponent component) {
        JSONBuilder cfg = super.getConfigJSON(component);
        cfg.entry("renderer", "ice.ace.jq.jqplot.OHLCRenderer", true);
        if (this.rendererOptionsSet()) {
            cfg.beginMap("rendererOptions");
            if (OHLCType.CANDLESTICK.equals(this.type)) {
                cfg.entry("candleStick", true);
            }
            cfg.endMap();
        }
        cfg.endMap();
        return cfg;
    }

    private boolean rendererOptionsSet() {
        return OHLCType.CANDLESTICK.equals(this.type);
    }

    @Override
    public ChartSeries.ChartType getDefaultType() {
        return OHLCType.OHLC;
    }

    public static enum OHLCType implements ChartSeries.ChartType
    {
        OHLC,
        CANDLESTICK;

    }
}

