/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.model.chart;

import javax.faces.component.UIComponent;
import org.icefaces.ace.model.SimpleEntry;
import org.icefaces.ace.model.chart.ChartSeries;
import org.icefaces.ace.util.JSONBuilder;

public class SectorSeries
extends ChartSeries {
    Integer diameter;
    Integer padding;
    Integer sliceMargin;
    Boolean shadow;
    Integer shadowAngle;
    Integer shadowOffset;
    Integer shadowDepth;
    Integer shadowAlpha;
    Boolean highlightMouseOver;
    Boolean highlightMouseDown;
    String[] highlightColors;
    String dataLabels;
    Boolean showDataLabels;
    String dataLabelFormatString;
    Integer dataLabelPositionFactor;
    Integer dataLabelThreshold;
    Integer dataLabelNudge;
    Boolean dataLabelCenter;
    Integer startAngle;

    @Override
    public ChartSeries.ChartType getDefaultType() {
        if (this.getData() == null || this.getData().size() < 2) {
            return SectorType.PIE;
        }
        return SectorType.DONUT;
    }

    public void add(String key, Object val) {
        this.getData().add(new SimpleEntry<String, Object>(key, val));
    }

    @Override
    public JSONBuilder getDataJSON(UIComponent chart) {
        JSONBuilder builder = super.getDataJSON(chart);
        Class valueType = null;
        for (Object x : this.getData()) {
            SimpleEntry s = (SimpleEntry)x;
            Object value = s.getValue();
            if (valueType == null) {
                if (value instanceof Number) {
                    valueType = Number.class;
                } else if (value instanceof String) {
                    valueType = String.class;
                }
            }
            if (valueType == Number.class) {
                builder.beginArray().item((String)s.getKey()).item(((Number)value).doubleValue()).endArray();
                continue;
            }
            if (valueType != String.class) continue;
            builder.beginArray().item((String)s.getKey()).item((String)value).endArray();
        }
        builder.endArray();
        return builder;
    }

    @Override
    public JSONBuilder getConfigJSON(UIComponent component) {
        JSONBuilder cfg = super.getConfigJSON(component);
        if (this.type != null) {
            if (this.type.equals(SectorType.PIE)) {
                cfg.entry("renderer", "ice.ace.jq.jqplot.PieRenderer", true);
            } else if (this.type.equals(SectorType.DONUT)) {
                cfg.entry("renderer", "ice.ace.jq.jqplot.DonutRenderer", true);
            }
        }
        if (this.hasRenderOptionsSet()) {
            cfg.beginMap("rendererOptions");
            String labels = this.getDataLabels();
            Integer sliceMargin = this.getSliceMargin();
            Boolean showLabels = this.getShowDataLabels();
            Boolean fill = this.getFill();
            if (labels != null) {
                cfg.entry("dataLabels", labels);
            }
            if (showLabels != null) {
                cfg.entry("showDataLabels", showLabels);
            }
            if (fill != null) {
                cfg.entry("fill", fill);
            }
            if (sliceMargin != null) {
                cfg.entry("sliceMargin", sliceMargin);
            }
            cfg.endMap();
        }
        cfg.endMap();
        return cfg;
    }

    private boolean hasRenderOptionsSet() {
        return this.getShowDataLabels() != null || this.getShowDataLabels() != null || this.getFill() != null || this.getSliceMargin() != null;
    }

    public String getDataLabels() {
        return this.dataLabels;
    }

    public void setDataLabels(String dataLabels) {
        this.dataLabels = dataLabels;
    }

    public Boolean getShowDataLabels() {
        return this.showDataLabels;
    }

    public void setShowDataLabels(Boolean showDataLabels) {
        this.showDataLabels = showDataLabels;
    }

    public Integer getSliceMargin() {
        return this.sliceMargin;
    }

    public void setSliceMargin(Integer sliceMargin) {
        this.sliceMargin = sliceMargin;
    }

    public static enum SectorType implements ChartSeries.ChartType
    {
        PIE,
        DONUT;

    }
}

