/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.ace.util.JSONBuilder;

public class CoreRenderer
extends Renderer {
    public static String resolveWidgetVar(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)component.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + component.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    protected void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    protected String getActionURL(FacesContext facesContext) {
        String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
        return facesContext.getExternalContext().encodeActionURL(actionURL);
    }

    protected String getResourceURL(FacesContext facesContext, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        return facesContext.getExternalContext().encodeResourceURL(url);
    }

    protected String getResourceRequestPath(FacesContext facesContext, String resourceName) {
        Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, "icefaces.ace");
        return resource.getRequestPath();
    }

    public boolean isPostback(FacesContext facesContext) {
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public boolean isAjaxRequest(FacesContext facesContext) {
        return facesContext.getPartialViewContext().isAjaxRequest();
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected boolean isPostBack() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public String getEscapedClientId(String clientId) {
        return clientId.replaceAll(":", "\\\\\\\\:");
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected String addSubmitParam(String parent, String name, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(".addSubmitParam('").append(parent).append("','").append(name).append("','").append(value).append("')");
        return builder.toString();
    }

    protected String escapeText(String value) {
        return value == null ? "" : value.replaceAll("'", "\\\\'");
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component, JSONBuilder jb) throws IOException {
        Map behaviorEvents = component.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            jb.beginMap("behaviors");
            Iterator eventIterator = behaviorEvents.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event;
                String domEvent = event = (String)eventIterator.next();
                if (event.equalsIgnoreCase("valueChange")) {
                    domEvent = "change";
                } else if (event.equalsIgnoreCase("action")) {
                    domEvent = "click";
                }
                String script = null;
                ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params);
                for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                    if (behavior instanceof AjaxBehavior) continue;
                    script = behavior.getScript(cbc);
                    break;
                }
                if (script == null || script.trim().length() <= 0) continue;
                jb.entry(domEvent, script, true);
            }
            jb.endMap();
        }
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map behaviorEvents = component.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            writer.write(",behaviors:{");
            Iterator eventIterator = behaviorEvents.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event;
                String domEvent = event = (String)eventIterator.next();
                if (event.equalsIgnoreCase("valueChange")) {
                    domEvent = "change";
                } else if (event.equalsIgnoreCase("action")) {
                    domEvent = "click";
                }
                ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params);
                String script = null;
                for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                    if (behavior instanceof AjaxBehavior) continue;
                    script = behavior.getScript(cbc);
                    break;
                }
                if (script != null && script.trim().length() > 0) {
                    writer.write(domEvent + " : ");
                    writer.write(script);
                }
                if (!eventIterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("}");
        }
    }

    protected boolean themeForms() {
        FacesContext context = FacesContext.getCurrentInstance();
        String value = context.getExternalContext().getInitParameter("org.icefaces.ace.themeForms");
        return value == null ? true : Boolean.valueOf(value);
    }

    protected void addToAutoUpdate(String clientId) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map viewMap = context.getViewRoot().getViewMap();
        HashSet<String> autoUpdateIds = (HashSet<String>)viewMap.get("org.icefaces.ace.autoUpdate");
        if (autoUpdateIds == null) {
            autoUpdateIds = new HashSet<String>();
            autoUpdateIds.add(clientId);
        }
        viewMap.put("org.icefaces.ace.autoUpdate", autoUpdateIds);
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (null != behaviorEvent && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && !behaviorsForEvent.isEmpty()) {
            String behaviorSource = (String)params.get("javax.faces.source");
            String clientId = component.getClientId();
            if (behaviorSource != null && behaviorSource.startsWith(clientId)) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
        }
    }
}

