/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.faces.webapp.parser.NameRule;
import com.icesoft.jasper.xmlparser.ParserUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagToComponentMap
implements Serializable {
    public static final String XHTML_COMPONENT_TYPE = "com.icesoft.faces.XhtmlComponent";
    public static final String XHTML_COMPONENT_CLASS = "com.icesoft.faces.component.UIXhtmlComponent";
    private static ClassLoader loader = TagToComponentMap.class.getClassLoader();
    private static final Log log = LogFactory.getLog(TagToComponentMap.class);
    private Hashtable tagToComponentMap = new Hashtable();
    private Writer faceletsTaglibXmlWriter;

    private void setFaceletsTaglibXmlWriter(Writer writer) {
        this.faceletsTaglibXmlWriter = writer;
    }

    static TagToComponentMap loadFrom(InputStream fis) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream ois = new ObjectInputStream(fis);
            return (TagToComponentMap)ois.readObject();
        }
        catch (IOException e) {
            log.error((Object)"Error building map from TLD tag names", (Throwable)e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error building map from TLD tag names", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            return new TagToComponentMap();
        }
    }

    public Hashtable getTagToComponentMap() {
        return this.tagToComponentMap;
    }

    public void addTagAttrib(InputStream tldInput) throws IOException {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.setEntityResolver(ParserUtils.entityResolver);
        digester.setUseContextClassLoader(false);
        digester.setClassLoader(loader);
        digester.addObjectCreate("taglib/tag", "com.icesoft.faces.webapp.parser.TagToTagClassElement");
        digester.addObjectCreate("taglib/uri", "java.lang.StringBuffer");
        NameRule nRule = new NameRule(this.tagToComponentMap, this.faceletsTaglibXmlWriter);
        digester.addRule("taglib/tag", (Rule)nRule);
        digester.addRule("taglib/uri", (Rule)nRule);
        digester.addCallMethod("taglib/tag/name", "setTagName", 0);
        digester.addCallMethod("taglib/tag/tag-class", "setTagClass", 0);
        digester.addCallMethod("taglib/tag/description", "setDescription", 0);
        digester.addCallMethod("taglib/uri", "append", 0);
        digester.addObjectCreate("taglib/tag/attribute", "com.icesoft.faces.webapp.parser.AttributeElement");
        digester.addCallMethod("taglib/tag/attribute/name", "setName", 0);
        digester.addCallMethod("taglib/tag/attribute/required", "setRequired", 0);
        digester.addCallMethod("taglib/tag/attribute/description", "setDescription", 0);
        digester.addSetNext("taglib/tag/attribute", "addAttribute");
        try {
            digester.parse(tldInput);
        }
        catch (Throwable e) {
            IOException ioe = new IOException("Can't parse tld " + tldInput.toString());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            tldInput.close();
        }
    }

    public static void main(String[] args) {
        FileInputStream tldFile = null;
        TagToComponentMap map = new TagToComponentMap();
        if (args[0].equals("new")) {
            for (int i = 2; i < args.length; ++i) {
                try {
                    tldFile = new FileInputStream(args[i]);
                    map.addTagAttrib(tldFile);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(args[1]);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(map);
                oos.flush();
                oos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (args[0].equals("old")) {
            try {
                FileInputStream fis = new FileInputStream(args[1]);
                ObjectInputStream ois = new ObjectInputStream(fis);
                map = (TagToComponentMap)ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (args[0].equals("facelets")) {
            try {
                FileWriter faceletsTaglibXmlWriter = new FileWriter(args[1]);
                String preamble = "<?xml version=\"1.0\"?>\n<facelet-taglib xmlns=\"http://java.sun.com/xml/ns/javaee\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facelettaglibrary_2_0.xsd\"\nversion=\"2.0\">\n";
                String trailer = "</facelet-taglib>\n";
                faceletsTaglibXmlWriter.write(preamble);
                map.setFaceletsTaglibXmlWriter(faceletsTaglibXmlWriter);
                tldFile = new FileInputStream(args[2]);
                map.addTagAttrib(tldFile);
                faceletsTaglibXmlWriter.write(trailer);
                faceletsTaglibXmlWriter.flush();
                faceletsTaglibXmlWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

