/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.utils;

import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.utils.MessageUtils;
import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatableProperty
implements Serializable {
    private static final Log log = LogFactory.getLog(UpdatableProperty.class);
    private String name;
    private Object savedValue;
    private boolean haveSavedValue;
    private Object submittedValue;
    private boolean setSubmittedInLocalValue;
    private Object value;
    private boolean setLocalValueInValueBinding;

    public UpdatableProperty(String name) {
        this.name = name;
    }

    public void saveValue(FacesContext context, UIComponent comp) {
        this.savedValue = this.getValue(context, comp);
        this.haveSavedValue = true;
    }

    public Object getSavedValue(FacesContext context, UIComponent comp) {
        if (this.haveSavedValue) {
            return this.savedValue;
        }
        return this.getValue(context, comp);
    }

    public Object getSubmittedValue(UIComponent comp) {
        return this.submittedValue;
    }

    public void setSubmittedValue(UIComponent comp, Object newSubmittedValue) {
        this.submittedValue = newSubmittedValue;
        this.setSubmittedInLocalValue = true;
    }

    protected void clearSubmittedValue() {
        this.submittedValue = null;
        this.setSubmittedInLocalValue = false;
    }

    public Object getValue(FacesContext context, UIComponent comp) {
        if (this.value != null) {
            return this.value;
        }
        ValueBinding vb = comp.getValueBinding(this.name);
        if (vb != null) {
            Object modelValue = vb.getValue(context);
            return modelValue;
        }
        return null;
    }

    public void setValue(UIComponent comp, Object newValue) {
        this.value = newValue;
        this.setLocalValueInValueBinding = true;
    }

    protected void clearValue() {
        this.value = null;
        this.setLocalValueInValueBinding = false;
    }

    protected void discontinueSettingLocalValueInValueBinding() {
        this.setLocalValueInValueBinding = false;
    }

    public void validate(FacesContext context, UIComponent comp) {
        if (!this.isComponentValid(comp)) {
            return;
        }
        if (this.setSubmittedInLocalValue) {
            this.setValue(comp, this.submittedValue);
            this.clearSubmittedValue();
        }
    }

    public void updateModel(FacesContext context, UIComponent comp) {
        if (!this.isComponentValid(comp) || !this.setLocalValueInValueBinding) {
            return;
        }
        ValueBinding vb = comp.getValueBinding(this.name);
        if (vb == null) {
            return;
        }
        try {
            vb.setValue(context, this.value);
            this.clearValue();
        }
        catch (PropertyNotFoundException e) {
            log.info((Object)e);
            this.discontinueSettingLocalValueInValueBinding();
        }
        catch (Exception e) {
            String msgId = comp.getClass().getName() + '.' + this.name;
            Object label = MessageUtils.getComponentLabel(context, comp);
            FacesMessage msg = MessageUtils.getMessage(context, msgId, new Object[]{label, this.value});
            if (msg != null) {
                context.addMessage(comp.getClientId(context), msg);
            }
            this.setInvalid(comp);
        }
    }

    protected boolean isComponentValid(UIComponent comp) {
        if (comp instanceof UIInput) {
            return ((UIInput)comp).isValid();
        }
        return true;
    }

    protected void setInvalid(UIComponent comp) {
        if (comp instanceof UIInput) {
            ((UIInput)comp).setValid(false);
        }
    }

    private String getDesc(UIComponent comp, String meth) {
        StringBuffer sb = new StringBuffer(256);
        if (comp != null) {
            String className = comp.getClass().getName();
            int index = className.lastIndexOf(46);
            if (index >= 0) {
                className = className.substring(index + 1);
            }
            sb.append(className);
            sb.append('.');
        }
        sb.append(meth);
        sb.append("  name: ");
        sb.append(this.name);
        if (comp != null) {
            sb.append("  clientId: ");
            sb.append(comp.getClientId(FacesContext.getCurrentInstance()));
        }
        return sb.toString();
    }

    public Object[] saveState(UIComponent comp) {
        Object[] state = new Object[]{this.name, this.savedValue, new Boolean(this.haveSavedValue), this.submittedValue, new Boolean(this.setSubmittedInLocalValue), this.value, new Boolean(this.setLocalValueInValueBinding)};
        return state;
    }

    public void restoreState(UIComponent comp, Object[] state) {
        this.name = (String)state[0];
        this.savedValue = state[1];
        this.haveSavedValue = (Boolean)state[2];
        this.submittedValue = state[3];
        this.setSubmittedInLocalValue = (Boolean)state[4];
        this.value = state[5];
        this.setLocalValueInValueBinding = (Boolean)state[6];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdatableProperty)) {
            return false;
        }
        UpdatableProperty up = (UpdatableProperty)obj;
        if (this.haveSavedValue != up.haveSavedValue) {
            return false;
        }
        if (this.setSubmittedInLocalValue != up.setSubmittedInLocalValue) {
            return false;
        }
        if (this.setLocalValueInValueBinding != up.setLocalValueInValueBinding) {
            return false;
        }
        if (!CoreUtils.objectsEqual(this.name, up.name)) {
            return false;
        }
        if (!CoreUtils.objectsEqual(this.savedValue, up.savedValue)) {
            return false;
        }
        if (!CoreUtils.objectsEqual(this.submittedValue, up.submittedValue)) {
            return false;
        }
        return CoreUtils.objectsEqual(this.value, up.value);
    }
}

