/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;

public class GMapResourceHandler
extends ResourceHandlerWrapper {
    private ResourceHandler handler;
    private String gmapKey;

    public GMapResourceHandler(ResourceHandler handler) {
        this.handler = handler;
        this.gmapKey = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.icesoft.faces.gmapKey");
    }

    public ResourceHandler getWrapped() {
        return this.handler;
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        if ("gmap/gmap.js".equals(resourceName) && this.gmapKey != null) {
            Resource resource = super.createResource(resourceName, libraryName, contentType);
            return new URIResource(resource, "http://maps.google.com/maps?file=api&v=2&key=" + this.gmapKey);
        }
        return super.createResource(resourceName, libraryName, contentType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class URIResource
    extends Resource {
        private final Resource resource;
        private String uri;

        private URIResource(Resource resource, String uri) {
            this.resource = resource;
            this.uri = uri;
        }

        public InputStream getInputStream() throws IOException {
            return this.resource.getInputStream();
        }

        public Map<String, String> getResponseHeaders() {
            return this.resource.getResponseHeaders();
        }

        public String getRequestPath() {
            return this.uri;
        }

        public URL getURL() {
            return this.resource.getURL();
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            return this.resource.userAgentNeedsUpdate(context);
        }
    }
}

