/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceLinker;
import com.icesoft.faces.context.ResourceRegistry;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.icefaces.impl.push.DynamicResourceRegistry;
import org.icefaces.impl.push.http.DynamicResource;
import org.icefaces.impl.push.http.DynamicResourceLinker;

public class ResourceRegistryLocator {
    public static ResourceRegistry locate(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        if (applicationMap.containsKey(ResourceRegistry.class.getName())) {
            return (ResourceRegistry)applicationMap.get(ResourceRegistry.class.getName());
        }
        DynamicResourceDispatcherAdapter registry = new DynamicResourceDispatcherAdapter(DynamicResourceRegistry.Locator.locate((FacesContext)context), context);
        applicationMap.put(ResourceRegistry.class.getName(), registry);
        return registry;
    }

    public static interface ExtendedResourceOptions
    extends Resource.Options {
        public void setContentDispositionFileName(String var1);
    }

    private static class DynamicResourceDispatcherAdapter
    implements ResourceRegistry {
        private ArrayList cssRuleURIs = new ArrayList();
        private ArrayList jsCodeURIs = new ArrayList();
        private DynamicResourceRegistry resourceDispatcher;

        private DynamicResourceDispatcherAdapter(DynamicResourceRegistry resourceDispatcher, FacesContext context) {
            this.resourceDispatcher = resourceDispatcher;
        }

        public URI loadJavascriptCode(Resource resource) {
            String uri = this.resourceDispatcher.registerResource((DynamicResource)new DynamicResourceAdapter(resource)).toString();
            if (!this.jsCodeURIs.contains(uri)) {
                this.jsCodeURIs.add(uri);
            }
            return this.resolve(uri);
        }

        public URI loadJavascriptCode(Resource resource, ResourceLinker.Handler linkerHandler) {
            String uri = this.resourceDispatcher.registerResource((DynamicResource)new DynamicResourceAdapter(resource), (DynamicResourceLinker.Handler)new DynamicHandlerAdapter(linkerHandler)).toString();
            if (!this.jsCodeURIs.contains(uri)) {
                this.jsCodeURIs.add(uri);
            }
            return this.resolve(uri);
        }

        public URI loadCSSRules(Resource resource) {
            String uri = this.resourceDispatcher.registerResource((DynamicResource)new DynamicResourceAdapter(resource)).toString();
            if (!this.cssRuleURIs.contains(uri)) {
                this.cssRuleURIs.add(uri);
            }
            return this.resolve(uri);
        }

        public URI loadCSSRules(Resource resource, ResourceLinker.Handler linkerHandler) {
            String uri = this.resourceDispatcher.registerResource((DynamicResource)new DynamicResourceAdapter(resource), (DynamicResourceLinker.Handler)new DynamicHandlerAdapter(linkerHandler)).toString();
            if (!this.cssRuleURIs.contains(uri)) {
                this.cssRuleURIs.add(uri);
            }
            return this.resolve(uri);
        }

        public URI registerResource(Resource resource) {
            return this.resolve(this.resourceDispatcher.registerResource((DynamicResource)new DynamicResourceAdapter(resource)).toString());
        }

        public URI registerResource(Resource resource, ResourceLinker.Handler linkerHandler) {
            return this.resolve(this.resourceDispatcher.registerResource((DynamicResource)new DynamicResourceAdapter(resource), (DynamicResourceLinker.Handler)new DynamicHandlerAdapter(linkerHandler)).toString());
        }

        private URI resolve(String uri) {
            FacesContext context = FacesContext.getCurrentInstance();
            return URI.create(CoreUtils.resolveResourceURL(context, uri));
        }

        private static class DynamicHandlerAdapter
        implements DynamicResourceLinker.Handler {
            private final ResourceLinker.Handler linkerHandler;

            public DynamicHandlerAdapter(ResourceLinker.Handler linkerHandler) {
                this.linkerHandler = linkerHandler;
            }

            public void linkWith(final DynamicResourceLinker linker) {
                this.linkerHandler.linkWith(new ResourceLinker(){

                    public void registerRelativeResource(String path, Resource resource) {
                        linker.registerRelativeResource(path, (DynamicResource)new DynamicResourceAdapter(resource));
                    }
                });
            }
        }

        private static class DynamicResourceAdapter
        implements DynamicResource,
        Serializable {
            private final Resource resource;

            public DynamicResourceAdapter(Resource resource) {
                this.resource = resource;
            }

            public String calculateDigest() {
                return this.resource.calculateDigest();
            }

            public InputStream open() throws IOException {
                return this.resource.open();
            }

            public Date lastModified() {
                return this.resource.lastModified();
            }

            public void withOptions(final DynamicResource.Options options) throws IOException {
                this.resource.withOptions(new Resource.Options(){

                    public void setMimeType(String mimeType) {
                        options.setMimeType(mimeType);
                    }

                    public void setLastModified(Date date) {
                        options.setLastModified(date);
                    }

                    public void setFileName(String fileName) {
                        options.setFileName(fileName);
                    }

                    public void setExpiresBy(Date date) {
                        options.setExpiresBy(date);
                    }

                    public void setAsAttachement() {
                        options.setAsAttachement();
                    }
                });
            }
        }
    }
}

