/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.component.dataexporter.OutputTypeHandler;
import java.io.FileWriter;
import java.io.IOException;

public class CSVOutputHandler
extends OutputTypeHandler {
    StringBuffer buffer = new StringBuffer();
    int rowIndex = 0;

    public CSVOutputHandler(String path) {
        super(path);
        this.mimeType = "text/csv";
    }

    public void flushFile() {
        this.deleteComma();
        try {
            FileWriter fw = new FileWriter(this.getFile());
            fw.write(this.buffer.toString());
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void writeCell(Object output, int col, int row) {
        if (row != this.rowIndex) {
            this.deleteComma();
            this.buffer.append("\n");
            ++this.rowIndex;
        }
        this.buffer.append(this.escapeString(output));
        this.buffer.append(",");
    }

    public void writeHeaderCell(String text, int col) {
    }

    private void deleteComma() {
        int comma = this.buffer.lastIndexOf(",");
        if (comma > 0) {
            this.buffer.deleteCharAt(comma);
        }
    }

    protected String escapeString(Object output) {
        boolean addDoubleQuotes;
        if (output == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(output.toString());
        boolean bl = addDoubleQuotes = sb.indexOf(",") >= 0;
        if (sb.indexOf("\"") >= 0) {
            addDoubleQuotes = true;
            for (int i = sb.length() - 1; i >= 0; --i) {
                if (sb.charAt(i) != '\"') continue;
                sb.insert(i, '\"');
            }
        }
        if (addDoubleQuotes) {
            sb.insert(0, '\"');
            sb.append('\"');
        }
        return sb.toString();
    }
}

