/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputrichtext;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.util.CoreUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

@ResourceDependencies(value={@ResourceDependency(name="ckeditor/ckeditor.mapping.js", library="inputrichtext"), @ResourceDependency(name="ckeditor/ckeditor.js", library="inputrichtext"), @ResourceDependency(name="ckeditor_ext.js", library="inputrichtext")})
public class InputRichText
extends UIInput {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.InputRichText";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.InputRichTextRenderer";
    private Boolean partialSubmit = null;
    private String language;
    private String _for;
    private String style;
    private String styleClass;
    private String width;
    private String height;
    private String toolbar;
    private String customConfigPath;
    private Boolean disabled = null;
    private String skin = null;
    private Boolean saveOnSubmit = null;

    public String getRendererType() {
        return DEFAULT_RENDERER_TYPE;
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    public void decode(FacesContext facesContext) {
        String clientId;
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId = this.getClientId(facesContext))) {
            String newValue = map.get(clientId).toString().replace('\n', ' ');
            this.setSubmittedValue(newValue);
        }
        super.decode(facesContext);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        if (this.language != null) {
            return this.language;
        }
        ValueBinding vb = this.getValueBinding("language");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "en";
    }

    public void setFor(String _for) {
        this._for = _for;
    }

    public String getFor() {
        if (this._for != null) {
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "";
    }

    boolean isToolbarOnly() {
        return false;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceInpRchTxt", "styleClass");
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "100%";
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "100";
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
        return output.toByteArray();
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public String getToolbar() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        ValueBinding vb = this.getValueBinding("toolbar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Default";
    }

    public void setCustomConfigPath(String customConfigPath) {
        this.customConfigPath = customConfigPath;
    }

    public String getCustomConfigPath() {
        if (this.customConfigPath != null) {
            return CoreUtils.resolveResourceURL(this.getFacesContext(), "/" + this.customConfigPath);
        }
        ValueBinding vb = this.getValueBinding("customConfigPath");
        return vb != null ? CoreUtils.resolveResourceURL(this.getFacesContext(), "/" + (String)vb.getValue(this.getFacesContext())) : null;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = new Boolean(disabled);
    }

    public boolean isDisabled() {
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getSkin() {
        if (this.skin != null) {
            return this.skin;
        }
        ValueBinding vb = this.getValueBinding("skin");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "default";
    }

    public void setSaveOnSubmit(boolean saveOnSubmit) {
        this.saveOnSubmit = new Boolean(saveOnSubmit);
    }

    public boolean isSaveOnSubmit() {
        if (this.saveOnSubmit != null) {
            return this.saveOnSubmit;
        }
        ValueBinding vb = this.getValueBinding("saveOnSubmit");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setPartialSubmit(boolean partialSubmit) {
        this.partialSubmit = partialSubmit;
    }

    public boolean getPartialSubmit() {
        if (this.partialSubmit != null) {
            return this.partialSubmit;
        }
        ValueBinding vb = this.getValueBinding("partialSubmit");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : Util.isParentPartialSubmit((UIComponent)this);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.customConfigPath, this.disabled, this._for, this.styleClass, this.height, this.language, this.saveOnSubmit, this.skin, this.style, this.toolbar, this.width, this.partialSubmit};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.customConfigPath = (String)values[1];
        this.disabled = (Boolean)values[2];
        this._for = (String)values[3];
        this.styleClass = (String)values[4];
        this.height = (String)values[5];
        this.language = (String)values[6];
        this.saveOnSubmit = (Boolean)values[7];
        this.skin = (String)values[8];
        this.style = (String)values[9];
        this.toolbar = (String)values[10];
        this.width = (String)values[11];
        this.partialSubmit = (Boolean)values[12];
    }
}

