/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.application;

import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.impl.util.FormEndRenderer;
import org.icefaces.impl.util.FormEndRendering;
import org.icefaces.util.EnvUtils;

public class ExtrasSetup
implements SystemEventListener {
    private static final ResourceBundle defaultBridgeMessages = new ListResourceBundle(){

        protected Object[][] getContents() {
            return new Object[][]{{"session-expired", "User Session Expired"}, {"connection-lost", "Network Connection Interrupted"}, {"server-error", "Server Internal Error"}, {"description", "To reconnect click the Reload button on the browser or click the button below"}, {"button-text", "Reload"}};
        }
    };
    private static final FormEndRenderer FormHiddenInputFields = new FormHiddenInputFieldsRenderer();
    private boolean fastBusyIndicator;
    private String compatResourceName;
    private String extraCompatResourceName;
    private boolean includeScrollOffsets;

    public ExtrasSetup() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.fastBusyIndicator = EnvUtils.isFastBusyIndicator((FacesContext)context);
        this.includeScrollOffsets = EnvUtils.isIncludeScrollOffsets((FacesContext)context);
        boolean developmentStage = context.isProjectStage(ProjectStage.Development);
        this.compatResourceName = developmentStage ? "compat.uncompressed.js" : "compat.js";
        this.extraCompatResourceName = developmentStage ? "icefaces-compat.uncompressed.js" : "icefaces-compat.js";
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (EnvUtils.isICEfacesView((FacesContext)context)) {
            UIViewRoot root = context.getViewRoot();
            root.addComponentResource(context, (UIComponent)new JavascriptResourceOutput(this.compatResourceName), "head");
            root.addComponentResource(context, (UIComponent)new JavascriptResourceOutput(this.extraCompatResourceName), "head");
            UIOutputWriter output = new UIOutputWriter(){

                public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                    ResourceBundle localizedBundle = defaultBridgeMessages;
                    try {
                        localizedBundle = ResourceBundle.getBundle("bridge-messages", context.getViewRoot().getLocale());
                    }
                    catch (MissingResourceException e) {
                        localizedBundle = defaultBridgeMessages;
                    }
                    String uri = EnvUtils.getConnectionLostRedirectURI((FacesContext)context);
                    String connectionLostRedirectURI = uri == null ? "null" : "'" + CoreUtils.resolveResourceURL(context, uri.replaceAll("'", "")) + "'";
                    uri = EnvUtils.getSessionExpiredRedirectURI((FacesContext)context);
                    String sessionExpiredRedirectURI = uri == null ? "null" : "'" + CoreUtils.resolveResourceURL(context, uri.replaceAll("'", "")) + "'";
                    String contextPath = CoreUtils.resolveResourceURL(context, "/");
                    writer.startElement("span", (UIComponent)this);
                    writer.writeAttribute("id", (Object)this.getClientId(context), null);
                    writer.startElement("script", (UIComponent)this);
                    writer.writeAttribute("type", (Object)"text/javascript", null);
                    writer.write("ice.includeScrollOffsets=" + ExtrasSetup.this.includeScrollOffsets + ";");
                    writer.write("ice.DefaultIndicators({");
                    writer.write("fastBusyIndicator: ");
                    writer.write(Boolean.toString(ExtrasSetup.this.fastBusyIndicator));
                    writer.write(",");
                    writer.write("connectionLostRedirectURI: ");
                    writer.write(connectionLostRedirectURI);
                    writer.write(",");
                    writer.write("sessionExpiredRedirectURI: ");
                    writer.write(sessionExpiredRedirectURI);
                    writer.write(",");
                    writer.write("connection: { context: '");
                    writer.write(contextPath);
                    writer.write("'},");
                    writer.write("messages: {");
                    writer.write("sessionExpired: '");
                    writer.write(localizedBundle.getString("session-expired"));
                    writer.write("',");
                    writer.write("connectionLost: '");
                    writer.write(localizedBundle.getString("connection-lost"));
                    writer.write("',");
                    writer.write("serverError: '");
                    writer.write(localizedBundle.getString("server-error"));
                    writer.write("',");
                    writer.write("description: '");
                    writer.write(localizedBundle.getString("description"));
                    writer.write("',");
                    writer.write("buttonText: '");
                    writer.write(localizedBundle.getString("button-text"));
                    writer.write("'");
                    writer.write("}},'");
                    writer.write(this.getClientId(context));
                    writer.write("');");
                    writer.endElement("script");
                    writer.endElement("span");
                }
            };
            output.setTransient(true);
            output.setId(BridgeSetup.getViewID((ExternalContext)context.getExternalContext()) + "_icefaces_compat_config");
            root.addComponentResource(context, (UIComponent)output, "body");
            FormEndRendering.addRenderer((FacesContext)context, (FormEndRenderer)FormHiddenInputFields);
        }
    }

    private static class FormHiddenInputFieldsRenderer
    implements FormEndRenderer {
        private FormHiddenInputFieldsRenderer() {
        }

        public void encode(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            String formClientID = component.getClientId(context);
            writer.startElement("span", component);
            writer.writeAttribute("id", (Object)(formClientID + "hdnFldsDiv"), null);
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)"icefacesCssUpdates", null);
            writer.writeAttribute("value", (Object)"", null);
            writer.endElement("input");
            Map requestMap = context.getExternalContext().getRequestMap();
            Map map = (Map)requestMap.get("com.icesoft.faces.FormRequiredHidden");
            if (map != null) {
                for (Map.Entry nextField : map.entrySet()) {
                    if (!"command_link_hidden_field".equals(nextField.getValue())) continue;
                    writer.startElement("input", component);
                    writer.writeAttribute("type", (Object)"hidden", null);
                    writer.writeAttribute("name", (Object)nextField.getKey().toString(), null);
                    writer.endElement("input");
                }
                requestMap.remove("com.icesoft.faces.FormRequiredHidden");
            }
            writer.endElement("span");
        }
    }

    public static class JavascriptResourceOutput
    extends UIOutput {
        public JavascriptResourceOutput(String path) {
            this.setRendererType("javax.faces.resource.Script");
            this.getAttributes().put("name", path);
            this.setTransient(true);
        }
    }
}

