/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext;

import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.panelseries.UISeries;
import com.icesoft.faces.context.effects.Effect;
import com.icesoft.faces.context.effects.Highlight;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;

public class HtmlDataTable
extends UISeries {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.HtmlDataTable";
    public static final String RENDERER_TYPE = "com.icesoft.faces.Table";
    private String renderedOnUserRole = null;
    private String sortColumn = null;
    private Boolean sortAscending = null;
    private Boolean resizable = null;
    private static final boolean DEFAULT_SORTASCENDING = true;
    private Boolean scrollable = null;
    private String columnWidths = null;
    private String scrollHeight = null;
    private String headerClasses = null;
    private Boolean clientOnly = null;
    private Boolean scrollFooter = null;
    private transient int colNumber = 0;
    String[] headerClassesArray = null;
    private String[] resizableTblColumnsWidth = new String[0];
    private int resizableTblColumnsWidthIndex = 0;
    private boolean isResizableColumnWidthsSet = false;

    public HtmlDataTable() {
        this.setRendererType(RENDERER_TYPE);
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    public String getSortColumn() {
        if (this.sortColumn != null) {
            return this.sortColumn;
        }
        ValueBinding vb = this.getValueBinding("sortColumn");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = new Boolean(sortAscending);
        ValueBinding vb = this.getValueBinding("sortAscending");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this.sortAscending);
            this.sortAscending = null;
        }
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
        ValueBinding vb = this.getValueBinding("sortColumn");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)this.sortColumn);
            this.sortColumn = null;
        }
    }

    public boolean isSortAscending() {
        if (this.sortAscending != null) {
            return this.sortAscending;
        }
        ValueBinding vb = this.getValueBinding("sortAscending");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.renderedOnUserRole, this.columnWidths, this.headerClasses, this.sortColumn, this.sortAscending, this.scrollHeight, this.scrollFooter, this.clientOnly, this.headerClassesArray, this.resizable, this.resizableTblColumnsWidth, new Integer(this.resizableTblColumnsWidthIndex), this.scrollable, this.isResizableColumnWidthsSet};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.renderedOnUserRole = (String)values[1];
        this.columnWidths = (String)values[2];
        this.headerClasses = (String)values[3];
        this.sortColumn = (String)values[4];
        this.sortAscending = (Boolean)values[5];
        this.scrollHeight = (String)values[6];
        this.scrollFooter = (Boolean)values[7];
        this.clientOnly = (Boolean)values[8];
        this.headerClassesArray = (String[])values[9];
        this.resizable = (Boolean)values[10];
        this.resizableTblColumnsWidth = (String[])values[11];
        this.resizableTblColumnsWidthIndex = (Integer)values[12];
        this.scrollable = (Boolean)values[13];
        this.isResizableColumnWidthsSet = (Boolean)values[14];
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    protected void iterate(FacesContext facesContext, PhaseId phase) {
        this.setRowIndex(-1);
        Iterator facets = this.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            UIComponent facet = this.getFacet(facets.next().toString());
            this.processKids(facesContext, phase, facet);
        }
        this.setRowIndex(-1);
        if (this.getChildCount() > 0) {
            for (UIComponent column : this.getChildren()) {
                if (!(column instanceof UIColumn) && !(column instanceof UIColumns) || !column.isRendered()) continue;
                if (column instanceof UIColumn) {
                    Iterator columnFacets = column.getFacets().keySet().iterator();
                    while (columnFacets.hasNext()) {
                        UIComponent columnFacet = (UIComponent)column.getFacets().get(columnFacets.next());
                        this.processKids(facesContext, phase, columnFacet);
                    }
                    continue;
                }
                if (!(column instanceof UIColumns)) continue;
                this.processKids(facesContext, phase, column);
            }
        }
        this.setRowIndex(-1);
        int rowsProcessed = 0;
        int currentRowIndex = this.getFirst() - 1;
        int displayedRows = this.getRows();
        while (++currentRowIndex < this.getRowCount() && (displayedRows <= 0 || ++rowsProcessed <= displayedRows)) {
            this.setRowIndex(currentRowIndex);
            if (!this.isRowAvailable()) break;
            if (this.getChildCount() <= 0) continue;
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIColumn) && !(child instanceof UIColumns)) continue;
                if (child instanceof UIColumn) {
                    if (child.getChildCount() <= 0) continue;
                    for (UIComponent granchild : child.getChildren()) {
                        if (!granchild.isRendered()) continue;
                        this.processKids(facesContext, phase, granchild);
                    }
                    continue;
                }
                if (!(child instanceof UIColumns)) continue;
                this.processKids(facesContext, phase, child);
            }
        }
        this.setRowIndex(-1);
    }

    protected void restoreChildrenState(FacesContext facesContext) {
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                if (kid instanceof UIColumn) {
                    this.restoreChildState(facesContext, kid);
                    continue;
                }
                this.resetChildClientId(facesContext, kid);
            }
        }
    }

    protected void resetChildClientId(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        component.setId(id);
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            this.resetChildClientId(facesContext, (UIComponent)children.next());
        }
    }

    protected void saveChildrenState(FacesContext facesContext) {
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof UIColumn)) continue;
                this.saveChildState(facesContext, kid);
            }
        }
    }

    public void processKids(FacesContext context, PhaseId phaseId, UIComponent kid) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            kid.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            kid.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            kid.processUpdates(context);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    public Boolean getScrollable() {
        return this.isScrollable();
    }

    public Boolean isScrollable() {
        if (this.scrollable != null) {
            return this.scrollable;
        }
        ValueBinding vb = this.getValueBinding("scrollable");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Boolean.FALSE;
    }

    public void setScrollable(Boolean scrollable) {
        this.scrollable = scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.setScrollable(new Boolean(scrollable));
    }

    public String getColumnWidths() {
        if (this.columnWidths != null) {
            return this.columnWidths;
        }
        ValueBinding vb = this.getValueBinding("columnWidths");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setColumnWidths(String columnWidths) {
        this.columnWidths = columnWidths;
    }

    public String getScrollHeight() {
        if (this.scrollHeight != null) {
            return this.scrollHeight;
        }
        ValueBinding vb = this.getValueBinding("scrollHeight");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setScrollHeight(String scrollHeight) {
        this.scrollHeight = scrollHeight;
    }

    public void setHeaderClasses(String headerClasses) {
        this.headerClasses = headerClasses;
    }

    public String getHeaderClasses() {
        if (this.headerClasses != null) {
            return this.headerClasses;
        }
        ValueBinding vb = this.getValueBinding("headerClasses");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getHeaderClassAtIndex(int index) {
        if (this.headerClassesArray == null) {
            this.headerClassesArray = this.getHeaderClasses().split(",");
        }
        if (this.headerClassesArray.length == 1) {
            return this.headerClassesArray[0];
        }
        try {
            return this.headerClassesArray[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return this.headerClassesArray[0];
        }
    }

    protected void restoreChild(FacesContext facesContext, UIComponent uiComponent) {
        super.restoreChild(facesContext, uiComponent);
        if (uiComponent instanceof UIData) {
            String clientId = uiComponent.getClientId(facesContext);
            Object value = this.savedChildren.get(clientId);
            ((UIData)uiComponent).setValue(value);
        }
    }

    protected void saveChild(FacesContext facesContext, UIComponent uiComponent) {
        super.saveChild(facesContext, uiComponent);
        if (uiComponent instanceof UIData) {
            String clientId = uiComponent.getClientId(facesContext);
            this.savedChildren.put(clientId, ((UIData)uiComponent).getValue());
        }
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, super.getStyleClass(), "iceDatTbl", "styleClass");
    }

    public String getHeaderClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, super.getHeaderClass(), "Hdr", "headerClass");
    }

    public String getFooterClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, super.getFooterClass(), "Ftr", "footerClass");
    }

    public boolean isResizable() {
        if (this.resizable != null) {
            return this.resizable;
        }
        ValueBinding vb = this.getValueBinding("resizable");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setResizable(boolean resizable) {
        this.resizable = new Boolean(resizable);
    }

    public boolean isClientOnly() {
        if (this.clientOnly != null) {
            return this.clientOnly;
        }
        ValueBinding vb = this.getValueBinding("clientOnly");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : true;
    }

    public void setClientOnly(boolean clientOnly) {
        this.clientOnly = clientOnly;
    }

    public void decode(FacesContext context) {
        String clientOnlyIdInParam;
        String clientOnlyId;
        super.decode(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey("ice.event.captured") && (clientOnlyId = this.getClientId(context) + "clientOnly").equals(clientOnlyIdInParam = String.valueOf(requestParameterMap.get("ice.event.captured")))) {
            String columnWidths = String.valueOf(requestParameterMap.get(clientOnlyId));
            this.resizableTblColumnsWidth = columnWidths.split(",");
            ValueBinding vb = this.getValueBinding("resizableColumnWidths");
            if (vb != null) {
                vb.setValue(context, (Object)columnWidths);
            }
        }
    }

    public String getNextResizableTblColumnWidth() {
        if (this.resizableTblColumnsWidthIndex < this.resizableTblColumnsWidth.length) {
            return this.resizableTblColumnsWidth[this.resizableTblColumnsWidthIndex++];
        }
        return null;
    }

    public void resetResizableTblColumnsWidthIndex() {
        this.resizableTblColumnsWidthIndex = 0;
    }

    public boolean isScrollFooter() {
        if (this.scrollFooter != null) {
            return this.scrollFooter;
        }
        ValueBinding vb = this.getValueBinding("scrollFooter");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : true;
    }

    public void setScrollFooter(boolean scrollFooter) {
        this.scrollFooter = scrollFooter;
    }

    public String getResizableColumnWidths() {
        if (this.isResizableColumnWidthsSet) {
            StringBuffer result = new StringBuffer();
            result.append(this.resizableTblColumnsWidth[0]);
            for (int i = 1; i < this.resizableTblColumnsWidth.length; ++i) {
                result.append(",");
                result.append(this.resizableTblColumnsWidth[i]);
            }
            return result.toString();
        }
        ValueBinding vb = this.getValueBinding("resizableColumnWidths");
        if (vb == null) {
            return null;
        }
        String columnWidths = (String)vb.getValue(this.getFacesContext());
        if (columnWidths != null) {
            this.resizableTblColumnsWidth = columnWidths.split(",");
        }
        return columnWidths;
    }

    public void setResizableColumnWidths(String columnWidths) {
        this.resizableTblColumnsWidth = columnWidths.split(",");
        this.isResizableColumnWidthsSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findRow(String query, String[] fields, int startRow, SearchType searchType, boolean caseSensitive) {
        int savedRowIndex = this.getRowIndex();
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        ELResolver resolver = elContext.getELResolver();
        this.setRowIndex(startRow);
        if (!caseSensitive) {
            query = query.toLowerCase();
        }
        try {
            if (searchType.equals((Object)SearchType.CONTAINS)) {
                while (this.isRowAvailable()) {
                    for (String s : fields) {
                        Object rowField = resolver.getValue(elContext, this.getRowData(), (Object)s);
                        String rowString = rowField.toString();
                        if (!caseSensitive) {
                            rowString = rowString.toLowerCase();
                        }
                        if (!rowString.contains(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            } else if (searchType.equals((Object)SearchType.ENDS_WITH)) {
                while (this.isRowAvailable()) {
                    for (String s : fields) {
                        Object rowField = resolver.getValue(elContext, this.getRowData(), (Object)s);
                        String rowString = rowField.toString();
                        if (!caseSensitive) {
                            rowString = rowString.toLowerCase();
                        }
                        if (!rowString.endsWith(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            } else if (searchType.equals((Object)SearchType.STARTS_WITH)) {
                while (this.isRowAvailable()) {
                    for (String s : fields) {
                        Object rowField = resolver.getValue(elContext, this.getRowData(), (Object)s);
                        String rowString = rowField.toString();
                        if (!caseSensitive) {
                            rowString = rowString.toLowerCase();
                        }
                        if (!rowString.startsWith(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            } else if (searchType.equals((Object)SearchType.EXACT)) {
                while (this.isRowAvailable()) {
                    for (String s : fields) {
                        Object rowField = resolver.getValue(elContext, this.getRowData(), (Object)s);
                        String rowString = rowField.toString();
                        if (!caseSensitive) {
                            rowString = rowString.toLowerCase();
                        }
                        if (!rowString.equals(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            }
            int n = -1;
            return n;
        }
        finally {
            this.setRowIndex(savedRowIndex);
        }
    }

    public int findRow(String query, String[] fields, int startRow, SearchType searchType) {
        return this.findRow(query, fields, startRow, searchType, true);
    }

    public int findRow(String query, String[] fields, int startRow) {
        return this.findRow(query, fields, startRow, SearchType.CONTAINS, true);
    }

    public void navigateToRow(int row, Effect effect) {
        if (row >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        String id = this.getClientId(context) + ":" + row;
        int rowsPerPage = this.getRows();
        if (rowsPerPage > 0) {
            int page = row / rowsPerPage;
            this.setFirst(page * rowsPerPage);
        }
        JavascriptContext.applicationFocus(context, id);
        if (effect != null) {
            JavascriptContext.fireEffect(effect, id, context);
        }
    }

    public void navigateToRow(int row) {
        this.navigateToRow(row, new Highlight("#fda505"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        STARTS_WITH,
        ENDS_WITH,
        EXACT,
        CONTAINS;

    }
}

