/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.paneldivider;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PanelDivider
extends UIPanel {
    private final Log log = LogFactory.getLog(PanelDivider.class);
    public static final String COMPONENT_TYPE = "com.icesoft.faces.PanelDivider";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.PanelDividerRenderer";
    private static final String INVALID_POSITION = " is invalid value for the position. The valid position is between  1 to 100. The default position is being applied [50]";
    public static final String FIRST_PANL_STYLE = "FirstPane";
    public static final String SECOND_PANL_STYLE = "SecondPane";
    public static final String IN_PERCENT = "InPercent";
    private String style = null;
    private String styleClass = null;
    private Integer dividerPosition = null;
    private String renderedOnUserRole = null;
    private String orientation = null;
    private transient String previousOrientation = null;
    private transient boolean decoded = false;
    private int DEFAULT_POSITION = 50;
    private int submittedDividerPosition = -1;

    public PanelDivider() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
        JavascriptContext.includeLib(JavascriptContext.ICE_EXTRAS, FacesContext.getCurrentInstance());
    }

    public void decode(FacesContext facesContext) {
        String clientId;
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.containsKey((clientId = this.getClientId(facesContext)) + IN_PERCENT) && map.get(clientId + IN_PERCENT) != null && !"".equals(map.get(clientId + IN_PERCENT))) {
            this.submittedDividerPosition = Integer.valueOf(String.valueOf(map.get(clientId + IN_PERCENT)));
            if (this.submittedDividerPosition >= 98) {
                this.submittedDividerPosition = 98;
            }
            this.DEFAULT_POSITION = this.submittedDividerPosition;
            this.decoded = true;
        } else {
            this.decoded = false;
        }
        super.decode(facesContext);
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        super.encodeBegin(facesContext);
        this.previousOrientation = this.getOrientation();
    }

    public void processUpdates(FacesContext context) {
        int pos;
        ValueBinding vb = this.getValueBinding("dividerPosition");
        if (this.decoded) {
            if (vb != null) {
                vb.setValue(context, (Object)new Integer(this.submittedDividerPosition));
            }
            if (this.dividerPosition != null) {
                this.dividerPosition = new Integer(this.submittedDividerPosition);
            }
        }
        if (!this.validatePosition(pos = this.getDividerPosition())) {
            FacesMessage message = new FacesMessage("[" + pos + "] " + INVALID_POSITION);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.log.info((Object)("[" + pos + "] " + INVALID_POSITION));
        }
        super.processUpdates(context);
    }

    UIComponent getFirstFacet() {
        return this.getFacet("first");
    }

    UIComponent getSecondFacet() {
        return this.getFacet("second");
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, this.isHorizontal() ? "icePnlDvrHor" : "icePnlDvr", "styleClass");
    }

    public String getFirstPaneClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Fst");
    }

    public String getSecondPaneClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Snd");
    }

    public String getSplitterClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Spt");
    }

    public String getContainerClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Cnt");
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public String getOrientation() {
        if (this.orientation != null) {
            return this.orientation;
        }
        ValueBinding vb = this.getValueBinding("orientation");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "vertical";
    }

    boolean isHorizontal() {
        return "horizontal".equalsIgnoreCase(this.getOrientation());
    }

    public void setDividerPosition(int dividerPosition) {
        this.dividerPosition = new Integer(dividerPosition);
    }

    public int getDividerPosition() {
        if (this.dividerPosition != null) {
            return this.dividerPosition;
        }
        ValueBinding vb = this.getValueBinding("dividerPosition");
        return vb != null ? (Integer)vb.getValue(this.getFacesContext()) : this.DEFAULT_POSITION;
    }

    String getPanePosition(boolean first) {
        int pos = this.getDividerPosition();
        if (!this.validatePosition(pos)) {
            pos = 50;
        }
        int panPos = 0;
        panPos = first ? pos - 1 : 98 - pos;
        String unit = "height:100%;width:";
        if (this.isHorizontal()) {
            unit = "width:100%;height:";
        }
        return unit + panPos + "%;";
    }

    private boolean validatePosition(int position) {
        return position > 0 && position <= 100;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.style, this.styleClass, this.dividerPosition, this.renderedOnUserRole, this.orientation, new Integer(this.submittedDividerPosition), new Integer(this.DEFAULT_POSITION)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.style = (String)values[1];
        this.styleClass = (String)values[2];
        this.dividerPosition = (Integer)values[3];
        this.renderedOnUserRole = (String)values[4];
        this.orientation = (String)values[5];
        this.submittedDividerPosition = (Integer)values[6];
        this.DEFAULT_POSITION = (Integer)values[7];
    }
}

