/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.style;

import com.icesoft.faces.component.style.OutputStyle;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.util.EnvUtils;
import org.w3c.dom.Element;

public class OutputStyleRenderer
extends DomBasicRenderer {
    private static Log log = LogFactory.getLog(OutputStyleRenderer.class);
    private static final String IE_EXTENTION = "_ie";
    private static final String IE_7_EXTENTION = "_ie7";
    private static final String IE_8_EXTENSION = "_ie8";
    private static final String SAFARI_EXTENTION = "_safari";
    private static final String SAFARI_MOBILE_EXTENTION = "_safarimobile";
    private static final String CSS_EXTENTION = ".css";
    private static final String DT_EXTENTION = "_dt";
    private static final String OPERA_EXTENTION = "_opera";
    private static final String OPERA_MOBILE_EXTENTION = "_operamobile";
    private static final int DEFAULT_TYPE = 0;
    private static final int IE = 1;
    private static final int SAFARI = 2;
    private static final int DT = 3;
    private static final int IE_7 = 4;
    private static final int SAFARI_MOBILE = 5;
    private static final int OPERA = 6;
    private static final int OPERA_MOBILE = 7;
    private static final int IE_8 = 8;
    String[] extensions = new String[]{"", "_ie", "_safari", "_dt", "_ie7", "_safarimobile", "_opera", "_operamobile", "_ie8"};
    private String browserSpecificFilename;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        OutputStyleRenderer.validateParameters(facesContext, uiComponent, OutputStyle.class);
        try {
            DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
            if (!domContext.isInitialized()) {
                OutputStyle outputStyle = (OutputStyle)uiComponent;
                Element styleEle = this.buildCssElement(domContext);
                String href = outputStyle.getHref();
                styleEle.setAttribute("href", OutputStyleRenderer.getResourceURL(facesContext, href));
                domContext.setRootNode(styleEle);
                int browserType = this.browserType(facesContext, uiComponent);
                if (browserType != 0) {
                    if (href.endsWith(CSS_EXTENTION)) {
                        int i = href.indexOf(CSS_EXTENTION);
                        if (i <= 0) throw new RuntimeException("OutputStyle file attribute is too short. Needs at least one character before .css. Current Value is [" + href + "]");
                        String start = href.substring(0, i);
                        Element ieStyleEle = this.buildCssElement(domContext);
                        String extention = IE_EXTENTION;
                        if (browserType == 2) {
                            extention = SAFARI_EXTENTION;
                        }
                        if (browserType == 3) {
                            extention = DT_EXTENTION;
                        }
                        if (browserType == 4) {
                            extention = IE_7_EXTENTION;
                        }
                        if (browserType == 8) {
                            extention = IE_8_EXTENSION;
                        }
                        if (browserType == 5) {
                            extention = SAFARI_MOBILE_EXTENTION;
                        }
                        if (browserType == 6) {
                            extention = OPERA_EXTENTION;
                        }
                        if (browserType == 7) {
                            extention = OPERA_MOBILE_EXTENTION;
                        }
                        if (this.useSpecific(facesContext, start, extention)) {
                            ieStyleEle.setAttribute("title", extention);
                            String hrefURL = CoreUtils.resolveResourceURL(facesContext, this.browserSpecificFilename);
                            ieStyleEle.setAttribute("href", hrefURL);
                            styleEle.getParentNode().appendChild(ieStyleEle);
                        }
                    } else {
                        Matcher matcher = Pattern.compile(".*javax\\.faces\\.resource/((.*)\\.css)(\\..*)?\\?ln=([^&]*)(&.*|$)").matcher(href);
                        if (matcher.matches()) {
                            Element ieStyleEle = this.buildCssElement(domContext);
                            String extension = browserType >= 0 && browserType < this.extensions.length ? this.extensions[browserType] : IE_EXTENTION;
                            ieStyleEle.setAttribute("title", extension);
                            String hrefURL = new StringBuffer(matcher.group(0)).insert(matcher.end(2), extension).toString();
                            ieStyleEle.setAttribute("href", hrefURL);
                            String resourceName = new StringBuffer(matcher.group(1)).insert(matcher.end(2) - matcher.start(2), extension).toString();
                            Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, matcher.group(4));
                            if (resource != null) {
                                styleEle.getParentNode().appendChild(ieStyleEle);
                            }
                        }
                    }
                }
            }
            domContext.stepOver();
            return;
        }
        catch (Exception e) {
            log.error((Object)"Error in OutputStyleRenderer", (Throwable)e);
        }
    }

    private Element buildCssElement(DOMContext domContext) {
        Element styleEle = domContext.createElement("link");
        styleEle.setAttribute("rel", "stylesheet");
        styleEle.setAttribute("type", "text/css");
        return styleEle;
    }

    private int browserType(FacesContext facesContext, UIComponent uiComponent) {
        int result = 0;
        String useragent = ((OutputStyle)uiComponent).getUserAgent();
        if (useragent != null) {
            return this._browserType(useragent);
        }
        Object o = facesContext.getExternalContext().getRequest();
        if (o != null) {
            if (!EnvUtils.instanceofPortletRequest((Object)o)) {
                HttpServletRequest request = (HttpServletRequest)o;
                useragent = request.getHeader("user-agent");
                if (useragent == null) {
                    useragent = ((OutputStyle)uiComponent).getUserAgent();
                }
                if (useragent == null) {
                    useragent = request.getHeader("User-Agent");
                }
                if (useragent == null) {
                    useragent = request.getHeader("USER-AGENT");
                }
                if (useragent == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Not able to find user agent. Returning default");
                    }
                    return 0;
                }
                if (((OutputStyle)uiComponent).getUserAgent() == null) {
                    ((OutputStyle)uiComponent).setUserAgent(useragent.toLowerCase());
                }
                String user = useragent.toLowerCase();
                result = this._browserType(user);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("OutputStyleRenderer: Request is not HttpServletRequest. Its [" + o.getClass().getName() + "]"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"IceStyleReader: facesContext.getExternalContext().getRequest() is null");
        }
        return result;
    }

    private int _browserType(String user) {
        int result = 0;
        if (Beans.isDesignTime()) {
            result = 3;
        } else if (user.indexOf("opera") < 0 && user.indexOf("msie") != -1) {
            result = 1;
            if (user.indexOf("msie 7") != -1) {
                result = 4;
            }
            if (user.indexOf("msie 8") != -1) {
                result = 8;
            }
        } else if (user.indexOf("safari") != -1) {
            result = 2;
            if (user.indexOf("mobile") != -1) {
                result = 5;
            }
        } else if (user.indexOf("opera") != -1) {
            result = 6;
            if (user.indexOf("240x320") != -1) {
                result = 7;
            }
        }
        return result;
    }

    private boolean useSpecific(FacesContext facesContext, String start, String extention) {
        boolean useSpecific = false;
        this.browserSpecificFilename = start + extention + CSS_EXTENTION;
        String realRoot = facesContext.getExternalContext().getRealPath("/");
        if (realRoot != null) {
            File realParent = new File(realRoot);
            if (this.browserSpecificFilename.startsWith("/")) {
                File browserSpecificFile = null;
                String contextName = null;
                Object servletContextObject = FacesContext.getCurrentInstance().getExternalContext().getContext();
                if (servletContextObject != null && servletContextObject instanceof ServletContext) {
                    contextName = ((ServletContext)servletContextObject).getContextPath();
                }
                if (contextName != null) {
                    String contextRoot = contextName + "/";
                    browserSpecificFile = this.browserSpecificFilename.startsWith(contextRoot) ? new File(realParent, this.browserSpecificFilename.substring(contextRoot.length())) : new File(realParent, this.browserSpecificFilename.substring(1));
                }
                useSpecific = browserSpecificFile != null ? browserSpecificFile.exists() : false;
            } else {
                String pathInfo = facesContext.getExternalContext().getRequestServletPath();
                if (pathInfo != null) {
                    pathInfo = new File(pathInfo).getParent();
                    File realPath = new File(realParent, pathInfo);
                    File browserSpecificFile = new File(realPath, this.browserSpecificFilename);
                    useSpecific = browserSpecificFile.exists();
                }
            }
        }
        return useSpecific;
    }
}

